/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.metadata.MetadataEncryptor;

public class MetadataEncryptorNode
implements MetadataNode {
    public static final String NAME = "encryptor";
    private final MetadataEncryptor encryptor;

    public MetadataEncryptorNode(MetadataEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public static void arrayToHex(byte[] array, StringBuilder bld) {
        for (int i = 0; i < array.length; ++i) {
            bld.append(String.format("%02x", array[i] & 0xFF));
        }
    }

    @Override
    public void print(MetadataNodePrinter printer) {
        StringBuilder bld = new StringBuilder();
        bld.append("MetadataEncryptor");
        bld.append("(class=").append(this.encryptor.getClass().getCanonicalName());
        bld.append(", id=").append(this.encryptor.id());
        bld.append(", secret=");
        if (printer.redactionCriteria().shouldRedactEncryptorSecret()) {
            bld.append("[redacted]");
        } else {
            MetadataEncryptorNode.arrayToHex(this.encryptor.secret(), bld);
        }
        bld.append(")");
        printer.output(bld.toString());
    }
}

