/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collection;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicsImageByTenantNameNode;
import org.apache.kafka.server.immutable.ImmutableSet;

public class TopicsImageByTenantNode
implements MetadataNode {
    public static final String NAME = "byTenant";
    private final TopicsImage image;

    public TopicsImageByTenantNode(TopicsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        return this.image.topicNamesByTenant().keySet();
    }

    @Override
    public MetadataNode child(String name) {
        ImmutableSet tenantTopics = (ImmutableSet)this.image.topicNamesByTenant().get((Object)name);
        if (tenantTopics == null) {
            return null;
        }
        return new TopicsImageByTenantNameNode(this.image, (ImmutableSet<String>)tenantTopics);
    }
}

