/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class PartitionRegistration {
    public final int[] replicas;
    public final int[] observers;
    public final int[] isr;
    public final int[] removingReplicas;
    public final int[] addingReplicas;
    public final int leader;
    public final LeaderRecoveryState leaderRecoveryState;
    public final int leaderEpoch;
    public final int partitionEpoch;
    public final int linkedLeaderEpoch;
    public final LinkState linkState;
    public final int[] removingObservers;
    public final int[] addingObservers;

    public static boolean electionWasClean(int newLeader, int[] isr) {
        return newLeader == -1 || Replicas.contains(isr, newLeader);
    }

    public PartitionRegistration(PartitionRecord record) {
        this(Replicas.toArray(record.replicas()), Replicas.toArray(record.observers()), Replicas.toArray(record.isr()), Replicas.toArray(record.removingReplicas()), Replicas.toArray(record.addingReplicas()), Replicas.toArray(record.removingObservers()), Replicas.toArray(record.addingObservers()), record.leader(), LeaderRecoveryState.of(record.leaderRecoveryState()), record.leaderEpoch(), record.partitionEpoch(), record.linkedLeaderEpoch(), LinkState.fromCode(record.linkState()));
    }

    private PartitionRegistration(int[] replicas, int[] observers, int[] isr, int[] removingReplicas, int[] addingReplicas, int[] removingObservers, int[] addingObservers, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch, int linkedLeaderEpoch, LinkState linkState) {
        this.replicas = replicas;
        this.observers = observers;
        this.isr = isr;
        this.removingReplicas = removingReplicas;
        this.addingReplicas = addingReplicas;
        this.leader = leader;
        this.leaderRecoveryState = leaderRecoveryState;
        this.leaderEpoch = leaderEpoch;
        this.partitionEpoch = partitionEpoch;
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        this.linkState = linkState;
        this.removingObservers = removingObservers;
        this.addingObservers = addingObservers;
    }

    public PartitionRegistration merge(PartitionChangeRecord record) {
        int newLinkedLeaderEpoch;
        LinkState newLinkState;
        int newLeaderEpoch;
        int newLeader;
        int[] newReplicas = record.replicas() == null ? this.replicas : Replicas.toArray(record.replicas());
        int[] newObservers = record.observers() == null ? this.observers : Replicas.toArray(record.observers());
        int[] newIsr = record.isr() == null ? this.isr : Replicas.toArray(record.isr());
        MergedReassignmentMetadata mergedReassignmentMetadata = MergedReassignmentMetadata.build(this, record);
        int[] newRemovingReplicas = mergedReassignmentMetadata.newRemovingReplicas;
        int[] newAddingReplicas = mergedReassignmentMetadata.newAddingReplicas;
        int[] newRemovingObservers = mergedReassignmentMetadata.newRemovingObservers;
        int[] newAddingObservers = mergedReassignmentMetadata.newAddingObservers;
        LinkState recordLinkState = LinkState.fromCode(record.linkState());
        if (this.linkState == LinkState.NOT_MIRROR && recordLinkState != LinkState.NOT_MIRROR) {
            throw new RuntimeException("Cannot merge a non-mirror partition registration with a mirror partition record");
        }
        if (record.leader() == -2) {
            newLeader = this.leader;
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch : Math.max(this.leaderEpoch, record.linkedLeaderEpoch());
        } else {
            newLeader = record.leader();
            newLeaderEpoch = this.linkState == LinkState.NOT_MIRROR ? this.leaderEpoch + 1 : Math.max(this.leaderEpoch + 1, record.linkedLeaderEpoch());
        }
        LeaderRecoveryState newLeaderRecoveryState = this.leaderRecoveryState.changeTo(record.leaderRecoveryState());
        if (this.linkState == LinkState.NOT_MIRROR) {
            newLinkState = this.linkState;
            newLinkedLeaderEpoch = this.linkedLeaderEpoch;
        } else {
            newLinkedLeaderEpoch = record.linkState() == LinkState.NOT_MIRROR.levelCode ? -1 : (record.linkedLeaderEpoch() == -1 ? this.linkedLeaderEpoch : record.linkedLeaderEpoch());
            newLinkState = recordLinkState;
        }
        return new PartitionRegistration(newReplicas, newObservers, newIsr, newRemovingReplicas, newAddingReplicas, newRemovingObservers, newAddingObservers, newLeader, newLeaderRecoveryState, newLeaderEpoch, this.partitionEpoch + 1, newLinkedLeaderEpoch, newLinkState);
    }

    public String diff(PartitionRegistration prev) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (!Arrays.equals(this.replicas, prev.replicas)) {
            builder.append(prefix).append("replicas: ").append(Arrays.toString(prev.replicas)).append(" -> ").append(Arrays.toString(this.replicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.observers, prev.observers)) {
            builder.append(prefix).append("observers: ").append(Arrays.toString(prev.observers)).append(" -> ").append(Arrays.toString(this.observers));
            prefix = ", ";
        }
        if (!Arrays.equals(this.isr, prev.isr)) {
            builder.append(prefix).append("isr: ").append(Arrays.toString(prev.isr)).append(" -> ").append(Arrays.toString(this.isr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingReplicas, prev.removingReplicas)) {
            builder.append(prefix).append("removingReplicas: ").append(Arrays.toString(prev.removingReplicas)).append(" -> ").append(Arrays.toString(this.removingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingReplicas, prev.addingReplicas)) {
            builder.append(prefix).append("addingReplicas: ").append(Arrays.toString(prev.addingReplicas)).append(" -> ").append(Arrays.toString(this.addingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingObservers, prev.removingObservers)) {
            builder.append(prefix).append("removingObservers: ").append(Arrays.toString(prev.removingObservers)).append(" -> ").append(Arrays.toString(this.removingObservers));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingObservers, prev.addingObservers)) {
            builder.append(prefix).append("addingObservers: ").append(Arrays.toString(prev.addingObservers)).append(" -> ").append(Arrays.toString(this.addingObservers));
            prefix = ", ";
        }
        if (this.leader != prev.leader) {
            builder.append(prefix).append("leader: ").append(prev.leader).append(" -> ").append(this.leader);
            prefix = ", ";
        }
        if (this.leaderRecoveryState != prev.leaderRecoveryState) {
            builder.append(prefix).append("leaderRecoveryState: ").append((Object)prev.leaderRecoveryState).append(" -> ").append((Object)this.leaderRecoveryState);
            prefix = ", ";
        }
        if (this.leaderEpoch != prev.leaderEpoch) {
            builder.append(prefix).append("leaderEpoch: ").append(prev.leaderEpoch).append(" -> ").append(this.leaderEpoch);
            prefix = ", ";
        }
        if (this.partitionEpoch != prev.partitionEpoch) {
            builder.append(prefix).append("partitionEpoch: ").append(prev.partitionEpoch).append(" -> ").append(this.partitionEpoch);
            prefix = ", ";
        }
        if (this.linkedLeaderEpoch != prev.linkedLeaderEpoch) {
            builder.append(prefix).append("linkedLeaderEpoch: ").append(prev.linkedLeaderEpoch).append(" -> ").append(this.linkedLeaderEpoch);
            prefix = ", ";
        }
        if (this.linkState != prev.linkState) {
            builder.append(prefix).append("linkedLeaderEpoch: ").append((Object)prev.linkState).append(" -> ").append((Object)this.linkState);
        }
        return builder.toString();
    }

    public PartitionRegistration unlink() {
        return new PartitionRegistration(this.replicas, this.observers, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch + 1, -1, LinkState.NOT_MIRROR);
    }

    public void maybeLogPartitionChange(Logger log, String description, PartitionRegistration prev) {
        if (!PartitionRegistration.electionWasClean(this.leader, prev.isr)) {
            log.info("UNCLEAN partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        } else if (log.isDebugEnabled()) {
            log.debug("partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        }
    }

    public boolean hasLeader() {
        return this.leader != -1;
    }

    public boolean hasPreferredLeader() {
        return this.leader == this.preferredReplica();
    }

    public int preferredReplica() {
        return this.replicas.length == 0 ? -1 : this.replicas[0];
    }

    public boolean isMirror() {
        return this.linkState != LinkState.NOT_MIRROR;
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId, ImageWriterOptions imageWriterOptions) {
        return this.toRecord(topicId, partitionId, Optional.of(imageWriterOptions));
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId) {
        return this.toRecord(topicId, partitionId, Optional.empty());
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId, Optional<ImageWriterOptions> imageWriterOptionsOpt) {
        PartitionRecord partitionRecord = new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(Replicas.toList(this.replicas)).setIsr(Replicas.toList(this.isr)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setLeader(this.leader).setLeaderRecoveryState(this.leaderRecoveryState.value()).setLeaderEpoch(this.leaderEpoch).setPartitionEpoch(this.partitionEpoch).setLinkedLeaderEpoch(this.linkedLeaderEpoch).setLinkState(this.linkState.levelCode);
        if (imageWriterOptionsOpt.isPresent() && !imageWriterOptionsOpt.get().metadataVersion().isTopicPlacementSupported() && this.containsObserverMetadata()) {
            imageWriterOptionsOpt.get().handleLoss("the observer metadata for topic " + topicId + ", partition " + partitionId + ".");
        } else {
            partitionRecord.setObservers(Replicas.toList(this.observers));
            partitionRecord.setRemovingObservers(Replicas.toList(this.removingObservers));
            partitionRecord.setAddingObservers(Replicas.toList(this.addingObservers));
        }
        return new ApiMessageAndVersion((ApiMessage)partitionRecord, 0);
    }

    private boolean containsObserverMetadata() {
        return this.observers.length > 0 || this.removingObservers.length > 0 || this.addingObservers.length > 0;
    }

    public LeaderAndIsrRequestData.LeaderAndIsrPartitionState toLeaderAndIsrPartitionState(TopicIdPartition tp, boolean isNew, Optional<MirrorTopic> mirrorTopicOptional, Function<PartitionRegistration, List<Integer>> addingSyncReplicas) {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState state = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitionIndex(tp.partition()).setControllerEpoch(-1).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setIsr(Replicas.toList(this.isr)).setPartitionEpoch(this.partitionEpoch).setReplicas(Replicas.toList(this.replicas)).setObservers(PartitionRegistration.effectiveObservers(Replicas.toList(this.observers), addingSyncReplicas.apply(this))).setAddingReplicas(Replicas.toList(this.addingReplicas)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setLeaderRecoveryState(this.leaderRecoveryState.value()).setIsNew(isNew);
        mirrorTopicOptional.ifPresent(mirrorTopic -> {
            state.setLinkedLeaderEpoch(this.linkedLeaderEpoch).setClusterLinkTopicState(mirrorTopic.mirrorState().stateName()).setClusterLinkId(Utils.toJavaUuid((Uuid)mirrorTopic.linkId()).toString()).setClusterLinkSourceTopicId(mirrorTopic.sourceTopicId());
            if (mirrorTopic.mirrorStartOffsets() != null && mirrorTopic.mirrorStartOffsets().size() > tp.partition()) {
                state.setMirrorStartOffset(mirrorTopic.mirrorStartOffsets().get(tp.partition()).longValue());
            }
        });
        return state;
    }

    static List<Integer> effectiveObservers(List<Integer> observers, List<Integer> addingSyncReplicas) {
        ArrayList<Integer> replicas = new ArrayList<Integer>(observers);
        replicas.removeAll(addingSyncReplicas);
        return replicas;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.replicas), Arrays.hashCode(this.observers), Arrays.hashCode(this.isr), Arrays.hashCode(this.removingReplicas), Arrays.hashCode(this.addingReplicas), Arrays.hashCode(this.removingObservers), Arrays.hashCode(this.addingObservers), this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch, this.linkedLeaderEpoch, this.linkState.levelCode});
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionRegistration)) {
            return false;
        }
        PartitionRegistration other = (PartitionRegistration)o;
        return Arrays.equals(this.replicas, other.replicas) && Arrays.equals(this.observers, other.observers) && Arrays.equals(this.isr, other.isr) && Arrays.equals(this.removingReplicas, other.removingReplicas) && Arrays.equals(this.addingReplicas, other.addingReplicas) && Arrays.equals(this.removingObservers, other.removingObservers) && Arrays.equals(this.addingObservers, other.addingObservers) && this.leader == other.leader && this.leaderRecoveryState == other.leaderRecoveryState && this.leaderEpoch == other.leaderEpoch && this.partitionEpoch == other.partitionEpoch && this.linkedLeaderEpoch == other.linkedLeaderEpoch && this.linkState == other.linkState;
    }

    public PartitionRegistration withoutLink() {
        return new PartitionRegistration(this.replicas, this.observers, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch + 1, this.partitionEpoch, -1, LinkState.NOT_MIRROR);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartitionRegistration(");
        builder.append("replicas=").append(Arrays.toString(this.replicas));
        builder.append(", observers=").append(Arrays.toString(this.observers));
        builder.append(", isr=").append(Arrays.toString(this.isr));
        builder.append(", removingReplicas=").append(Arrays.toString(this.removingReplicas));
        builder.append(", addingReplicas=").append(Arrays.toString(this.addingReplicas));
        builder.append(", removingObservers=").append(Arrays.toString(this.removingObservers));
        builder.append(", addingObservers=").append(Arrays.toString(this.addingObservers));
        builder.append(", leader=").append(this.leader);
        builder.append(", leaderRecoveryState=").append((Object)this.leaderRecoveryState);
        builder.append(", leaderEpoch=").append(this.leaderEpoch);
        builder.append(", partitionEpoch=").append(this.partitionEpoch);
        builder.append(", linkedLeaderEpoch=").append(this.linkedLeaderEpoch);
        builder.append(", linkState=").append((Object)this.linkState);
        builder.append(")");
        return builder.toString();
    }

    public boolean hasSameAssignment(PartitionRegistration registration) {
        return Arrays.equals(this.replicas, registration.replicas) && Arrays.equals(this.addingReplicas, registration.addingReplicas) && Arrays.equals(this.removingReplicas, registration.removingReplicas);
    }

    private static class MergedReassignmentMetadata {
        final int[] newRemovingReplicas;
        final int[] newAddingReplicas;
        final int[] newRemovingObservers;
        final int[] newAddingObservers;

        public MergedReassignmentMetadata(int[] newRemovingReplicas, int[] newAddingReplicas, int[] newRemovingObservers, int[] newAddingObservers) {
            this.newRemovingReplicas = newRemovingReplicas;
            this.newAddingReplicas = newAddingReplicas;
            this.newRemovingObservers = newRemovingObservers;
            this.newAddingObservers = newAddingObservers;
        }

        private static MergedReassignmentMetadata build(PartitionRegistration part, PartitionChangeRecord record) {
            int[] newRemovingReplicas = record.removingReplicas() == null ? part.removingReplicas : Replicas.toArray(record.removingReplicas());
            int[] newAddingReplicas = record.addingReplicas() == null ? part.addingReplicas : Replicas.toArray(record.addingReplicas());
            int[] newRemovingObservers = record.removingObservers() == null ? part.removingObservers : Replicas.toArray(record.removingObservers());
            int[] newAddingObservers = record.addingObservers() == null ? part.addingObservers : Replicas.toArray(record.addingObservers());
            return new MergedReassignmentMetadata(newRemovingReplicas, newAddingReplicas, newRemovingObservers, newAddingObservers);
        }
    }

    public static enum LinkState {
        FAILED(1),
        ACTIVE(0),
        NOT_MIRROR(-1);

        public final byte levelCode;

        private LinkState(int levelCode) {
            this.levelCode = (byte)levelCode;
        }

        public static LinkState fromCode(int linkState) {
            LinkState value = linkState == 0 ? ACTIVE : (linkState == 1 ? FAILED : NOT_MIRROR);
            return value;
        }
    }

    public static class Builder {
        private int[] replicas;
        private int[] observers = Replicas.NONE;
        private int[] isr;
        private int[] removingReplicas = Replicas.NONE;
        private int[] addingReplicas = Replicas.NONE;
        private int[] removingObservers = Replicas.NONE;
        private int[] addingObservers = Replicas.NONE;
        private Integer leader;
        private LeaderRecoveryState leaderRecoveryState;
        private Integer leaderEpoch;
        private Integer partitionEpoch;
        private Integer linkedLeaderEpoch = -1;
        private LinkState linkState = LinkState.NOT_MIRROR;

        public Builder setReplicas(int[] replicas) {
            this.replicas = replicas;
            return this;
        }

        public Builder setObservers(int[] observers) {
            this.observers = observers;
            return this;
        }

        public Builder setIsr(int[] isr) {
            this.isr = isr;
            return this;
        }

        public Builder setRemovingReplicas(int[] removingReplicas) {
            this.removingReplicas = removingReplicas;
            return this;
        }

        public Builder setAddingReplicas(int[] addingReplicas) {
            this.addingReplicas = addingReplicas;
            return this;
        }

        public Builder setRemovingObservers(int[] removingObservers) {
            this.removingObservers = removingObservers;
            return this;
        }

        public Builder setAddingObservers(int[] addingObservers) {
            this.addingObservers = addingObservers;
            return this;
        }

        public Builder setLeader(Integer leader) {
            this.leader = leader;
            return this;
        }

        public Builder setLeaderRecoveryState(LeaderRecoveryState leaderRecoveryState) {
            this.leaderRecoveryState = leaderRecoveryState;
            return this;
        }

        public Builder setLeaderEpoch(Integer leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setPartitionEpoch(Integer partitionEpoch) {
            this.partitionEpoch = partitionEpoch;
            return this;
        }

        public Builder setLinkedLeaderEpoch(Integer linkedLeaderEpoch) {
            this.linkedLeaderEpoch = linkedLeaderEpoch;
            return this;
        }

        public Builder setLinkState(LinkState linkState) {
            this.linkState = linkState;
            return this;
        }

        public PartitionRegistration build() {
            if (this.replicas == null) {
                throw new IllegalStateException("You must set replicas.");
            }
            if (this.isr == null) {
                throw new IllegalStateException("You must set isr.");
            }
            if (this.removingReplicas == null) {
                throw new IllegalStateException("You must set removing replicas.");
            }
            if (this.addingReplicas == null) {
                throw new IllegalStateException("You must set adding replicas.");
            }
            if (this.leader == null) {
                throw new IllegalStateException("You must set leader.");
            }
            if (this.leaderRecoveryState == null) {
                throw new IllegalStateException("You must set leader recovery state.");
            }
            if (this.leaderEpoch == null) {
                throw new IllegalStateException("You must set leader epoch.");
            }
            if (this.partitionEpoch == null) {
                throw new IllegalStateException("You must set partition epoch.");
            }
            if (this.observers == null) {
                throw new IllegalStateException("You must set observers.");
            }
            if (this.removingObservers == null) {
                throw new IllegalStateException("You must set removing observers.");
            }
            if (this.addingObservers == null) {
                throw new IllegalStateException("You must set adding observers.");
            }
            if (this.linkedLeaderEpoch == null) {
                throw new IllegalStateException("You must set linked leader epoch.");
            }
            if (this.linkState == null) {
                throw new IllegalStateException("You must set link state.");
            }
            return new PartitionRegistration(this.replicas, this.observers, this.isr, this.removingReplicas, this.addingReplicas, this.removingObservers, this.addingObservers, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch, this.linkedLeaderEpoch, this.linkState);
        }
    }
}

