/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class RaftConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("quorum.request.timeout.ms", ConfigDef.Type.INT, (Object)20000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("quorum.retry.backoff.ms", ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios.").define("quorum.voters", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, new ConfigDef.Validator(){

        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, null);
            }
            Map voterConnections = RaftConfig.parseVoterConnections((List)value);
            if (voterConnections.isEmpty()) {
                throw new ConfigException(name, value);
            }
        }

        public String toString() {
            return "non-empty list";
        }
    }, ConfigDef.Importance.HIGH, "Map of id/endpoint information for the set of voters in a comma-separated list of `{id}@{host}:{port}` entries. For example: `1@localhost:9092,2@localhost:9093,3@localhost:9094`").define("quorum.election.timeout.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.HIGH, "Maximum time in milliseconds to wait without being able to fetch from the leader before triggering a new election").define("quorum.election.backoff.max.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "Maximum time in milliseconds before starting new elections. This is used in the binary exponential backoff mechanism that helps prevent gridlocked elections").define("quorum.fetch.timeout.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "Maximum time without a successful fetch from the current leader before becoming a candidate and triggering a election for voters; Maximum time without receiving fetch from a majority of the quorum before asking around to see if there's a new epoch for leader");
    private static final String QUORUM_PREFIX = "quorum.";
    public static final String QUORUM_VOTERS_CONFIG = "quorum.voters";
    private static final String QUORUM_VOTERS_DOC = "Map of id/endpoint information for the set of voters in a comma-separated list of `{id}@{host}:{port}` entries. For example: `1@localhost:9092,2@localhost:9093,3@localhost:9094`";
    public static final String QUORUM_ELECTION_TIMEOUT_MS_CONFIG = "quorum.election.timeout.ms";
    private static final String QUORUM_ELECTION_TIMEOUT_MS_DOC = "Maximum time in milliseconds to wait without being able to fetch from the leader before triggering a new election";
    public static final String QUORUM_FETCH_TIMEOUT_MS_CONFIG = "quorum.fetch.timeout.ms";
    private static final String QUORUM_FETCH_TIMEOUT_MS_DOC = "Maximum time without a successful fetch from the current leader before becoming a candidate and triggering a election for voters; Maximum time without receiving fetch from a majority of the quorum before asking around to see if there's a new epoch for leader";
    public static final String QUORUM_ELECTION_BACKOFF_MAX_MS_CONFIG = "quorum.election.backoff.max.ms";
    private static final String QUORUM_ELECTION_BACKOFF_MAX_MS_DOC = "Maximum time in milliseconds before starting new elections. This is used in the binary exponential backoff mechanism that helps prevent gridlocked elections";

    public RaftConfig(Properties props) {
        super(CONFIG, (Map)props);
    }

    public RaftConfig(Map<String, Object> props) {
        super(CONFIG, props);
    }

    protected RaftConfig(Map<?, ?> props, boolean doLog) {
        super(CONFIG, props, doLog);
    }

    public static Set<String> configNames() {
        return CONFIG.names();
    }

    public static ConfigDef configDef() {
        return new ConfigDef(CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml());
    }

    public int requestTimeoutMs() {
        return this.getInt("quorum.request.timeout.ms");
    }

    public int retryBackoffMs() {
        return this.getInt("quorum.retry.backoff.ms");
    }

    public int electionTimeoutMs() {
        return this.getInt(QUORUM_ELECTION_TIMEOUT_MS_CONFIG);
    }

    public int electionBackoffMaxMs() {
        return this.getInt(QUORUM_ELECTION_BACKOFF_MAX_MS_CONFIG);
    }

    public int fetchTimeoutMs() {
        return this.getInt(QUORUM_FETCH_TIMEOUT_MS_CONFIG);
    }

    public Set<Integer> quorumVoterIds() {
        return this.quorumVoterConnections().keySet();
    }

    public Map<Integer, InetSocketAddress> quorumVoterConnections() {
        return RaftConfig.parseVoterConnections(this.getList(QUORUM_VOTERS_CONFIG));
    }

    private static Integer parseVoterId(String idString) {
        try {
            return Integer.parseInt(idString);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("Failed to parse voter ID as an integer from " + idString);
        }
    }

    private static Map<Integer, InetSocketAddress> parseVoterConnections(List<String> voterEntries) {
        HashMap<Integer, InetSocketAddress> voterMap = new HashMap<Integer, InetSocketAddress>();
        for (String voterMapEntry : voterEntries) {
            String[] idAndAddress = voterMapEntry.split("@");
            if (idAndAddress.length != 2) {
                throw new ConfigException("Invalid configuration value for quorum.voters. Each entry should be in the form `{id}@{host}:{port}`.");
            }
            Integer voterId = RaftConfig.parseVoterId(idAndAddress[0]);
            String host = Utils.getHost((String)idAndAddress[1]);
            if (host == null) {
                throw new ConfigException("Failed to parse host name from entry " + voterMapEntry + " for the configuration " + QUORUM_VOTERS_CONFIG + ". Each entry should be in the form `{id}@{host}:{port}`.");
            }
            Integer port = Utils.getPort((String)idAndAddress[1]);
            if (port == null) {
                throw new ConfigException("Failed to parse host port from entry " + voterMapEntry + " for the configuration " + QUORUM_VOTERS_CONFIG + ". Each entry should be in the form `{id}@{host}:{port}`.");
            }
            voterMap.put(voterId, new InetSocketAddress(host, (int)port));
        }
        return voterMap;
    }
}

