/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class KRaftVersionTest {
    @Test
    public void testFeatureLevel() {
        for (int i = 0; i < KRaftVersion.values().length; ++i) {
            Assertions.assertEquals((int)i, (int)KRaftVersion.values()[i].featureLevel());
        }
    }

    @Test
    public void testQuorumStateVersion() {
        for (int i = 0; i < KRaftVersion.values().length; ++i) {
            Assertions.assertEquals((int)i, (int)KRaftVersion.values()[i].quorumStateVersion());
        }
    }

    @Test
    public void testFromFeatureLevel() {
        for (int i = 0; i < KRaftVersion.values().length; ++i) {
            Assertions.assertEquals((Object)KRaftVersion.values()[i], (Object)KRaftVersion.fromFeatureLevel((short)((short)i)));
        }
    }

    @Test
    public void testBootstrapMetadataVersion() {
        block4: for (int i = 0; i < KRaftVersion.values().length; ++i) {
            MetadataVersion metadataVersion = KRaftVersion.values()[i].bootstrapMetadataVersion();
            switch (i) {
                case 0: {
                    Assertions.assertEquals((Object)MetadataVersion.MINIMUM_VERSION, (Object)metadataVersion);
                    continue block4;
                }
                case 1: {
                    Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0, (Object)metadataVersion);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unsupported value " + i);
                }
            }
        }
    }

    @Test
    public void testKraftVersionRecordVersion() {
        block4: for (KRaftVersion kraftVersion : KRaftVersion.values()) {
            switch (kraftVersion) {
                case KRAFT_VERSION_0: {
                    Assertions.assertThrows(IllegalStateException.class, () -> kraftVersion.kraftVersionRecordVersion());
                    continue block4;
                }
                case KRAFT_VERSION_1: {
                    Assertions.assertEquals((short)0, (short)kraftVersion.kraftVersionRecordVersion());
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unsupported value " + String.valueOf(kraftVersion));
                }
            }
        }
    }

    @Test
    public void tesVotersRecordVersion() {
        block4: for (KRaftVersion kraftVersion : KRaftVersion.values()) {
            switch (kraftVersion) {
                case KRAFT_VERSION_0: {
                    Assertions.assertThrows(IllegalStateException.class, () -> kraftVersion.votersRecordVersion());
                    continue block4;
                }
                case KRAFT_VERSION_1: {
                    Assertions.assertEquals((short)0, (short)kraftVersion.votersRecordVersion());
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unsupported value " + String.valueOf(kraftVersion));
                }
            }
        }
    }
}

