/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimerTest {
    private SystemTimer timer = null;

    @BeforeEach
    public void setup() {
        this.timer = new SystemTimer("test", 1L, 3, Time.SYSTEM.hiResClockMs());
    }

    @AfterEach
    public void teardown() throws Exception {
        this.timer.close();
        TestUtils.waitForCondition(() -> ((SystemTimer)this.timer).isTerminated(), (String)"timer executor not terminated");
    }

    @Test
    public void testAlreadyExpiredTask() throws InterruptedException {
        ArrayList output = new ArrayList();
        List latches = IntStream.range(-5, 0).mapToObj(i -> {
            CountDownLatch latch = new CountDownLatch(1);
            this.timer.add((TimerTask)new TestTask(i, i, latch, output));
            return latch;
        }).collect(Collectors.toList());
        this.timer.advanceClock(0L);
        latches.stream().limit(5L).forEach(latch -> {
            try {
                Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS), (String)"already expired tasks should run immediately");
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"interrupted");
            }
        });
        Assertions.assertEquals(Set.of(Integer.valueOf(-5), Integer.valueOf(-4), Integer.valueOf(-3), Integer.valueOf(-2), Integer.valueOf(-1)), new HashSet(output), (String)"output of already expired tasks");
    }

    @Test
    public void testTaskExpiration() throws InterruptedException {
        ArrayList output = new ArrayList();
        ArrayList tasks = new ArrayList();
        ArrayList ids = new ArrayList();
        ArrayList latches = new ArrayList();
        IntStream.range(0, 5).forEach(i -> {
            CountDownLatch latch = new CountDownLatch(1);
            tasks.add(new TestTask(i, i, latch, output));
            ids.add(i);
            latches.add(latch);
        });
        IntStream.range(10, 100).forEach(i -> {
            CountDownLatch latch = new CountDownLatch(2);
            tasks.add(new TestTask(i, i, latch, output));
            tasks.add(new TestTask(i, i, latch, output));
            ids.add(i);
            ids.add(i);
            latches.add(latch);
        });
        IntStream.range(100, 500).forEach(i -> {
            CountDownLatch latch = new CountDownLatch(1);
            tasks.add(new TestTask(i, i, latch, output));
            ids.add(i);
            latches.add(latch);
        });
        tasks.forEach(task -> this.timer.add((TimerTask)task));
        while (this.timer.advanceClock(2000L)) {
        }
        latches.forEach(latch -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"interrupted");
            }
        });
        Assertions.assertEquals(ids, output.stream().sorted().collect(Collectors.toList()), (String)"output should match");
    }

    private static class TestTask
    extends TimerTask {
        final int id;
        final CountDownLatch latch;
        final List<Integer> output;
        final AtomicBoolean completed = new AtomicBoolean(false);

        TestTask(long delayMs, int id, CountDownLatch latch, List<Integer> output) {
            super(delayMs);
            this.id = id;
            this.latch = latch;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.completed.compareAndSet(false, true)) {
                List<Integer> list = this.output;
                synchronized (list) {
                    this.output.add(this.id);
                }
                this.latch.countDown();
            }
        }
    }
}

