/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Deadline;
import org.apache.kafka.server.util.FutureUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public class FutureUtilsTest {
    private static final Logger log = LoggerFactory.getLogger(FutureUtilsTest.class);

    @Test
    public void testWaitWithLogging() throws Throwable {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        CompletableFuture future = new CompletableFuture();
        executorService.schedule(() -> future.complete(123), 1000L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((int)123, (Integer)((Integer)FutureUtils.waitWithLogging((Logger)log, (String)"[FutureUtilsTest] ", (String)"the future to be completed", future, (Deadline)Deadline.fromDelay((Time)Time.SYSTEM, (long)30L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.SYSTEM)));
        executorService.shutdownNow();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testWaitWithLoggingTimeout(boolean immediateTimeout) throws Throwable {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        CompletableFuture future = new CompletableFuture();
        executorService.schedule(() -> future.complete(456), 10000L, TimeUnit.MILLISECONDS);
        Assertions.assertThrows(TimeoutException.class, () -> FutureUtils.waitWithLogging((Logger)log, (String)"[FutureUtilsTest] ", (String)"the future to be completed", (CompletableFuture)future, (Deadline)(immediateTimeout ? Deadline.fromDelay((Time)Time.SYSTEM, (long)0L, (TimeUnit)TimeUnit.SECONDS) : Deadline.fromDelay((Time)Time.SYSTEM, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS)), (Time)Time.SYSTEM));
        executorService.shutdownNow();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Test
    public void testWaitWithLoggingError() throws Throwable {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        CompletableFuture future = new CompletableFuture();
        executorService.schedule(() -> future.completeExceptionally(new IllegalArgumentException("uh oh")), 1L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((Object)"Received a fatal error while waiting for the future to be completed", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FutureUtils.waitWithLogging((Logger)log, (String)"[FutureUtilsTest] ", (String)"the future to be completed", (CompletableFuture)future, (Deadline)Deadline.fromDelay((Time)Time.SYSTEM, (long)30L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.SYSTEM))).getMessage());
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Test
    public void testChainFuture() throws Throwable {
        CompletableFuture<Integer> sourceFuture = new CompletableFuture<Integer>();
        CompletableFuture destinationFuture = new CompletableFuture();
        FutureUtils.chainFuture(sourceFuture, destinationFuture);
        Assertions.assertFalse((boolean)sourceFuture.isDone());
        Assertions.assertFalse((boolean)destinationFuture.isDone());
        Assertions.assertFalse((boolean)sourceFuture.isCancelled());
        Assertions.assertFalse((boolean)destinationFuture.isCancelled());
        Assertions.assertFalse((boolean)sourceFuture.isCompletedExceptionally());
        Assertions.assertFalse((boolean)destinationFuture.isCompletedExceptionally());
        sourceFuture.complete(123);
        Assertions.assertEquals((Object)123, destinationFuture.get());
    }

    @Test
    public void testChainFutureExceptionally() {
        CompletableFuture sourceFuture = new CompletableFuture();
        CompletableFuture destinationFuture = new CompletableFuture();
        FutureUtils.chainFuture(sourceFuture, destinationFuture);
        sourceFuture.completeExceptionally(new RuntimeException("source failed"));
        Throwable cause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> destinationFuture.get())).getCause();
        Assertions.assertEquals(RuntimeException.class, cause.getClass());
        Assertions.assertEquals((Object)"source failed", (Object)cause.getMessage());
    }
}

