/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.Objects;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class MultiTenantPrincipal
extends ConfluentPrincipal {
    public static final String TENANT_USER_TYPE = "TenantUser";
    public static final String TENANT_WILDCARD_USER_TYPE = "TenantUser*";
    public static final String DELIMITER = "_";
    private final String user;
    private final TenantMetadata tenantMetadata;

    public MultiTenantPrincipal(String user, TenantMetadata tenantMetadata) {
        this(user, user, tenantMetadata);
    }

    public MultiTenantPrincipal(String user, String saslAuthenticationId, TenantMetadata tenantMetadata) {
        super(TENANT_USER_TYPE, tenantMetadata.tenantPrefix() + user, saslAuthenticationId);
        this.user = user;
        this.tenantMetadata = tenantMetadata;
    }

    public TenantMetadata tenantMetadata() {
        return this.tenantMetadata;
    }

    public String user() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiTenantPrincipal that = (MultiTenantPrincipal)((Object)o);
        return Objects.equals(this.tenantMetadata, that.tenantMetadata);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenantMetadata != null ? this.tenantMetadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MultiTenantPrincipal(tenantMetadata=" + this.tenantMetadata + ", user=" + this.user + ")";
    }

    public static boolean isTenantPrincipal(KafkaPrincipal principal) {
        return principal.getPrincipalType().startsWith(TENANT_USER_TYPE);
    }
}

