/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Objects;

public class TenantMetadata {
    public final String tenantName;
    public final String clusterId;
    public String organizationId;
    public String environmentId;
    public boolean isSuperUser;
    public String userResourceId;

    public TenantMetadata(String tenantName, String clusterId) {
        this(tenantName, clusterId, null, null, false, null);
    }

    TenantMetadata(String tenantName, String clusterId, String organizationId, String environmentId, boolean isSuperUser, String userResourceId) {
        this.tenantName = TenantMetadata.requireNonEmpty(tenantName, "Tenant");
        this.clusterId = TenantMetadata.requireNonEmpty(clusterId, "ClusterId");
        this.organizationId = organizationId;
        this.environmentId = environmentId;
        this.isSuperUser = isSuperUser;
        this.userResourceId = userResourceId;
    }

    public String tenantPrefix() {
        return this.tenantName + "_";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantMetadata that = (TenantMetadata)o;
        return Objects.equals(this.tenantName, that.tenantName) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId);
    }

    public int hashCode() {
        return Objects.hash(this.tenantName, this.clusterId, this.organizationId, this.environmentId);
    }

    public String toString() {
        return "TenantMetadata(tenantName='" + this.tenantName + "', clusterId='" + this.clusterId + "', organizationId='" + this.organizationId + "', environmentId='" + this.environmentId + "', isSuperUser=" + this.isSuperUser + ")";
    }

    private static String requireNonEmpty(String value, String argName) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(argName + " must not be empty or null");
        }
        return value;
    }

    public static class Builder {
        public final String tenantName;
        public final String clusterId;
        public String organizationId;
        public String environmentId;
        public boolean isSuperUser;
        private final String userResourceId;

        public Builder(String clusterId, String userResourceId) {
            this.clusterId = clusterId;
            this.tenantName = clusterId;
            this.userResourceId = userResourceId;
        }

        public Builder superUser(boolean isSuperUser) {
            this.isSuperUser = isSuperUser;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public TenantMetadata build() {
            return new TenantMetadata(this.tenantName, this.clusterId, this.organizationId, this.environmentId, this.isSuperUser, this.userResourceId);
        }
    }
}

