/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.server.common.MetadataVersion;

public final class Features {
    private final MetadataVersion version;
    private final Map<String, Short> finalizedFeatures;
    private final long finalizedFeaturesEpoch;

    public static Features fromKRaftVersion(MetadataVersion version) {
        return new Features(version, Collections.emptyMap(), -1L, true);
    }

    public Features(MetadataVersion version, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch, boolean kraftMode) {
        this.version = version;
        this.finalizedFeatures = new HashMap<String, Short>(finalizedFeatures);
        this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
        if (kraftMode) {
            this.finalizedFeatures.put("confluent.metadata.version", version.confluentFeatureLevel());
        } else {
            this.finalizedFeatures.remove("confluent.metadata.version");
        }
        this.finalizedFeatures.remove("metadata.version");
    }

    public MetadataVersion metadataVersion() {
        return this.version;
    }

    public Map<String, Short> finalizedFeatures() {
        return this.finalizedFeatures;
    }

    public long finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(Features.class)) {
            return false;
        }
        Features other = (Features)o;
        return this.version == other.version && this.finalizedFeatures.equals(other.finalizedFeatures) && this.finalizedFeaturesEpoch == other.finalizedFeaturesEpoch;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.finalizedFeatures, this.finalizedFeaturesEpoch});
    }

    public String toString() {
        return "Features(version=" + (Object)((Object)this.version) + ", finalizedFeatures=" + this.finalizedFeatures + ", finalizedFeaturesEpoch=" + this.finalizedFeaturesEpoch + ")";
    }
}

