/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.apache.kafka.server.immutable.pcollections.PCollectionsImmutableNavigableSet;
import org.pcollections.PSortedSet;
import org.pcollections.TreePMap;

public class PCollectionsImmutableNavigableMap<K, V>
implements ImmutableNavigableMap<K, V> {
    private final TreePMap<K, V> underlying;

    PCollectionsImmutableNavigableMap(TreePMap<K, V> underlying) {
        this.underlying = underlying;
    }

    public static <K extends Comparable<? super K>, V> PCollectionsImmutableNavigableMap<K, V> empty() {
        return new PCollectionsImmutableNavigableMap<K, V>(TreePMap.empty());
    }

    public static <K extends Comparable<? super K>, V> PCollectionsImmutableNavigableMap<K, V> singleton(K key, V value) {
        return new PCollectionsImmutableNavigableMap<K, V>(TreePMap.singleton(key, value));
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> updated(K key, V value) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().plus(key, value));
    }

    @Override
    public ImmutableNavigableMap<K, V> removed(K key) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().minus(key));
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.underlying().lowerEntry(key);
    }

    @Override
    public K lowerKey(K key) {
        return (K)this.underlying().lowerKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.underlying().floorEntry(key);
    }

    @Override
    public K floorKey(K key) {
        return (K)this.underlying().floorKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.underlying().ceilingEntry(key);
    }

    @Override
    public K ceilingKey(K key) {
        return (K)this.underlying().ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.underlying().higherEntry(key);
    }

    @Override
    public K higherKey(K key) {
        return (K)this.underlying().higherKey(key);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.underlying().firstEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.underlying().lastEntry();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.underlying().pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.underlying().pollLastEntry();
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> descendingMap() {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().descendingMap());
    }

    @Override
    public PCollectionsImmutableNavigableSet<K> navigableKeySet() {
        return new PCollectionsImmutableNavigableSet(this.underlying().navigableKeySet());
    }

    @Override
    public PSortedSet<K> descendingKeySet() {
        return this.underlying().descendingKeySet();
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().headMap(toKey, inclusive));
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().tailMap(fromKey, inclusive));
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.underlying().comparator();
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().subMap(fromKey, toKey));
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> headMap(K toKey) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().headMap(toKey));
    }

    @Override
    public PCollectionsImmutableNavigableMap<K, V> tailMap(K fromKey) {
        return new PCollectionsImmutableNavigableMap<K, V>(this.underlying().tailMap(fromKey));
    }

    @Override
    public K firstKey() {
        return (K)this.underlying().firstKey();
    }

    @Override
    public K lastKey() {
        return (K)this.underlying().lastKey();
    }

    @Override
    public int size() {
        return this.underlying().size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.underlying().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlying().containsValue(value);
    }

    @Override
    public int hashCode() {
        return this.underlying().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCollectionsImmutableNavigableMap other = (PCollectionsImmutableNavigableMap)o;
        return this.underlying().equals(other.underlying());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.underlying().forEach(action);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.underlying().getOrDefault(key, defaultValue);
    }

    @Override
    public V get(Object key) {
        return (V)this.underlying().get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.underlying().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.underlying().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.underlying().putAll(m);
    }

    @Override
    public void clear() {
        this.underlying().clear();
    }

    @Override
    public PCollectionsImmutableNavigableSet<K> keySet() {
        return new PCollectionsImmutableNavigableSet(this.underlying().keySet());
    }

    @Override
    public Collection<V> values() {
        return this.underlying().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.underlying().entrySet();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.underlying().replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.underlying().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.underlying().remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.underlying().replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return (V)this.underlying().replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.underlying().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().compute(key, remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.underlying().merge(key, value, remappingFunction);
    }

    public String toString() {
        return "PCollectionsImmutableNavigableMap{underlying=" + this.underlying() + '}';
    }

    TreePMap<K, V> underlying() {
        return this.underlying;
    }
}

