/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class KafkaMetricsGroup {
    private final Class<?> klass;

    public KafkaMetricsGroup(Class<?> klass) {
        this.klass = klass;
    }

    public MetricName metricName(String name, Map<String, String> tags) {
        String pkg = this.klass.getPackage() == null ? "" : this.klass.getPackage().getName();
        String simpleName = this.klass.getSimpleName().replaceAll("\\$$", "");
        return KafkaMetricsGroup.explicitMetricName(pkg, simpleName, name, tags);
    }

    public static MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        StringBuilder nameBuilder = new StringBuilder(100);
        nameBuilder.append(group);
        nameBuilder.append(":type=");
        nameBuilder.append(typeName);
        if (!name.isEmpty()) {
            nameBuilder.append(",name=");
            nameBuilder.append(name);
        }
        String scope = KafkaMetricsGroup.toScope(tags).orElse(null);
        Optional<String> tagsName = KafkaMetricsGroup.toMBeanName(tags);
        tagsName.ifPresent(s -> nameBuilder.append(",").append((String)s));
        return new MetricName(group, typeName, name, scope, nameBuilder.toString());
    }

    public final <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaYammerMetrics.defaultRegistry().newGauge(this.metricName(name, tags), metric);
    }

    public final <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return this.newGauge(name, metric, Collections.emptyMap());
    }

    public final <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaYammerMetrics.defaultRegistry().newGauge(metricName, metric);
    }

    public final Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaYammerMetrics.defaultRegistry().newMeter(this.metricName(name, tags), eventType, timeUnit);
    }

    public final Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return this.newMeter(name, eventType, timeUnit, Collections.emptyMap());
    }

    public final Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaYammerMetrics.defaultRegistry().newMeter(metricName, eventType, timeUnit);
    }

    public final Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaYammerMetrics.defaultRegistry().newHistogram(this.metricName(name, tags), biased);
    }

    public final Histogram newHistogram(String name) {
        return this.newHistogram(name, true, Collections.emptyMap());
    }

    public final Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaYammerMetrics.defaultRegistry().newTimer(this.metricName(name, tags), durationUnit, rateUnit);
    }

    public final Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.newTimer(name, durationUnit, rateUnit, Collections.emptyMap());
    }

    public final void removeMetric(String name, Map<String, String> tags) {
        KafkaYammerMetrics.defaultRegistry().removeMetric(this.metricName(name, tags));
    }

    public final void removeMetric(MetricName metricName) {
        KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
    }

    public final void removeMetric(String name) {
        this.removeMetric(name, Collections.emptyMap());
    }

    private static Optional<String> toMBeanName(Map<String, String> tags) {
        List filteredTags = tags.entrySet().stream().filter(entry -> !((String)entry.getValue()).equals("")).collect(Collectors.toList());
        if (!filteredTags.isEmpty()) {
            String tagsString = filteredTags.stream().map(entry -> (String)entry.getKey() + "=" + Sanitizer.jmxSanitize((String)((String)entry.getValue()))).collect(Collectors.joining(","));
            return Optional.of(tagsString);
        }
        return Optional.empty();
    }

    private static Optional<String> toScope(Map<String, String> tags) {
        List filteredTags = tags.entrySet().stream().filter(entry -> !((String)entry.getValue()).equals("")).collect(Collectors.toList());
        if (!filteredTags.isEmpty()) {
            String tagsString = filteredTags.stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "." + ((String)entry.getValue()).replaceAll("\\.", "_")).collect(Collectors.joining("."));
            return Optional.of(tagsString);
        }
        return Optional.empty();
    }
}

