/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.glob.GlobVisitor;
import org.apache.kafka.shell.node.printer.ShellNodePrinter;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatCommandHandler
implements Commands.Handler {
    private static final Logger log = LoggerFactory.getLogger(CatCommandHandler.class);
    public static final Commands.Type TYPE = new CatCommandType();
    private final List<String> targets;

    public CatCommandHandler(List<String> targets) {
        this.targets = targets;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataShellState state) throws Exception {
        log.trace("cat " + this.targets);
        for (String target : this.targets) {
            state.visit(new GlobVisitor(target, entryOption -> {
                if (entryOption.isPresent()) {
                    MetadataNode node = ((GlobVisitor.MetadataNodeInfo)entryOption.get()).node();
                    if (node.isDirectory()) {
                        writer.println("cat: " + target + ": Is a directory");
                    } else {
                        ShellNodePrinter printer = new ShellNodePrinter(writer);
                        node.print((MetadataNodePrinter)printer);
                    }
                } else {
                    writer.println("cat: " + target + ": No such file or directory.");
                }
            }));
        }
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CatCommandHandler)) {
            return false;
        }
        CatCommandHandler o = (CatCommandHandler)other;
        return Objects.equals(o.targets, this.targets);
    }

    public static class CatCommandType
    implements Commands.Type {
        private CatCommandType() {
        }

        @Override
        public String name() {
            return "cat";
        }

        @Override
        public String description() {
            return "Show the contents of metadata files.";
        }

        @Override
        public boolean shellOnly() {
            return false;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"targets"}).nargs("+").help("The metadata files to display.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new CatCommandHandler(namespace.getList("targets"));
        }

        @Override
        public void completeNext(MetadataShellState state, List<String> nextWords, List<Candidate> candidates) throws Exception {
            CommandUtils.completePath(state, nextWords.get(nextWords.size() - 1), candidates);
        }
    }
}

