/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Instant;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreFacade;

public class WindowStoreFacade<K, V>
extends ReadOnlyWindowStoreFacade<K, V>
implements WindowStore<K, V> {
    public WindowStoreFacade(TimestampedWindowStore<K, V> store) {
        super(store);
    }

    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
    }

    public void init(StateStoreContext context, StateStore root) {
        this.inner.init(context, root);
    }

    @Deprecated
    public void put(K key, V value) {
        this.inner.put(key, (Object)ValueAndTimestamp.make(value, (long)-1L));
    }

    public void put(K key, V value, long windowStartTimestamp) {
        this.inner.put(key, (Object)ValueAndTimestamp.make(value, (long)-1L), windowStartTimestamp);
    }

    public WindowStoreIterator<V> backwardFetch(K key, long timeFrom, long timeTo) {
        return this.backwardFetch(key, Instant.ofEpochMilli(timeFrom), Instant.ofEpochMilli(timeTo));
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        return this.backwardFetch(keyFrom, keyTo, Instant.ofEpochMilli(timeFrom), Instant.ofEpochMilli(timeTo));
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(long timeFrom, long timeTo) {
        return this.backwardFetchAll(Instant.ofEpochMilli(timeFrom), Instant.ofEpochMilli(timeTo));
    }

    public void flush() {
        this.inner.flush();
    }

    public void close() {
        this.inner.close();
    }

    public String name() {
        return this.inner.name();
    }

    public boolean persistent() {
        return this.inner.persistent();
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

