/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.apache.kafka.streams.state.internals.Segment;

class TimestampedSegment
extends RocksDBTimestampedStore
implements Comparable<TimestampedSegment>,
Segment {
    public final long id;

    TimestampedSegment(String segmentName, String windowName, long id) {
        super(segmentName, windowName);
        this.id = id;
    }

    @Override
    public void destroy() throws IOException {
        Utils.delete((File)this.dbDir);
    }

    @Override
    public int compareTo(TimestampedSegment segment) {
        return Long.compare(this.id, segment.id);
    }

    @Override
    public void openDB(ProcessorContext context) {
        super.openDB(context);
        this.internalProcessorContext = context;
    }

    public String toString() {
        return "TimestampedSegment(id=" + this.id + ", name=" + this.name() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampedSegment segment = (TimestampedSegment)obj;
        return this.id == segment.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

