/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamReduce<K, V>
implements KStreamAggProcessorSupplier<K, K, V, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamReduce.class);
    private final String storeName;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    KStreamReduce(String storeName, Reducer<V> reducer) {
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KStreamReduceValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamReduce.this.storeName};
            }
        };
    }

    private class KStreamReduceValueGetter
    implements KTableValueGetter<K, V> {
        private TimestampedKeyValueStore<K, V> store;

        private KStreamReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
        }

        @Override
        public ValueAndTimestamp<V> get(K key) {
            return (ValueAndTimestamp)this.store.get(key);
        }

        @Override
        public void close() {
        }
    }

    private class KStreamReduceProcessor
    extends AbstractProcessor<K, V> {
        private TimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;
        private StreamsMetricsImpl metrics;
        private Sensor droppedRecordsSensor;

        private KStreamReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), this.metrics);
            this.store = (TimestampedKeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KStreamReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            long newTimestamp;
            Object newAgg;
            if (key == null || value == null) {
                LOG.warn("Skipping record due to null key or value. key=[{}] value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{key, value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.droppedRecordsSensor.record();
                return;
            }
            ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.store.get(key);
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (oldAgg == null) {
                newAgg = value;
                newTimestamp = this.context().timestamp();
            } else {
                newAgg = KStreamReduce.this.reducer.apply(oldAgg, value);
                newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
            }
            this.store.put(key, ValueAndTimestamp.make(newAgg, newTimestamp));
            this.tupleForwarder.maybeForward(key, newAgg, KStreamReduce.this.sendOldValues ? oldAgg : null, newTimestamp);
        }
    }
}

