/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.streams.internals.generated.SubscriptionInfoData;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionInfo.class);
    static final int UNKNOWN = -1;
    private final SubscriptionInfoData data;
    private Set<TaskId> prevTasksCache = null;
    private Set<TaskId> standbyTasksCache = null;

    private static void validateVersions(int version, int latestSupportedVersion) {
        if (latestSupportedVersion == -1 && (version < 1 || version > 2)) {
            throw new IllegalArgumentException("Only versions 1 and 2 are expected to use an UNKNOWN (-1) latest supported version. Got " + version + ".");
        }
        if (latestSupportedVersion != -1 && (version < 1 || version > latestSupportedVersion)) {
            throw new IllegalArgumentException("version must be between 1 and " + latestSupportedVersion + "; was: " + version);
        }
    }

    public SubscriptionInfo(int version, int latestSupportedVersion, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        SubscriptionInfo.validateVersions(version, latestSupportedVersion);
        SubscriptionInfoData data = new SubscriptionInfoData();
        data.setVersion(version);
        if (version >= 2) {
            data.setUserEndPoint(userEndPoint == null ? new byte[]{} : userEndPoint.getBytes(StandardCharsets.UTF_8));
        }
        if (version >= 3) {
            data.setLatestSupportedVersion(latestSupportedVersion);
        }
        data.setProcessId(processId);
        data.setPrevTasks(prevTasks.stream().map(t -> {
            SubscriptionInfoData.TaskId taskId = new SubscriptionInfoData.TaskId();
            taskId.setTopicGroupId(t.topicGroupId);
            taskId.setPartition(t.partition);
            return taskId;
        }).collect(Collectors.toList()));
        data.setStandbyTasks(standbyTasks.stream().map(t -> {
            SubscriptionInfoData.TaskId taskId = new SubscriptionInfoData.TaskId();
            taskId.setTopicGroupId(t.topicGroupId);
            taskId.setPartition(t.partition);
            return taskId;
        }).collect(Collectors.toList()));
        this.data = data;
    }

    private SubscriptionInfo(SubscriptionInfoData subscriptionInfoData) {
        SubscriptionInfo.validateVersions(subscriptionInfoData.version(), subscriptionInfoData.latestSupportedVersion());
        this.data = subscriptionInfoData;
    }

    public int version() {
        return this.data.version();
    }

    public int latestSupportedVersion() {
        return this.data.latestSupportedVersion();
    }

    public UUID processId() {
        return this.data.processId();
    }

    public Set<TaskId> prevTasks() {
        if (this.prevTasksCache == null) {
            this.prevTasksCache = Collections.unmodifiableSet(this.data.prevTasks().stream().map(t -> new TaskId(t.topicGroupId(), t.partition())).collect(Collectors.toSet()));
        }
        return this.prevTasksCache;
    }

    public Set<TaskId> standbyTasks() {
        if (this.standbyTasksCache == null) {
            this.standbyTasksCache = Collections.unmodifiableSet(this.data.standbyTasks().stream().map(t -> new TaskId(t.topicGroupId(), t.partition())).collect(Collectors.toSet()));
        }
        return this.standbyTasksCache;
    }

    public String userEndPoint() {
        return this.data.userEndPoint() == null || this.data.userEndPoint().length == 0 ? null : new String(this.data.userEndPoint(), StandardCharsets.UTF_8);
    }

    public ByteBuffer encode() {
        if (this.data.version() > 6) {
            throw new IllegalStateException("Should never try to encode a SubscriptionInfo with version [" + this.data.version() + "] > LATEST_SUPPORTED_VERSION [" + 6 + "]");
        }
        ObjectSerializationCache cache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(this.data.size(cache, (short)this.data.version()));
        ByteBufferAccessor accessor = new ByteBufferAccessor(buffer);
        this.data.write((Writable)accessor, cache, (short)this.data.version());
        buffer.rewind();
        return buffer;
    }

    public static SubscriptionInfo decode(ByteBuffer data) {
        data.rewind();
        int version = data.getInt();
        if (version > 6) {
            int latestSupportedVersion = data.getInt();
            SubscriptionInfoData subscriptionInfoData = new SubscriptionInfoData();
            subscriptionInfoData.setVersion(version);
            subscriptionInfoData.setLatestSupportedVersion(latestSupportedVersion);
            LOG.info("Unable to decode subscription data: used version: {}; latest supported version: {}", (Object)version, (Object)latestSupportedVersion);
            return new SubscriptionInfo(subscriptionInfoData);
        }
        data.rewind();
        ByteBufferAccessor accessor = new ByteBufferAccessor(data);
        SubscriptionInfoData subscriptionInfoData = new SubscriptionInfoData((Readable)accessor, (short)version);
        return new SubscriptionInfo(subscriptionInfoData);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SubscriptionInfo) {
            SubscriptionInfo other = (SubscriptionInfo)o;
            return this.data.equals(other.data);
        }
        return false;
    }

    public String toString() {
        return this.data.toString();
    }

    static {
        int subscriptionInfoLatestVersion = SubscriptionInfoData.SCHEMAS.length - 1;
        if (subscriptionInfoLatestVersion != 6) {
            throw new IllegalArgumentException("streams/src/main/resources/common/message/SubscriptionInfo.json needs to be updated to match the latest assignment protocol version. SubscriptionInfo only supports up to  [" + subscriptionInfoLatestVersion + "] but needs to support up to [" + 6 + "].");
        }
    }
}

