/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class StateStoreMetrics {
    private static final String AVG_DESCRIPTION_PREFIX = "The average ";
    private static final String MAX_DESCRIPTION_PREFIX = "The maximum ";
    private static final String CURRENT_DESCRIPTION_PREFIX = "The current ";
    private static final String LATENCY_DESCRIPTION = "latency of ";
    private static final String AVG_LATENCY_DESCRIPTION_PREFIX = "The average latency of ";
    private static final String MAX_LATENCY_DESCRIPTION_PREFIX = "The maximum latency of ";
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String CURRENT_SUFFIX = "-current";
    private static final String BUFFERED_RECORDS = "buffered records";
    private static final String PUT = "put";
    private static final String PUT_DESCRIPTION = "calls to put";
    private static final String PUT_TOTAL_DESCRIPTION = "The total number of calls to put";
    private static final String PUT_RATE_DESCRIPTION = "The average number of calls to put per second";
    private static final String PUT_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put";
    private static final String PUT_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put";
    private static final String PUT_IF_ABSENT = "put-if-absent";
    private static final String PUT_IF_ABSENT_DESCRIPTION = "calls to put-if-absent";
    private static final String PUT_IF_ABSENT_TOTAL_DESCRIPTION = "The total number of calls to put-if-absent";
    private static final String PUT_IF_ABSENT_RATE_DESCRIPTION = "The average number of calls to put-if-absent per second";
    private static final String PUT_IF_ABSENT_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put-if-absent";
    private static final String PUT_IF_ABSENT_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put-if-absent";
    private static final String PUT_ALL = "put-all";
    private static final String PUT_ALL_DESCRIPTION = "calls to put-all";
    private static final String PUT_ALL_TOTAL_DESCRIPTION = "The total number of calls to put-all";
    private static final String PUT_ALL_RATE_DESCRIPTION = "The average number of calls to put-all per second";
    private static final String PUT_ALL_AVG_LATENCY_DESCRIPTION = "The average latency of calls to put-all";
    private static final String PUT_ALL_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to put-all";
    private static final String GET = "get";
    private static final String GET_DESCRIPTION = "calls to get";
    private static final String GET_TOTAL_DESCRIPTION = "The total number of calls to get";
    private static final String GET_RATE_DESCRIPTION = "The average number of calls to get per second";
    private static final String GET_AVG_LATENCY_DESCRIPTION = "The average latency of calls to get";
    private static final String GET_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to get";
    private static final String FETCH = "fetch";
    private static final String FETCH_DESCRIPTION = "calls to fetch";
    private static final String FETCH_TOTAL_DESCRIPTION = "The total number of calls to fetch";
    private static final String FETCH_RATE_DESCRIPTION = "The average number of calls to fetch per second";
    private static final String FETCH_AVG_LATENCY_DESCRIPTION = "The average latency of calls to fetch";
    private static final String FETCH_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to fetch";
    private static final String ALL = "all";
    private static final String ALL_DESCRIPTION = "calls to all";
    private static final String ALL_TOTAL_DESCRIPTION = "The total number of calls to all";
    private static final String ALL_RATE_DESCRIPTION = "The average number of calls to all per second";
    private static final String ALL_AVG_LATENCY_DESCRIPTION = "The average latency of calls to all";
    private static final String ALL_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to all";
    private static final String RANGE = "range";
    private static final String RANGE_DESCRIPTION = "calls to range";
    private static final String RANGE_TOTAL_DESCRIPTION = "The total number of calls to range";
    private static final String RANGE_RATE_DESCRIPTION = "The average number of calls to range per second";
    private static final String RANGE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to range";
    private static final String RANGE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to range";
    private static final String FLUSH = "flush";
    private static final String FLUSH_DESCRIPTION = "calls to flush";
    private static final String FLUSH_TOTAL_DESCRIPTION = "The total number of calls to flush";
    private static final String FLUSH_RATE_DESCRIPTION = "The average number of calls to flush per second";
    private static final String FLUSH_AVG_LATENCY_DESCRIPTION = "The average latency of calls to flush";
    private static final String FLUSH_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to flush";
    private static final String DELETE = "delete";
    private static final String DELETE_DESCRIPTION = "calls to delete";
    private static final String DELETE_TOTAL_DESCRIPTION = "The total number of calls to delete";
    private static final String DELETE_RATE_DESCRIPTION = "The average number of calls to delete per second";
    private static final String DELETE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to delete";
    private static final String DELETE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to delete";
    private static final String REMOVE = "remove";
    private static final String REMOVE_DESCRIPTION = "calls to remove";
    private static final String REMOVE_TOTAL_DESCRIPTION = "The total number of calls to remove";
    private static final String REMOVE_RATE_DESCRIPTION = "The average number of calls to remove per second";
    private static final String REMOVE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to remove";
    private static final String REMOVE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to remove";
    private static final String RESTORE = "restore";
    private static final String RESTORE_DESCRIPTION = "restorations";
    private static final String RESTORE_TOTAL_DESCRIPTION = "The total number of restorations";
    private static final String RESTORE_RATE_DESCRIPTION = "The average number of restorations per second";
    private static final String RESTORE_AVG_LATENCY_DESCRIPTION = "The average latency of restorations";
    private static final String RESTORE_MAX_LATENCY_DESCRIPTION = "The maximum latency of restorations";
    private static final String SUPPRESSION_BUFFER_COUNT = "suppression-buffer-count";
    private static final String SUPPRESSION_BUFFER_COUNT_DESCRIPTION = "count of buffered records";
    private static final String SUPPRESSION_BUFFER_COUNT_CURRENT_DESCRIPTION = "The current count of buffered records";
    private static final String SUPPRESSION_BUFFER_COUNT_AVG_DESCRIPTION = "The average count of buffered records";
    private static final String SUPPRESSION_BUFFER_COUNT_MAX_DESCRIPTION = "The maximum count of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE = "suppression-buffer-size";
    private static final String SUPPRESSION_BUFFER_SIZE_DESCRIPTION = "size of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE_CURRENT_DESCRIPTION = "The current size of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE_AVG_DESCRIPTION = "The average size of buffered records";
    private static final String SUPPRESSION_BUFFER_SIZE_MAX_DESCRIPTION = "The maximum size of buffered records";
    private static final String EXPIRED_WINDOW_RECORD_DROP = "expired-window-record-drop";
    private static final String EXPIRED_WINDOW_RECORD_DROP_DESCRIPTION = "dropped records due to an expired window";
    private static final String EXPIRED_WINDOW_RECORD_DROP_TOTAL_DESCRIPTION = "The total number of dropped records due to an expired window";
    private static final String EXPIRED_WINDOW_RECORD_DROP_RATE_DESCRIPTION = "The average number of dropped records due to an expired window per second";

    private StateStoreMetrics() {
    }

    public static Sensor putSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, PUT, PUT_RATE_DESCRIPTION, PUT_TOTAL_DESCRIPTION, PUT_AVG_LATENCY_DESCRIPTION, PUT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor putIfAbsentSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, PUT_IF_ABSENT, PUT_IF_ABSENT_RATE_DESCRIPTION, PUT_IF_ABSENT_TOTAL_DESCRIPTION, PUT_IF_ABSENT_AVG_LATENCY_DESCRIPTION, PUT_IF_ABSENT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor putAllSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, PUT_ALL, PUT_ALL_RATE_DESCRIPTION, PUT_ALL_TOTAL_DESCRIPTION, PUT_ALL_AVG_LATENCY_DESCRIPTION, PUT_ALL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor getSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, GET, GET_RATE_DESCRIPTION, GET_TOTAL_DESCRIPTION, GET_AVG_LATENCY_DESCRIPTION, GET_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor fetchSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, FETCH, FETCH_RATE_DESCRIPTION, FETCH_TOTAL_DESCRIPTION, FETCH_AVG_LATENCY_DESCRIPTION, FETCH_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor allSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, ALL, ALL_RATE_DESCRIPTION, ALL_TOTAL_DESCRIPTION, ALL_AVG_LATENCY_DESCRIPTION, ALL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor rangeSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, RANGE, RANGE_RATE_DESCRIPTION, RANGE_TOTAL_DESCRIPTION, RANGE_AVG_LATENCY_DESCRIPTION, RANGE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor flushSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, FLUSH, FLUSH_RATE_DESCRIPTION, FLUSH_TOTAL_DESCRIPTION, FLUSH_AVG_LATENCY_DESCRIPTION, FLUSH_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor deleteSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, DELETE, DELETE_RATE_DESCRIPTION, DELETE_TOTAL_DESCRIPTION, DELETE_AVG_LATENCY_DESCRIPTION, DELETE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor removeSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, REMOVE, REMOVE_RATE_DESCRIPTION, REMOVE_TOTAL_DESCRIPTION, REMOVE_AVG_LATENCY_DESCRIPTION, REMOVE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor restoreSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.throughputAndLatencySensor(threadId, taskId, storeType, storeName, RESTORE, RESTORE_RATE_DESCRIPTION, RESTORE_TOTAL_DESCRIPTION, RESTORE_AVG_LATENCY_DESCRIPTION, RESTORE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor expiredWindowRecordDropSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.storeLevelSensor(threadId, taskId, storeName, EXPIRED_WINDOW_RECORD_DROP, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-" + storeType + "-metrics", streamsMetrics.storeLevelTagMap(threadId, taskId, storeType, storeName), EXPIRED_WINDOW_RECORD_DROP, EXPIRED_WINDOW_RECORD_DROP_RATE_DESCRIPTION, EXPIRED_WINDOW_RECORD_DROP_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor suppressionBufferCountSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.sizeOrCountSensor(threadId, taskId, storeType, storeName, SUPPRESSION_BUFFER_COUNT, SUPPRESSION_BUFFER_COUNT_CURRENT_DESCRIPTION, SUPPRESSION_BUFFER_COUNT_AVG_DESCRIPTION, SUPPRESSION_BUFFER_COUNT_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor suppressionBufferSizeSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        return StateStoreMetrics.sizeOrCountSensor(threadId, taskId, storeType, storeName, SUPPRESSION_BUFFER_SIZE, SUPPRESSION_BUFFER_SIZE_CURRENT_DESCRIPTION, SUPPRESSION_BUFFER_SIZE_AVG_DESCRIPTION, SUPPRESSION_BUFFER_SIZE_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    private static Sensor sizeOrCountSensor(String threadId, String taskId, String storeType, String storeName, String metricName, String descriptionOfCurrentValue, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Map<String, String> tagMap;
        String group;
        StreamsMetricsImpl.Version version = streamsMetrics.version();
        Sensor sensor = streamsMetrics.storeLevelSensor(threadId, taskId, storeName, metricName, recordingLevel, new Sensor[0]);
        if (version == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            group = "stream-buffer-metrics";
            tagMap = streamsMetrics.bufferLevelTagMap(threadId, taskId, storeName);
            StreamsMetricsImpl.addValueMetricToSensor(sensor, group, tagMap, metricName + CURRENT_SUFFIX, descriptionOfCurrentValue);
        } else {
            group = "stream-state-metrics";
            tagMap = streamsMetrics.storeLevelTagMap(threadId, taskId, storeType, storeName);
        }
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, group, tagMap, metricName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }

    private static Sensor throughputAndLatencySensor(String threadId, String taskId, String storeType, String storeName, String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor;
        String latencyMetricName = metricName + "-latency";
        StreamsMetricsImpl.Version version = streamsMetrics.version();
        Map<String, String> tagMap = streamsMetrics.storeLevelTagMap(threadId, taskId, storeType, storeName);
        String stateStoreLevelGroup = StateStoreMetrics.stateStoreLevelGroup(storeType, version);
        if (version == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            Sensor parentSensor = StateStoreMetrics.parentSensor(stateStoreLevelGroup, threadId, taskId, storeType, metricName, latencyMetricName, descriptionOfRate, descriptionOfCount, descriptionOfAvg, descriptionOfMax, recordingLevel, streamsMetrics);
            sensor = streamsMetrics.storeLevelSensor(threadId, taskId, storeName, metricName, recordingLevel, parentSensor);
            StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, stateStoreLevelGroup, tagMap, metricName, descriptionOfRate, descriptionOfCount);
        } else {
            sensor = streamsMetrics.storeLevelSensor(threadId, taskId, storeName, metricName, recordingLevel, new Sensor[0]);
            StreamsMetricsImpl.addInvocationRateToSensor(sensor, stateStoreLevelGroup, tagMap, metricName, descriptionOfRate);
        }
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, stateStoreLevelGroup, tagMap, latencyMetricName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }

    private static Sensor parentSensor(String stateStoreLevelGroup, String threadId, String taskId, String storeType, String metricName, String latencyMetricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricName, recordingLevel, new Sensor[0]);
        Map<String, String> allTagMap = streamsMetrics.storeLevelTagMap(threadId, taskId, storeType, ALL);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, stateStoreLevelGroup, allTagMap, latencyMetricName, descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, stateStoreLevelGroup, allTagMap, metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static String stateStoreLevelGroup(String metricsScope, StreamsMetricsImpl.Version builtInMetricsVersion) {
        if (builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return "stream-" + metricsScope + "-state-metrics";
        }
        return "stream-state-metrics";
    }
}

