/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.List;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.To;

class KStreamBranch<K, V>
implements ProcessorSupplier<K, V> {
    private final List<Predicate<? super K, ? super V>> predicates;
    private final List<String> childNodes;

    KStreamBranch(List<Predicate<? super K, ? super V>> predicates, List<String> childNodes) {
        this.predicates = predicates;
        this.childNodes = childNodes;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamBranchProcessor();
    }

    private class KStreamBranchProcessor
    extends AbstractProcessor<K, V> {
        private KStreamBranchProcessor() {
        }

        @Override
        public void process(K key, V value) {
            for (int i = 0; i < KStreamBranch.this.predicates.size(); ++i) {
                if (!((Predicate)KStreamBranch.this.predicates.get(i)).test(key, value)) continue;
                this.context().forward(key, value, To.child((String)KStreamBranch.this.childNodes.get(i)));
                return;
            }
            if (KStreamBranch.this.childNodes.size() > KStreamBranch.this.predicates.size()) {
                this.context().forward(key, value, To.child((String)KStreamBranch.this.childNodes.get(KStreamBranch.this.predicates.size())));
            }
        }
    }
}

