/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KTableMapValues<K, V, V1>
implements KTableProcessorSupplier<K, V, V1> {
    private final KTableImpl<K, ?, V> parent;
    private final ValueMapperWithKey<? super K, ? super V, ? extends V1> mapper;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableMapValues(KTableImpl<K, ?, V> parent, ValueMapperWithKey<? super K, ? super V, ? extends V1> mapper, String queryableName) {
        this.parent = parent;
        this.mapper = mapper;
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableMapValuesProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V1> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V1>(){
            final KTableValueGetterSupplier<K, V> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableMapValues.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<K, V1> get() {
                return new KTableMapValuesValueGetter(this.parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private V1 computeValue(K key, V value) {
        V1 newValue = null;
        if (value != null) {
            newValue = this.mapper.apply(key, value);
        }
        return newValue;
    }

    private ValueAndTimestamp<V1> computeValueAndTimestamp(K key, ValueAndTimestamp<V> valueAndTimestamp) {
        Object newValue = null;
        long timestamp = 0L;
        if (valueAndTimestamp != null) {
            newValue = this.mapper.apply(key, valueAndTimestamp.value());
            timestamp = valueAndTimestamp.timestamp();
        }
        return ValueAndTimestamp.make(newValue, timestamp);
    }

    private class KTableMapValuesValueGetter
    implements KTableValueGetter<K, V1> {
        private final KTableValueGetter<K, V> parentGetter;

        KTableMapValuesValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public ValueAndTimestamp<V1> get(K key) {
            return KTableMapValues.this.computeValueAndTimestamp(key, this.parentGetter.get(key));
        }

        @Override
        public void close() {
            this.parentGetter.close();
        }
    }

    private class KTableMapValuesProcessor
    extends AbstractProcessor<K, Change<V>> {
        private TimestampedKeyValueStore<K, V1> store;
        private TimestampedTupleForwarder<K, V1> tupleForwarder;

        private KTableMapValuesProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableMapValues.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableMapValues.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableMapValues.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> change) {
            Object newValue = KTableMapValues.this.computeValue(key, change.newValue);
            Object oldValue = this.computeOldValue(key, change);
            if (KTableMapValues.this.queryableName != null) {
                this.store.put(key, ValueAndTimestamp.make(newValue, this.context().timestamp()));
                this.tupleForwarder.maybeForward(key, newValue, oldValue);
            } else {
                this.context().forward(key, new Change<Object>(newValue, oldValue));
            }
        }

        private V1 computeOldValue(K key, Change<V> change) {
            if (!KTableMapValues.this.sendOldValues) {
                return null;
            }
            return KTableMapValues.this.queryableName != null ? ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.store.get(key)) : KTableMapValues.this.computeValue(key, change.oldValue);
        }
    }
}

