/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.Murmur3;

public class SubscriptionResolverJoinProcessorSupplier<K, V, VO, VR>
implements ProcessorSupplier<K, SubscriptionResponseWrapper<VO>> {
    private final KTableValueGetterSupplier<K, V> valueGetterSupplier;
    private final Serializer<V> constructionTimeValueSerializer;
    private final Supplier<String> valueHashSerdePseudoTopicSupplier;
    private final ValueJoiner<V, VO, VR> joiner;
    private final boolean leftJoin;

    public SubscriptionResolverJoinProcessorSupplier(KTableValueGetterSupplier<K, V> valueGetterSupplier, Serializer<V> valueSerializer, Supplier<String> valueHashSerdePseudoTopicSupplier, ValueJoiner<V, VO, VR> joiner, boolean leftJoin) {
        this.valueGetterSupplier = valueGetterSupplier;
        this.constructionTimeValueSerializer = valueSerializer;
        this.valueHashSerdePseudoTopicSupplier = valueHashSerdePseudoTopicSupplier;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
    }

    @Override
    public Processor<K, SubscriptionResponseWrapper<VO>> get() {
        return new AbstractProcessor<K, SubscriptionResponseWrapper<VO>>(){
            private String valueHashSerdePseudoTopic;
            private Serializer<V> runtimeValueSerializer;
            private KTableValueGetter<K, V> valueGetter;
            {
                this.runtimeValueSerializer = SubscriptionResolverJoinProcessorSupplier.this.constructionTimeValueSerializer;
            }

            @Override
            public void init(ProcessorContext context) {
                super.init(context);
                this.valueHashSerdePseudoTopic = (String)SubscriptionResolverJoinProcessorSupplier.this.valueHashSerdePseudoTopicSupplier.get();
                this.valueGetter = SubscriptionResolverJoinProcessorSupplier.this.valueGetterSupplier.get();
                this.valueGetter.init(context);
                if (this.runtimeValueSerializer == null) {
                    this.runtimeValueSerializer = context.valueSerde().serializer();
                }
            }

            @Override
            public void process(K key, SubscriptionResponseWrapper<VO> value) {
                if (value.getVersion() != 0) {
                    throw new UnsupportedVersionException("SubscriptionResponseWrapper is of an incompatible version.");
                }
                ValueAndTimestamp currentValueWithTimestamp = this.valueGetter.get(key);
                long[] currentHash = currentValueWithTimestamp == null ? null : Murmur3.hash128(this.runtimeValueSerializer.serialize(this.valueHashSerdePseudoTopic, currentValueWithTimestamp.value()));
                long[] messageHash = value.getOriginalValueHash();
                if (Arrays.equals(messageHash, currentHash)) {
                    Object result = value.getForeignValue() == null && (!SubscriptionResolverJoinProcessorSupplier.this.leftJoin || currentValueWithTimestamp == null) ? null : (Object)SubscriptionResolverJoinProcessorSupplier.this.joiner.apply(currentValueWithTimestamp == null ? null : (Object)currentValueWithTimestamp.value(), value.getForeignValue());
                    this.context().forward(key, result);
                }
            }
        };
    }
}

