/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.TimeOrderedKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBTimeOrderedWindowStore
extends WrappedStateStore<SegmentedBytesStore, Object, Object>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    private final long windowSize;
    private int seqnum = 0;

    RocksDBTimeOrderedWindowStore(SegmentedBytesStore bytesStore, boolean retainDuplicates, long windowSize) {
        super(bytesStore);
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void put(Bytes key, byte[] value, long timestamp) {
        if (value != null || !this.retainDuplicates) {
            this.maybeUpdateSeqnumForDups();
            ((SegmentedBytesStore)this.wrapped()).put(TimeOrderedKeySchema.toStoreKeyBinary(key, timestamp, this.seqnum), value);
        } else {
            ((SegmentedBytesStore)this.wrapped()).remove(key, timestamp);
        }
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).all();
        return new TimeOrderedWindowStoreIteratorWrapper(bytesIterator, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }

    static class TimeOrderedWindowStoreIteratorWrapper {
        private final KeyValueIterator<Bytes, byte[]> bytesIterator;
        private final long windowSize;

        TimeOrderedWindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize) {
            this.bytesIterator = bytesIterator;
            this.windowSize = windowSize;
        }

        public WindowStoreIterator<byte[]> valuesIterator() {
            return new WrappedWindowStoreIterator(this.bytesIterator);
        }

        public KeyValueIterator<Windowed<Bytes>, byte[]> keyValueIterator() {
            return new WrappedKeyValueIterator(this.bytesIterator, this.windowSize);
        }

        private static class WrappedKeyValueIterator
        implements KeyValueIterator<Windowed<Bytes>, byte[]> {
            final KeyValueIterator<Bytes, byte[]> bytesIterator;
            final long windowSize;

            WrappedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize) {
                this.bytesIterator = bytesIterator;
                this.windowSize = windowSize;
            }

            @Override
            public Windowed<Bytes> peekNextKey() {
                byte[] nextKey = this.bytesIterator.peekNextKey().get();
                return TimeOrderedKeySchema.fromStoreBytesKey(nextKey, this.windowSize);
            }

            @Override
            public boolean hasNext() {
                return this.bytesIterator.hasNext();
            }

            @Override
            public KeyValue<Windowed<Bytes>, byte[]> next() {
                KeyValue next = (KeyValue)this.bytesIterator.next();
                return KeyValue.pair(TimeOrderedKeySchema.fromStoreBytesKey(((Bytes)next.key).get(), this.windowSize), next.value);
            }

            @Override
            public void close() {
                this.bytesIterator.close();
            }
        }

        private static class WrappedWindowStoreIterator
        implements WindowStoreIterator<byte[]> {
            final KeyValueIterator<Bytes, byte[]> bytesIterator;

            WrappedWindowStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator) {
                this.bytesIterator = bytesIterator;
            }

            @Override
            public Long peekNextKey() {
                return TimeOrderedKeySchema.extractStoreTimestamp(this.bytesIterator.peekNextKey().get());
            }

            @Override
            public boolean hasNext() {
                return this.bytesIterator.hasNext();
            }

            @Override
            public KeyValue<Long, byte[]> next() {
                KeyValue next = (KeyValue)this.bytesIterator.next();
                long timestamp = TimeOrderedKeySchema.extractStoreTimestamp(((Bytes)next.key).get());
                return KeyValue.pair(timestamp, next.value);
            }

            @Override
            public void close() {
                this.bytesIterator.close();
            }
        }
    }
}

