/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.state.internals.RecordConverter;

public final class RecordConverters {
    private static final RecordConverter IDENTITY_INSTANCE = record -> record;
    private static final RecordConverter RAW_TO_TIMESTAMED_INSTANCE = record -> {
        byte[] rawValue = (byte[])record.value();
        long timestamp = record.timestamp();
        byte[] recordValue = rawValue == null ? null : ByteBuffer.allocate(8 + rawValue.length).putLong(timestamp).put(rawValue).array();
        return new ConsumerRecord(record.topic(), record.partition(), record.offset(), timestamp, record.timestampType(), record.serializedKeySize(), record.serializedValueSize(), record.key(), (Object)recordValue, record.headers(), record.leaderEpoch());
    };

    private RecordConverters() {
    }

    public static RecordConverter rawValueToTimestampedValue() {
        return RAW_TO_TIMESTAMED_INSTANCE;
    }

    public static RecordConverter identity() {
        return IDENTITY_INSTANCE;
    }
}

