/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamFlatTransform<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn, KOut, VOut> {
    private final TransformerSupplier<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformerSupplier;

    public KStreamFlatTransform(TransformerSupplier<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformerSupplier) {
        this.transformerSupplier = transformerSupplier;
    }

    @Override
    public Processor<KIn, VIn, KOut, VOut> get() {
        return new KStreamFlatTransformProcessor(this.transformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.transformerSupplier.stores();
    }

    public static class KStreamFlatTransformProcessor<KIn, VIn, KOut, VOut>
    extends ContextualProcessor<KIn, VIn, KOut, VOut> {
        private final Transformer<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformer;

        public KStreamFlatTransformProcessor(Transformer<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void init(ProcessorContext<KOut, VOut> context) {
            super.init(context);
            this.transformer.init((InternalProcessorContext)context);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            Iterable<KeyValue<KOut, VOut>> pairs = this.transformer.transform(record.key(), record.value());
            if (pairs != null) {
                for (KeyValue<KOut, VOut> pair : pairs) {
                    this.context().forward(record.withKey(pair.key).withValue(pair.value));
                }
            }
        }

        @Override
        public void close() {
            this.transformer.close();
        }
    }
}

