/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedStreamImpl;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class SessionWindowedCogroupedKStreamImpl<K, V>
extends AbstractStream<K, V>
implements SessionWindowedCogroupedKStream<K, V> {
    private final SessionWindows sessionWindows;
    private final CogroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns;

    SessionWindowedCogroupedKStreamImpl(SessionWindows sessionWindows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, CogroupedStreamAggregateBuilder<K, V> aggregateBuilder, GraphNode graphNode, Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns) {
        super(name, null, null, subTopologySourceNodes, graphNode, builder);
        this.sessionWindows = sessionWindows;
        this.aggregateBuilder = aggregateBuilder;
        this.groupPatterns = groupPatterns;
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger) {
        return this.aggregate(initializer, sessionMerger, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, sessionMerger, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Named named) {
        return this.aggregate(initializer, sessionMerger, named, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Merger<? super K, V> sessionMerger, Named named, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Objects.requireNonNull(named, "named can't be null");
        MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, SessionStore<Bytes, byte[]>>(materialized, this.builder, "COGROUPKSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(this.groupPatterns, initializer, new NamedInternal(named), this.materialize(materializedInternal), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde(), materializedInternal.queryableStoreName(), this.sessionWindows, sessionMerger);
    }

    private StoreBuilder<SessionStore<K, V>> materialize(MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materialized) {
        SessionBytesStoreSupplier supplier = (SessionBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            long retentionPeriod;
            long l = retentionPeriod = materialized.retention() != null ? materialized.retention().toMillis() : this.sessionWindows.inactivityGap() + this.sessionWindows.gracePeriodMs();
            if (this.sessionWindows.inactivityGap() + this.sessionWindows.gracePeriodMs() > retentionPeriod) {
                throw new IllegalArgumentException("The retention period of the session store " + materialized.storeName() + " must be no smaller than the session inactivity gap plus the grace period. Got gap=[" + this.sessionWindows.inactivityGap() + "], grace=[" + this.sessionWindows.gracePeriodMs() + "], retention=[" + retentionPeriod + "]");
            }
            switch (materialized.storeType()) {
                case IN_MEMORY: {
                    supplier = Stores.inMemorySessionStore(materialized.storeName(), Duration.ofMillis(retentionPeriod));
                    break;
                }
                case ROCKS_DB: {
                    supplier = Stores.persistentSessionStore(materialized.storeName(), Duration.ofMillis(retentionPeriod));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown store type: " + (Object)((Object)materialized.storeType()));
                }
            }
        }
        StoreBuilder<SessionStore<K, V>> builder = Stores.sessionStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }
}

