/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueByteStoreAdapter;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;

public class TimestampedKeyValueStoreBuilder<K, V>
extends AbstractStoreBuilder<K, ValueAndTimestamp<V>, TimestampedKeyValueStore<K, V>> {
    private final KeyValueBytesStoreSupplier storeSupplier;

    public TimestampedKeyValueStoreBuilder(KeyValueBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde == null ? null : new ValueAndTimestampSerde<V>(valueSerde), time);
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Objects.requireNonNull(storeSupplier.metricsScope(), "storeSupplier's metricsScope can't be null");
        this.storeSupplier = storeSupplier;
    }

    @Override
    public TimestampedKeyValueStore<K, V> build() {
        KeyValueStore<Bytes, byte[]> store = (KeyValueStore<Bytes, byte[]>)this.storeSupplier.get();
        if (!(store instanceof TimestampedBytesStore)) {
            store = store.persistent() ? new KeyValueToTimestampedKeyValueByteStoreAdapter(store) : new InMemoryTimestampedKeyValueStoreMarker(store);
        }
        return new MeteredTimestampedKeyValueStore(this.maybeWrapCaching(this.maybeWrapLogging(store)), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapCaching(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        return new CachingKeyValueStore(inner, true);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapLogging(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingTimestampedKeyValueBytesStore(inner);
    }

    private static final class InMemoryTimestampedKeyValueStoreMarker
    implements KeyValueStore<Bytes, byte[]>,
    TimestampedBytesStore {
        final KeyValueStore<Bytes, byte[]> wrapped;

        private InMemoryTimestampedKeyValueStoreMarker(KeyValueStore<Bytes, byte[]> wrapped) {
            if (wrapped.persistent()) {
                throw new IllegalArgumentException("Provided store must not be a persistent store, but it is.");
            }
            this.wrapped = wrapped;
        }

        @Override
        @Deprecated
        public void init(ProcessorContext context, StateStore root) {
            this.wrapped.init(context, root);
        }

        @Override
        public void init(StateStoreContext context, StateStore root) {
            this.wrapped.init(context, root);
        }

        @Override
        public void put(Bytes key, byte[] value) {
            this.wrapped.put(key, value);
        }

        @Override
        public byte[] putIfAbsent(Bytes key, byte[] value) {
            return this.wrapped.putIfAbsent(key, value);
        }

        @Override
        public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
            this.wrapped.putAll(entries);
        }

        @Override
        public byte[] delete(Bytes key) {
            return this.wrapped.delete(key);
        }

        @Override
        public byte[] get(Bytes key) {
            return (byte[])this.wrapped.get(key);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
            return this.wrapped.range(from, to);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
            return this.wrapped.reverseRange(from, to);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> all() {
            return this.wrapped.all();
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> reverseAll() {
            return this.wrapped.reverseAll();
        }

        @Override
        public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
            return this.wrapped.prefixScan(prefix, prefixKeySerializer);
        }

        @Override
        public long approximateNumEntries() {
            return this.wrapped.approximateNumEntries();
        }

        @Override
        public void flush() {
            this.wrapped.flush();
        }

        @Override
        public void close() {
            this.wrapped.close();
        }

        @Override
        public boolean isOpen() {
            return this.wrapped.isOpen();
        }

        @Override
        public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
            long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
            QueryResult<R> result = this.wrapped.query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                long end = System.nanoTime();
                result.addExecutionInfo("Handled in " + this.getClass() + " in " + (end - start) + "ns");
            }
            return result;
        }

        @Override
        public Position getPosition() {
            return this.wrapped.getPosition();
        }

        @Override
        public String name() {
            return this.wrapped.name();
        }

        @Override
        public boolean persistent() {
            return false;
        }
    }
}

