/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Bytes;

class OrderedBytes {
    private static final int MIN_KEY_LENGTH = 1;

    OrderedBytes() {
    }

    static Bytes upperRange(Bytes key, byte[] maxSuffix) {
        byte[] bytes = key.get();
        ByteBuffer rangeEnd = ByteBuffer.allocate(bytes.length + maxSuffix.length);
        int firstTimestampByte = maxSuffix[0] & 0xFF;
        if (firstTimestampByte == 0) {
            return Bytes.wrap((byte[])rangeEnd.put(bytes).put(maxSuffix).array());
        }
        int i = 0;
        while (i < bytes.length && (i < 1 || (bytes[i] & 0xFF) >= firstTimestampByte)) {
            rangeEnd.put(bytes[i++]);
        }
        rangeEnd.put(maxSuffix);
        rangeEnd.flip();
        byte[] res = new byte[rangeEnd.remaining()];
        ByteBuffer.wrap(res).put(rangeEnd);
        return Bytes.wrap((byte[])res);
    }

    static Bytes lowerRange(Bytes key, byte[] minSuffix) {
        byte[] bytes = key.get();
        ByteBuffer rangeStart = ByteBuffer.allocate(bytes.length + minSuffix.length);
        return Bytes.wrap((byte[])rangeStart.put(bytes).put(minSuffix).array());
    }
}

