/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;

public class Change<T> {
    public final T newValue;
    public final T oldValue;
    public final boolean isLatest;

    public Change(T newValue, T oldValue) {
        this(newValue, oldValue, true);
    }

    public Change(T newValue, T oldValue, boolean isLatest) {
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.isLatest = isLatest;
    }

    public String toString() {
        return "(" + String.valueOf(this.newValue) + "<-" + String.valueOf(this.oldValue) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        return Objects.equals(this.newValue, change.newValue) && Objects.equals(this.oldValue, change.oldValue) && this.isLatest == change.isLatest;
    }

    public int hashCode() {
        return Objects.hash(this.newValue, this.oldValue, this.isLatest);
    }
}

