/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.state.KeyValueIterator;

public class WindowRangeQuery<K, V>
implements Query<KeyValueIterator<Windowed<K>, V>> {
    private final Optional<K> key;
    private final Optional<Instant> timeFrom;
    private final Optional<Instant> timeTo;

    private WindowRangeQuery(Optional<K> key, Optional<Instant> timeFrom, Optional<Instant> timeTo) {
        this.key = key;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
    }

    public static <K, V> WindowRangeQuery<K, V> withKey(K key) {
        return new WindowRangeQuery<K, V>(Optional.of(key), Optional.empty(), Optional.empty());
    }

    public static <K, V> WindowRangeQuery<K, V> withWindowStartRange(Instant timeFrom, Instant timeTo) {
        return new WindowRangeQuery(Optional.empty(), Optional.of(timeFrom), Optional.of(timeTo));
    }

    public Optional<K> getKey() {
        return this.key;
    }

    public Optional<Instant> getTimeFrom() {
        return this.timeFrom;
    }

    public Optional<Instant> getTimeTo() {
        return this.timeTo;
    }

    public String toString() {
        return "WindowRangeQuery{key=" + String.valueOf(this.key) + ", timeFrom=" + String.valueOf(this.timeFrom) + ", timeTo=" + String.valueOf(this.timeTo) + "}";
    }
}

