/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowedDeserializerTest {
    private final long windowSize = 5000000L;
    private final TimeWindowedDeserializer<?> timeWindowedDeserializer = new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), Long.valueOf(5000000L));
    private final Map<String, String> props = new HashMap<String, String>();

    @Test
    public void testTimeWindowedDeserializerConstructor() {
        this.timeWindowedDeserializer.configure(this.props, true);
        Deserializer inner = this.timeWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be StringDeserializer", (boolean)(inner instanceof StringDeserializer));
        MatcherAssert.assertThat((Object)this.timeWindowedDeserializer.getWindowSize(), (Matcher)Is.is((Object)5000000L));
    }

    @Test
    public void shouldSetWindowSizeAndWindowedInnerDeserialiserThroughConfigs() {
        this.props.put("window.size.ms", "500");
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        deserializer.configure(this.props, false);
        MatcherAssert.assertThat((Object)deserializer.getWindowSize(), (Matcher)Is.is((Object)500L));
        Assert.assertTrue((boolean)(deserializer.innerDeserializer() instanceof ByteArrayDeserializer));
    }

    @Test
    public void shouldThrowErrorIfWindowSizeSetInConfigsAndConstructor() {
        this.props.put("window.size.ms", "500");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.timeWindowedDeserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfWindowSizeIsNotSet() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        Assert.assertThrows(IllegalArgumentException.class, () -> deserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfWindowedInnerClassDeserialiserIsNotSet() {
        this.props.put("window.size.ms", "500");
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        Assert.assertThrows(IllegalArgumentException.class, () -> deserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfWindowedInnerClassDeserialisersConflictInConstructorAndConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.timeWindowedDeserializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowConfigExceptionWhenInvalidWindowedInnerClassDeserialiserSupplied() {
        this.props.put("windowed.inner.class.serde", "some.non.existent.class");
        Assert.assertThrows(ConfigException.class, () -> this.timeWindowedDeserializer.configure(this.props, false));
    }
}

