/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.TimeOrderedKeySchema;
import org.junit.Assert;
import org.junit.Test;

public class TimeOrderedKeySchemaTest {
    private final String key = "key";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Serde<String> serde = Serdes.String();
    private final Window window = new TimeWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final StateSerdes<String, byte[]> stateSerdes = new StateSerdes("dummy", this.serde, Serdes.ByteArray());

    @Test
    public void shouldConvertToBinaryAndBack() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Windowed result = TimeOrderedKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, (Deserializer)this.stateSerdes.keyDeserializer(), (String)this.stateSerdes.topic());
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldExtractSequenceFromBinary() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((long)0L, (long)TimeOrderedKeySchema.extractStoreSequence((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((long)50L, (long)TimeOrderedKeySchema.extractStoreTimestamp((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractWindowFromBinary() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((Object)this.window, (Object)TimeOrderedKeySchema.extractStoreWindow((byte[])serialized.get(), (long)50L));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])TimeOrderedKeySchema.extractStoreKeyBytes((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractKeyFromBinary() {
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals(this.windowedKey, (Object)TimeOrderedKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, (Deserializer)this.stateSerdes.keyDeserializer(), (String)this.stateSerdes.topic()));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Windowed windowedBytesKey = new Windowed((Object)Bytes.wrap((byte[])"key".getBytes()), this.window);
        Bytes serialized = TimeOrderedKeySchema.toStoreKeyBinary((Windowed)windowedBytesKey, (int)0);
        Assert.assertEquals((Object)windowedBytesKey, (Object)TimeOrderedKeySchema.fromStoreBytesKey((byte[])serialized.get(), (long)50L));
    }
}

