/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collection;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableNewProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KTablePassThrough<KIn, VIn>
implements KTableNewProcessorSupplier<KIn, VIn, KIn, VIn> {
    private final Collection<KStreamAggProcessorSupplier> parents;
    private final String storeName;

    KTablePassThrough(Collection<KStreamAggProcessorSupplier> parents, String storeName) {
        this.parents = parents;
        this.storeName = storeName;
    }

    @Override
    public Processor<KIn, Change<VIn>, KIn, Change<VIn>> get() {
        return new KTablePassThroughProcessor();
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        for (KStreamAggProcessorSupplier parent : this.parents) {
            parent.enableSendingOldValues();
        }
        return true;
    }

    @Override
    public KTableValueGetterSupplier<KIn, VIn> view() {
        return new KTableValueGetterSupplier<KIn, VIn>(){

            @Override
            public KTableValueGetter<KIn, VIn> get() {
                return new KTablePassThroughValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KTablePassThrough.this.storeName};
            }
        };
    }

    private class KTablePassThroughValueGetter
    implements KTableValueGetter<KIn, VIn> {
        private TimestampedKeyValueStore<KIn, VIn> store;

        private KTablePassThroughValueGetter() {
        }

        @Override
        public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            this.store = (TimestampedKeyValueStore)context.getStateStore(KTablePassThrough.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VIn> get(KIn key) {
            return (ValueAndTimestamp)this.store.get(key);
        }
    }

    private class KTablePassThroughProcessor
    implements Processor<KIn, Change<VIn>, KIn, Change<VIn>> {
        private ProcessorContext<KIn, Change<VIn>> context;

        private KTablePassThroughProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VIn>> context) {
            this.context = context;
        }

        @Override
        public void process(Record<KIn, Change<VIn>> record) {
            this.context.forward(record);
        }
    }
}

