/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.AbstractKStreamTimeWindowAggregateProcessor;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamSlidingWindowAggregate<KIn, VIn, VAgg>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private static final Logger log = LoggerFactory.getLogger(KStreamSlidingWindowAggregate.class);
    private final String storeName;
    private final SlidingWindows windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private final EmitStrategy emitStrategy;
    private boolean sendOldValues = false;

    public KStreamSlidingWindowAggregate(SlidingWindows windows, String storeName, EmitStrategy emitStrategy, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
        this.emitStrategy = emitStrategy;
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamSlidingWindowAggregateProcessor(this.storeName, this.emitStrategy, this.sendOldValues);
    }

    public SlidingWindows windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSlidingWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamSlidingWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> windowedKey) {
            Object key = windowedKey.key();
            return (ValueAndTimestamp)this.windowStore.fetch(key, windowedKey.window().start());
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isVersioned() {
            return false;
        }
    }

    private class KStreamSlidingWindowAggregateProcessor
    extends AbstractKStreamTimeWindowAggregateProcessor<KIn, VIn, VAgg> {
        private Boolean reverseIteratorPossible;

        protected KStreamSlidingWindowAggregateProcessor(String storeName, EmitStrategy emitStrategy, boolean sendOldValues) {
            super(storeName, emitStrategy, sendOldValues);
            this.reverseIteratorPossible = null;
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            if (record.key() == null || record.value() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    log.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    log.warn("Skipping record due to null key or value. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            this.updateObservedStreamTime(record.timestamp());
            long windowCloseTime = this.observedStreamTime - KStreamSlidingWindowAggregate.this.windows.gracePeriodMs();
            long windowStart = record.timestamp();
            long windowEnd = record.timestamp() + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs();
            if (windowEnd < windowCloseTime) {
                String window = "[" + windowStart + "," + windowEnd + "]";
                this.logSkippedRecordForExpiredWindow(log, record.timestamp(), windowCloseTime, window);
                return;
            }
            if (record.timestamp() < KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()) {
                this.processEarly(record, windowCloseTime);
                return;
            }
            if (this.reverseIteratorPossible == null) {
                try (WindowStoreIterator iterator = this.windowStore.backwardFetch(record.key(), 0L, 0L);){
                    this.reverseIteratorPossible = true;
                    log.debug("Sliding Windows aggregate using a reverse iterator");
                }
                catch (UnsupportedOperationException e) {
                    this.reverseIteratorPossible = false;
                    log.debug("Sliding Windows aggregate using a forward iterator");
                }
            }
            if (this.reverseIteratorPossible.booleanValue()) {
                this.processReverse(record, windowCloseTime);
            } else {
                this.processInOrder(record, windowCloseTime);
            }
            this.maybeForwardFinalResult(record, windowCloseTime);
        }

        public void processInOrder(Record<KIn, VIn> record, long windowCloseTime) {
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            ValueAndTimestamp leftWinAgg = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean leftWinAlreadyCreated = false;
            boolean rightWinAlreadyCreated = false;
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.fetch(record.key(), record.key(), Math.max(0L, record.timestamp() - 2L * KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()), record.timestamp() + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long endTime = startTime + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs();
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (endTime < record.timestamp()) {
                        leftWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (endTime == record.timestamp()) {
                        leftWinAlreadyCreated = true;
                        if (windowMaxRecordTimestamp < record.timestamp()) {
                            previousRecordTimestamp = windowMaxRecordTimestamp;
                        }
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, record, windowCloseTime);
                        continue;
                    }
                    if (endTime > record.timestamp() && startTime <= record.timestamp()) {
                        rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, record, windowCloseTime);
                        continue;
                    }
                    if (startTime == record.timestamp() + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)record.timestamp());
                    throw new IllegalStateException("Unexpected window found when processing sliding windows");
                }
            }
            this.createWindows(record, windowCloseTime, windowStartTimes, rightWinAgg, leftWinAgg, leftWinAlreadyCreated, rightWinAlreadyCreated, previousRecordTimestamp);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void processReverse(Record<KIn, VIn> record, long windowCloseTime) {
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            ValueAndTimestamp leftWinAgg = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean leftWinAlreadyCreated = false;
            boolean rightWinAlreadyCreated = false;
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.backwardFetch(record.key(), record.key(), Math.max(0L, record.timestamp() - 2L * KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()), record.timestamp() + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long endTime = startTime + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs();
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (startTime == record.timestamp() + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    if (endTime > record.timestamp()) {
                        if (rightWinAgg == null) {
                            rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        }
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, record, windowCloseTime);
                        continue;
                    }
                    if (endTime == record.timestamp()) {
                        leftWinAlreadyCreated = true;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, record, windowCloseTime);
                        if (windowMaxRecordTimestamp >= record.timestamp()) {
                            return;
                        }
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (endTime >= record.timestamp()) {
                        log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)record.timestamp());
                        throw new IllegalStateException("Unexpected window found when processing sliding windows");
                    }
                    leftWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                    previousRecordTimestamp = windowMaxRecordTimestamp;
                    break;
                }
            }
            this.createWindows(record, windowCloseTime, windowStartTimes, rightWinAgg, leftWinAgg, leftWinAlreadyCreated, rightWinAlreadyCreated, previousRecordTimestamp);
        }

        private void processEarly(Record<KIn, VIn> record, long windowCloseTime) {
            if (record.timestamp() < 0L || record.timestamp() >= KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()) {
                log.error("Early record for sliding windows must fall between fall between 0 <= inputRecordTimestamp. Timestamp {} does not fall between 0 <= {}", (Object)record.timestamp(), (Object)KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
                throw new IllegalArgumentException("Early record for sliding windows must fall between fall between 0 <= inputRecordTimestamp");
            }
            KeyValue combinedWindow = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean rightWinAlreadyCreated = false;
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.fetch(record.key(), record.key(), 0L, record.timestamp() + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (startTime == 0L) {
                        combinedWindow = windowBeingProcessed;
                        if (windowMaxRecordTimestamp >= record.timestamp()) continue;
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (startTime <= record.timestamp()) {
                        rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, record, windowCloseTime);
                        continue;
                    }
                    if (startTime == record.timestamp() + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)record.timestamp());
                    throw new IllegalStateException("Unexpected window found when processing sliding windows");
                }
            }
            if (rightWinAgg == null && combinedWindow != null && ((ValueAndTimestamp)combinedWindow.value).timestamp() > record.timestamp()) {
                rightWinAgg = (ValueAndTimestamp)combinedWindow.value;
            }
            if (!rightWinAlreadyCreated && this.rightWindowIsNotEmpty(rightWinAgg, record.timestamp())) {
                this.createCurrentRecordRightWindow(record.timestamp(), rightWinAgg, record);
            }
            if (previousRecordTimestamp != null && !windowStartTimes.contains(previousRecordTimestamp + 1L)) {
                this.createPreviousRecordRightWindow(previousRecordTimestamp + 1L, record, windowCloseTime);
            }
            if (combinedWindow == null) {
                TimeWindow window = new TimeWindow(0L, KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
                ValueAndTimestamp valueAndTime = ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), record.timestamp());
                this.updateWindowAndForward(window, valueAndTime, record, windowCloseTime);
            } else {
                this.updateWindowAndForward(((Windowed)combinedWindow.key).window(), (ValueAndTimestamp)combinedWindow.value, record, windowCloseTime);
            }
        }

        private void createWindows(Record<KIn, VIn> record, long closeTime, Set<Long> windowStartTimes, ValueAndTimestamp<VAgg> rightWinAgg, ValueAndTimestamp<VAgg> leftWinAgg, boolean leftWinAlreadyCreated, boolean rightWinAlreadyCreated, Long previousRecordTimestamp) {
            long previousRightWinStart;
            if (previousRecordTimestamp != null && this.previousRecordRightWindowDoesNotExistAndIsNotEmpty(windowStartTimes, previousRightWinStart = previousRecordTimestamp + 1L, record.timestamp())) {
                this.createPreviousRecordRightWindow(previousRightWinStart, record, closeTime);
            }
            if (!leftWinAlreadyCreated) {
                ValueAndTimestamp valueAndTime = this.leftWindowNotEmpty(previousRecordTimestamp, record.timestamp()) ? ValueAndTimestamp.make(leftWinAgg.value(), record.timestamp()) : ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), record.timestamp());
                TimeWindow window = new TimeWindow(record.timestamp() - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs(), record.timestamp());
                this.updateWindowAndForward(window, valueAndTime, record, closeTime);
            }
            if (!rightWinAlreadyCreated && this.rightWindowIsNotEmpty(rightWinAgg, record.timestamp())) {
                this.createCurrentRecordRightWindow(record.timestamp(), rightWinAgg, record);
            }
        }

        private void createCurrentRecordRightWindow(long inputRecordTimestamp, ValueAndTimestamp<VAgg> rightWinAgg, Record<KIn, VIn> record) {
            TimeWindow window = new TimeWindow(inputRecordTimestamp + 1L, inputRecordTimestamp + 1L + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
            this.windowStore.put(record.key(), rightWinAgg, window.start());
            this.maybeForwardUpdate(record, window, null, rightWinAgg.value(), rightWinAgg.timestamp());
        }

        private void createPreviousRecordRightWindow(long windowStart, Record<KIn, VIn> record, long closeTime) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
            ValueAndTimestamp valueAndTime = ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), record.timestamp());
            this.updateWindowAndForward(window, valueAndTime, record, closeTime);
        }

        private boolean leftWindowNotEmpty(Long previousRecordTimestamp, long inputRecordTimestamp) {
            return previousRecordTimestamp != null && inputRecordTimestamp - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() <= previousRecordTimestamp;
        }

        private boolean previousRecordRightWindowDoesNotExistAndIsNotEmpty(Set<Long> windowStartTimes, long previousRightWindowStart, long inputRecordTimestamp) {
            return !windowStartTimes.contains(previousRightWindowStart) && previousRightWindowStart + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() >= inputRecordTimestamp;
        }

        private boolean rightWindowIsNotEmpty(ValueAndTimestamp<VAgg> rightWinAgg, long inputRecordTimestamp) {
            return rightWinAgg != null && rightWinAgg.timestamp() > inputRecordTimestamp;
        }

        @Override
        protected long emitRangeLowerBound(long windowCloseTime) {
            return this.lastEmitWindowCloseTime == -1L ? 0L : Math.max(0L, this.lastEmitWindowCloseTime - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
        }

        @Override
        protected long emitRangeUpperBound(long windowCloseTime) {
            return windowCloseTime - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() - 1L;
        }

        @Override
        protected boolean shouldRangeFetch(long emitRangeLowerBound, long emitRangeUpperBound) {
            return true;
        }

        private void updateWindowAndForward(Window window, ValueAndTimestamp<VAgg> valueAndTime, Record<KIn, VIn> record, long windowCloseTime) {
            long windowStart = window.start();
            long windowEnd = window.end();
            if (windowEnd >= windowCloseTime) {
                Object oldAgg = ValueAndTimestamp.getValueOrNull(valueAndTime);
                Object newAgg = KStreamSlidingWindowAggregate.this.aggregator.apply(record.key(), record.value(), oldAgg);
                long newTimestamp = oldAgg == null ? record.timestamp() : Math.max(record.timestamp(), valueAndTime.timestamp());
                this.windowStore.put(record.key(), ValueAndTimestamp.make(newAgg, newTimestamp), windowStart);
                this.maybeForwardUpdate(record, window, oldAgg, newAgg, newTimestamp);
            } else {
                String windowString = "[" + windowStart + "," + windowEnd + "]";
                this.logSkippedRecordForExpiredWindow(log, record.timestamp(), windowCloseTime, windowString);
            }
        }
    }
}

