/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.TerseException;

public class ClusterTool {
    public static void main(String ... args) {
        Exit.exit((int)ClusterTool.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            ClusterTool.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void execute(String ... args) throws Exception {
        parser = ArgumentParsers.newArgumentParser((String)"kafka-cluster").defaultHelp(true).description("The Kafka cluster tool.");
        subparsers = parser.addSubparsers().dest("command");
        clusterIdParser = subparsers.addParser("cluster-id").help("Get information about the ID of a cluster.");
        unregisterParser = subparsers.addParser("unregister").help("Unregister a broker.");
        for (Subparser subpparser : Arrays.asList(new Subparser[]{clusterIdParser, unregisterParser})) {
            subpparser.addArgument(new String[]{"--bootstrap-server", "-b"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the Kafka cluster.");
            subpparser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).help("A property file containing configurations for the Admin client.");
        }
        unregisterParser.addArgument(new String[]{"--id", "-i"}).type(Integer.class).action((ArgumentAction)Arguments.store()).required(true).help("The ID of the broker to unregister.");
        namespace = parser.parseArgsOrFail(args);
        command = namespace.getString("command");
        configPath = namespace.getString("config");
        properties = configPath == null ? new Properties() : Utils.loadProps((String)configPath);
        bootstrapServer = namespace.getString("bootstrap_server");
        if (bootstrapServer != null) {
            properties.setProperty("bootstrap.servers", bootstrapServer);
        }
        if (properties.getProperty("bootstrap.servers") == null) {
            throw new TerseException("Please specify --bootstrap-server.");
        }
        var10_10 = command;
        var11_11 = -1;
        switch (var10_10.hashCode()) {
            case 240232910: {
                if (!var10_10.equals("cluster-id")) break;
                var11_11 = 0;
                break;
            }
            case 836015164: {
                if (!var10_10.equals("unregister")) break;
                var11_11 = 1;
            }
        }
        switch (var11_11) {
            case 0: {
                adminClient = Admin.create((Properties)properties);
                var13_14 = null;
                ClusterTool.clusterIdCommand(System.out, adminClient);
                if (adminClient == null) break;
                if (var13_14 == null) ** GOTO lbl47
                try {
                    adminClient.close();
                }
                catch (Throwable var14_16) {
                    var13_14.addSuppressed(var14_16);
                }
                break;
lbl47:
                // 1 sources

                adminClient.close();
                break;
                catch (Throwable var14_17) {
                    try {
                        var13_14 = var14_17;
                        throw var14_17;
                    }
                    catch (Throwable var15_20) {
                        if (adminClient != null) {
                            if (var13_14 != null) {
                                try {
                                    adminClient.close();
                                }
                                catch (Throwable var16_21) {
                                    var13_14.addSuppressed(var16_21);
                                }
                            } else {
                                adminClient.close();
                            }
                        }
                        throw var15_20;
                    }
                }
            }
            case 1: {
                adminClient = Admin.create((Properties)properties);
                var13_15 = null;
                ClusterTool.unregisterCommand(System.out, adminClient, namespace.getInt("id"));
                if (adminClient == null) break;
                if (var13_15 == null) ** GOTO lbl77
                try {
                    adminClient.close();
                }
                catch (Throwable var14_18) {
                    var13_15.addSuppressed(var14_18);
                }
                break;
lbl77:
                // 1 sources

                adminClient.close();
                break;
                catch (Throwable var14_19) {
                    try {
                        var13_15 = var14_19;
                        throw var14_19;
                    }
                    catch (Throwable var17_22) {
                        if (adminClient != null) {
                            if (var13_15 != null) {
                                try {
                                    adminClient.close();
                                }
                                catch (Throwable var18_23) {
                                    var13_15.addSuppressed(var18_23);
                                }
                            } else {
                                adminClient.close();
                            }
                        }
                        throw var17_22;
                    }
                }
            }
            default: {
                throw new RuntimeException("Unknown command " + command);
            }
        }
    }

    static void clusterIdCommand(PrintStream stream, Admin adminClient) throws Exception {
        String clusterId = (String)adminClient.describeCluster().clusterId().get();
        if (clusterId != null) {
            stream.println("Cluster ID: " + clusterId);
        } else {
            stream.println("No cluster ID found. The Kafka version is probably too old.");
        }
    }

    static void unregisterCommand(PrintStream stream, Admin adminClient, int id) throws Exception {
        try {
            adminClient.unregisterBroker(id).all().get();
            stream.println("Broker " + id + " is no longer registered.");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof UnsupportedVersionException) {
                stream.println("The target cluster does not support the broker unregistration API.");
            }
            throw ee;
        }
    }
}

