/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\ru!B\u0001\u0003\u0011\u00039\u0011!\u0007*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051BA\rSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063%!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001H\u0005\u0005\u0002u\tA!\\1j]R\u0011a$\t\t\u0003\u001b}I!\u0001\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Em\u0001\raI\u0001\u0005CJ<7\u000fE\u0002\u000eI\u0019J!!\n\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001dRcBA\u0007)\u0013\tIc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015\u000f\u0011\u0015q\u0013\u0002\"\u00010\u0003A1XM]5gs\u0006\u001b8/[4o[\u0016tG\u000fF\u0002\u001faUBQ!M\u0017A\u0002I\nqA_6Vi&d7\u000f\u0005\u0002\u0014g%\u0011A\u0007\u0006\u0002\b5.,F/\u001b7t\u0011\u00151T\u00061\u00018\u0003\u0011y\u0007\u000f^:\u0011\u0005aJT\"A\u0005\u0007\tiJ\u0001a\u000f\u0002!%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tGm\u00149uS>t7o\u0005\u0002:\u0019!A!%\u000fB\u0001B\u0003%1\u0005C\u0003\u001as\u0011\u0005a\b\u0006\u00028\u007f!)!%\u0010a\u0001G!9\u0011)\u000fb\u0001\n\u0003\u0011\u0015A\u00029beN,'/F\u0001D!\t!u)D\u0001F\u0015\u00051\u0015A\u00036paR\u001c\u0018.\u001c9mK&\u0011\u0001*\u0012\u0002\r\u001fB$\u0018n\u001c8QCJ\u001cXM\u001d\u0005\u0007\u0015f\u0002\u000b\u0011B\"\u0002\u000fA\f'o]3sA!9A*\u000fb\u0001\n\u0003i\u0015\u0001\u0004>l\u0007>tg.Z2u\u001fB$X#\u0001(\u0011\u0007\u0011{e%\u0003\u0002Q\u000b\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDaAU\u001d!\u0002\u0013q\u0015!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004Us\t\u0007I\u0011A+\u0002\u0017\u001d,g.\u001a:bi\u0016|\u0005\u000f^\u000b\u0002-B\u0011AiV\u0005\u00031\u0016\u0013\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011\u0019Q\u0016\b)A\u0005-\u0006aq-\u001a8fe\u0006$Xm\u00149uA!9A,\u000fb\u0001\n\u0003)\u0016AC3yK\u000e,H/Z(qi\"1a,\u000fQ\u0001\nY\u000b1\"\u001a=fGV$Xm\u00149uA!9\u0001-\u000fb\u0001\n\u0003)\u0016!\u0003<fe&4\u0017p\u00149u\u0011\u0019\u0011\u0017\b)A\u0005-\u0006Qa/\u001a:jMf|\u0005\u000f\u001e\u0011\t\u000f\u0011L$\u0019!C\u0001\u001b\u00069\"/Z1tg&<g.\\3oi*\u001bxN\u001c$jY\u0016|\u0005\u000f\u001e\u0005\u0007Mf\u0002\u000b\u0011\u0002(\u00021I,\u0017m]:jO:lWM\u001c;Kg>tg)\u001b7f\u001fB$\b\u0005C\u0004is\t\u0007I\u0011A'\u0002/Q|\u0007/[2t)>luN^3Kg>tg)\u001b7f\u001fB$\bB\u00026:A\u0003%a*\u0001\ru_BL7m\u001d+p\u001b>4XMS:p]\u001aKG.Z(qi\u0002Bq\u0001\\\u001dC\u0002\u0013\u0005Q*A\u0007ce>\\WM\u001d'jgR|\u0005\u000f\u001e\u0005\u0007]f\u0002\u000b\u0011\u0002(\u0002\u001d\t\u0014xn[3s\u0019&\u001cHo\u00149uA!9\u0001/\u000fb\u0001\n\u0003)\u0016\u0001\u00053jg\u0006\u0014G.\u001a*bG.\fu/\u0019:f\u0011\u0019\u0011\u0018\b)A\u0005-\u0006\tB-[:bE2,'+Y2l\u0003^\f'/\u001a\u0011\t\u000fQL$\u0019!C\u0001k\u0006YA\u000f\u001b:piRdWm\u00149u+\u00051\bc\u0001#PoB\u0011Q\u0002_\u0005\u0003s:\u0011A\u0001T8oO\"110\u000fQ\u0001\nY\fA\u0002\u001e5s_R$H.Z(qi\u0002Bq!`\u001dC\u0002\u0013\u0005a0A\u0004paRLwN\\:\u0016\u0003}\u00042\u0001RA\u0001\u0013\r\t\u0019!\u0012\u0002\n\u001fB$\u0018n\u001c8TKRDq!a\u0002:A\u0003%q0\u0001\u0005paRLwN\\:!\u0011\u0019q\u0013\u0002\"\u0001\u0002\fQ)a$!\u0004\u0002\u0010!1\u0011'!\u0003A\u0002IBq!!\u0005\u0002\n\u0001\u0007a%\u0001\u0006kg>t7\u000b\u001e:j]\u001eD\u0001\"!\u0006\n\t\u0003\u0011\u0011qC\u0001\u000fe\u0016lwN^3UQJ|G\u000f\u001e7f)%q\u0012\u0011DA\u000e\u0003\u0007\ny\u0005\u0003\u00042\u0003'\u0001\rA\r\u0005\t\u0003;\t\u0019\u00021\u0001\u0002 \u0005A\u0002/\u0019:uSRLwN\\:U_\n+'+Z1tg&<g.\u001a3\u0011\u0011\u0005\u0005\u0012qEA\u0016\u0003oi!!a\t\u000b\u0007\u0005\u0015b\"\u0001\u0006d_2dWm\u0019;j_:LA!!\u000b\u0002$\t\u0019Q*\u00199\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r\u0005\u0003\u0019\u0019w.\\7p]&!\u0011QGA\u0018\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0007\u0003C\tI$!\u0010\n\t\u0005m\u00121\u0005\u0002\u0004'\u0016\f\bcA\u0007\u0002@%\u0019\u0011\u0011\t\b\u0003\u0007%sG\u000f\u0003\u0005\u0002F\u0005M\u0001\u0019AA$\u0003i\u0011X-Y:tS\u001etW\r\u001a)beRLG/[8ogN#\u0018\r^;t!!\t\t#a\n\u0002,\u0005%\u0003c\u0001\u0005\u0002L%\u0019\u0011Q\n\u0002\u0003%I+\u0017m]:jO:lWM\u001c;Ti\u0006$Xo\u001d\u0005\n\u0007\u0005M\u0001\u0013!a\u0001\u0003#\u00022\u0001CA*\u0013\r\t)F\u0001\u0002\u000f\u0003\u0012l\u0017N\\+uS2LG/[3t\u0011\u001d\tI&\u0003C\u0001\u00037\n!cZ3oKJ\fG/Z!tg&<g.\\3oiR)a$!\u0018\u0002`!1\u0011'a\u0016A\u0002IBaANA,\u0001\u00049\u0004bBA-\u0013\u0011\u0005\u00111\r\u000b\u000b\u0003K\nY'!\u001c\u0002r\u0005U\u0004cB\u0007\u0002h\u0005}\u0011qD\u0005\u0004\u0003Sr!A\u0002+va2,'\u0007\u0003\u00042\u0003C\u0002\rA\r\u0005\t\u0003_\n\t\u00071\u0001\u00028\u0005!\"M]8lKJd\u0015n\u001d;U_J+\u0017m]:jO:Dq!a\u001d\u0002b\u0001\u0007a%\u0001\fu_BL7m\u001d+p\u001b>4XMS:p]N#(/\u001b8h\u0011\u001d\u0001\u0018\u0011\ra\u0001\u0003o\u00022!DA=\u0013\r\tYH\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\ty(\u0003C\u0001\u0003\u0003\u000b\u0011#\u001a=fGV$X-Q:tS\u001etW.\u001a8u)\u0015q\u00121QAC\u0011\u0019\t\u0014Q\u0010a\u0001e!1a'! A\u0002]Bq!a \n\t\u0003\tI\tF\u0004\u001f\u0003\u0017\u000bi)!%\t\rE\n9\t1\u00013\u0011\u001d\ty)a\"A\u0002\u0019\naC]3bgNLwM\\7f]RT5o\u001c8TiJLgn\u001a\u0005\n\u0003'\u000b9\t%AA\u0002]\f\u0001\u0002\u001e5s_R$H.\u001a\u0005\b\u0003/KA\u0011AAM\u0003Y\u0001(/\u001b8u\u0007V\u0014(/\u001a8u\u0003N\u001c\u0018n\u001a8nK:$H#\u0002\u0010\u0002\u001c\u0006u\u0005BB\u0019\u0002\u0016\u0002\u0007!\u0007\u0003\u0005\u0002\u001e\u0005U\u0005\u0019AAP!\u0019\t\t#!\u000f\u0002\"B9Q\"a\u001a\u0002,\u0005]\u0002bBAS\u0013\u0011\u0005\u0011qU\u0001\u0011a\u0006\u00148/Z!oIZ\u000bG.\u001b3bi\u0016$b!a(\u0002*\u0006-\u0006BB\u0019\u0002$\u0002\u0007!\u0007C\u0004\u0002\u0010\u0006\r\u0006\u0019\u0001\u0014\t\u000f\u0005=\u0016\u0002\"\u0003\u00022\u0006a2\r[3dW&3'+Z1tg&<g.\\3oiN+8mY3fI\u0016$GCBA$\u0003g\u000b)\f\u0003\u00042\u0003[\u0003\rA\r\u0005\t\u0003;\ti\u000b1\u0001\u0002 !9\u0011\u0011X\u0005\u0005\u0002\u0005m\u0016!J2iK\u000e\\\u0017J\u001a)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^*vG\u000e,W\rZ3e))\tI%!0\u0002@\u0006\r\u0017Q\u0019\u0005\u0007c\u0005]\u0006\u0019\u0001\u001a\t\u0011\u0005\u0005\u0017q\u0017a\u0001\u0003W\t\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\ti\"a.A\u0002\u0005}\u0001\u0002CAd\u0003o\u0003\r!a\b\u00023A\f'\u000f^5uS>t7OQ3j]\u001e\u0014V-Y:tS\u001etW\r\u001a\u0005\b\u0003\u0017LA\u0011AAg\u0003Q1\u0018\r\\5eCR,\u0017I\u001c3QCJ\u001cX-\u0011:hgR\u0019q'a4\t\r\t\nI\r1\u0001$\u0011%\t\u0019.CI\u0001\n\u0003\t).A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003/TC!!\u0015\u0002Z.\u0012\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%)hn\u00195fG.,GMC\u0002\u0002f:\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI/a8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002n&\t\n\u0011\"\u0001\u0002p\u0006YR\r_3dkR,\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIM*\"!!=+\u0007]\fI\u000eC\u0005\u0002v&\t\n\u0011\"\u0001\u0002V\u0006A\"/Z7pm\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001b\u0007\u000b)\u0011\u0001!!?\u0014\t\u0005]HB\u0005\u0005\nc\u0005](\u0011!Q\u0001\nIB1\"a@\u0002x\n\u0005\t\u0015!\u0003\u0002 \u0005\u0011\u0002O]8q_N,G-Q:tS\u001etW.\u001a8u\u0011)\u0019\u0011q\u001fB\u0001B\u0003%\u0011\u0011\u000b\u0005\b3\u0005]H\u0011\u0001B\u0003)!\u00119A!\u0003\u0003\f\t5\u0001c\u0001\u0005\u0002x\"1\u0011Ga\u0001A\u0002IB\u0001\"a@\u0003\u0004\u0001\u0007\u0011q\u0004\u0005\n\u0007\t\r\u0001\u0013!a\u0001\u0003#B\u0001B!\u0005\u0002x\u0012\u0005!1C\u0001\u0013KbL7\u000f^5oO\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0002\u0002 !A!qCA|\t\u0013\u0011I\"A\u0007nCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0004=\tm\u0001bBAJ\u0005+\u0001\ra\u001e\u0005\t\u0005?\t9\u0010\"\u0001\u0003\"\u0005QQ.Y=cK2KW.\u001b;\u0015\u0007y\u0011\u0019\u0003C\u0004\u0002\u0014\nu\u0001\u0019A<\t\u0013\t\u001d\u0012q\u001fC\u0001\u0005\t%\u0012aF1tg&<g\u000e\u00165s_R$H.\u001a3SKBd\u0017nY1t)\u001dq\"1\u0006B\u0018\u0005gA\u0001B!\f\u0003&\u0001\u0007\u0011qD\u0001\fC2dW\t_5ti&tw\r\u0003\u0005\u00032\t\u0015\u0002\u0019AA\u0010\u0003-\tG\u000e\u001c)s_B|7/\u001a3\t\u0013\r\u0011)\u0003%AA\u0002\u0005E\u0003\u0002\u0003B\u001c\u0003o$IA!\u000f\u0002=A|7\u000f\u001e*fE\u0006d\u0017M\\2f%\u0016\u0004H.[2bgRC\u0017\r^'pm\u0016$GCBA\u0010\u0005w\u0011y\u0004\u0003\u0005\u0003>\tU\u0002\u0019AA\u0010\u0003!)\u00070[:uS:<\u0007\u0002\u0003B!\u0005k\u0001\r!a\b\u0002\u0011A\u0014x\u000e]8tK\u0012D\u0001B!\u0012\u0002x\u0012%!qI\u0001'aJ,'+\u001a2bY\u0006t7-\u001a*fa2L7-\u0019$pe6{g/\u001b8h!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0010\u0005\u0013\u0012Y\u0005\u0003\u0005\u0003>\t\r\u0003\u0019AA\u0010\u0011!\u0011\tEa\u0011A\u0002\u0005}\u0001\u0002\u0003B(\u0003o$\tA!\u0015\u0002\r\u0019|'/\\1u)\r1#1\u000b\u0005\t\u0005+\u0012i\u00051\u0001\u0002 \u0005)Qn\u001c<fg\"A!\u0011LA|\t\u0003\u0011Y&\u0001\u0005gS2$XM\u001d\"z)!\t)G!\u0018\u0003b\t\r\u0004b\u0002B0\u0005/\u0002\rAJ\u0001\u0006i>\u0004\u0018n\u0019\u0005\t\u0005[\u00119\u00061\u0001\u0002 !A!\u0011\u0007B,\u0001\u0004\ty\u0002\u0003\u0005\u0003h\u0005]H\u0011\u0001B5\u0003I\u0011X-Y:tS\u001et\u0007+\u0019:uSRLwN\\:\u0015\t\u0005]$1\u000e\u0005\n\u0003'\u0013)\u0007%AA\u0002]D\u0001Ba\u001c\u0002x\u0012\u0005!\u0011O\u0001\u0012m\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>tG\u0003CA<\u0005g\u0012)Ha\u001e\t\rE\u0012i\u00071\u00013\u0011\u001d\u0011yF!\u001cA\u0002\u0019B\u0001B!\u001f\u0003n\u0001\u0007\u0011QH\u0001\na\u0006\u0014H/\u001b;j_:D!B! \u0002xF\u0005I\u0011AAx\u0003q\u0011X-Y:tS\u001et\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIEB!B!!\u0002xF\u0005I\u0011AAk\u0003\u0005\n7o]5h]RC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class ReassignPartitionsCommand
implements Logging {
    public final ZkUtils kafka$admin$ReassignPartitionsCommand$$zkUtils;
    private final Map<TopicAndPartition, Seq<Object>> proposedAssignment;
    public final AdminUtilities kafka$admin$ReassignPartitionsCommand$$admin;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static AdminUtilities removeThrottle$default$4() {
        return ReassignPartitionsCommand$.MODULE$.removeThrottle$default$4();
    }

    public static long executeAssignment$default$3() {
        return ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3();
    }

    public static AdminUtilities $lessinit$greater$default$3() {
        return ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3();
    }

    public static ReassignPartitionsCommandOptions validateAndParseArgs(String[] stringArray) {
        return ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(stringArray);
    }

    public static ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> map, Map<TopicAndPartition, Seq<Object>> map2) {
        return ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(zkUtils, topicAndPartition, map, map2);
    }

    public static Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String string) {
        return ReassignPartitionsCommand$.MODULE$.parseAndValidate(zkUtils, string);
    }

    public static void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> seq) {
        ReassignPartitionsCommand$.MODULE$.printCurrentAssignment(zkUtils, seq);
    }

    public static void executeAssignment(ZkUtils zkUtils, String string, long l) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, string, l);
    }

    public static void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> seq, String string, boolean bl) {
        return ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, seq, string, bl);
    }

    public static void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void verifyAssignment(ZkUtils zkUtils, String string) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, string);
    }

    public static void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void main(String[] stringArray) {
        ReassignPartitionsCommand$.MODULE$.main(stringArray);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand reassignPartitionsCommand = this;
        synchronized (reassignPartitionsCommand) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Map<TopicAndPartition, Seq<Object>> existingAssignment() {
        Seq proposedTopics = ((SetLike)this.proposedAssignment.keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicAndPartition x$6) {
                return x$6.topic();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        return this.kafka$admin$ReassignPartitionsCommand$$zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
    }

    private void maybeThrottle(long throttle) {
        if (throttle >= 0L) {
            this.maybeLimit(throttle);
            this.assignThrottledReplicas(this.existingAssignment(), this.proposedAssignment, this.assignThrottledReplicas$default$3());
        }
    }

    public void maybeLimit(long throttle) {
        if (throttle >= 0L) {
            Seq existingBrokers = ((TraversableOnce)this.existingAssignment().values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
            Seq proposedBrokers = ((TraversableOnce)this.proposedAssignment.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
            Seq brokers = (Seq)((SeqLike)existingBrokers.$plus$plus((GenTraversableOnce)proposedBrokers, Seq$.MODULE$.canBuildFrom())).distinct();
            brokers.foreach((Function1)new Serializable(this, throttle){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReassignPartitionsCommand $outer;
                private final long throttle$1;

                public final void apply(int id) {
                    this.apply$mcVI$sp(id);
                }

                public void apply$mcVI$sp(int id) {
                    Properties configs = this.$outer.kafka$admin$ReassignPartitionsCommand$$admin.fetchEntityConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)id)).toString());
                    configs.put(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)this.throttle$1)).toString());
                    configs.put(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)this.throttle$1)).toString());
                    this.$outer.kafka$admin$ReassignPartitionsCommand$$admin.changeBrokerConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), configs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.throttle$1 = throttle$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The throttle limit was set to ", " B/s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttle)})));
        }
    }

    public void assignThrottledReplicas(Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed, AdminUtilities admin) {
        ((SetLike)allProposed.keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicAndPartition x$7) {
                return x$7.topic();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq().foreach((Function1)new Serializable(this, allExisting, allProposed, admin){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsCommand $outer;
            private final Map allExisting$1;
            private final Map allProposed$1;
            private final AdminUtilities admin$2;

            public final void apply(String topic) {
                Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.$outer.filterBy(topic, (Map<TopicAndPartition, Seq<Object>>)this.allExisting$1, (Map<TopicAndPartition, Seq<Object>>)this.allProposed$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Map existing = (Map)tuple2._1();
                    Map proposed = (Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)existing, (Object)proposed);
                    Map existing2 = (Map)tuple23._1();
                    Map proposed2 = (Map)tuple23._2();
                    String leader = this.$outer.format(this.$outer.kafka$admin$ReassignPartitionsCommand$$preRebalanceReplicaForMovingPartitions((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
                    String follower = this.$outer.format(this.$outer.kafka$admin$ReassignPartitionsCommand$$postRebalanceReplicasThatMoved((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
                    Properties configs = this.admin$2.fetchEntityConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, ConfigType$.MODULE$.Topic(), topic);
                    configs.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), leader);
                    configs.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), follower);
                    this.admin$2.changeTopicConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, topic, configs);
                    this.$outer.debug((Function0<String>)new Serializable(this, topic, leader){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;
                        private final String leader$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated leader-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.leader$1}));
                        }
                        {
                            this.topic$2 = topic$2;
                            this.leader$1 = leader$1;
                        }
                    });
                    this.$outer.debug((Function0<String>)new Serializable(this, topic, follower){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;
                        private final String follower$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated follower-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.follower$1}));
                        }
                        {
                            this.topic$2 = topic$2;
                            this.follower$1 = follower$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.allExisting$1 = allExisting$1;
                this.allProposed$1 = allProposed$1;
                this.admin$2 = admin$2;
            }
        });
    }

    public AdminUtilities assignThrottledReplicas$default$3() {
        return AdminUtils$.MODULE$;
    }

    public Map<TopicAndPartition, Seq<Object>> kafka$admin$ReassignPartitionsCommand$$postRebalanceReplicasThatMoved(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)proposed.map((Function1)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Map existing$1;

            public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$12) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$12;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq proposedReplicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tp), (Object)((SetLike)proposedReplicas.toSet().$minus$minus((GenTraversableOnce)this.existing$1.apply((Object)tp))).toSeq());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.existing$1 = existing$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, Seq<Object>> kafka$admin$ReassignPartitionsCommand$$preRebalanceReplicaForMovingPartitions(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.filter((Function1)new Serializable(this, proposed){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsCommand $outer;
            private final Map proposed$1;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$13) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$13;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq preMoveReplicas = (Seq)tuple2._2();
                    boolean bl = this.proposed$1.contains((Object)tp) && this.$outer.kafka$admin$ReassignPartitionsCommand$$moving$1(preMoveReplicas, (Seq)this.proposed$1.apply((Object)tp));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.proposed$1 = proposed$1;
            }
        });
    }

    public String format(Map<TopicAndPartition, Seq<Object>> moves) {
        return ((TraversableOnce)moves.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$14) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$14;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq moves = (Seq)tuple2._2();
                    Seq seq = (Seq)moves.map((Function1)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition tp$1;

                        public final String apply(int replicaId) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tp$1.partition()), BoxesRunTime.boxToInteger((int)replicaId)}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> filterBy(String topic, Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed) {
        return new Tuple2(allExisting.filter((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$15) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$15;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    String string2 = this.topic$3;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }), allProposed.filter((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$16) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$16;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    String string2 = this.topic$3;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reassignPartitions(long throttle) {
        this.maybeThrottle(throttle);
        try {
            Map validPartitions = (Map)this.proposedAssignment.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReassignPartitionsCommand $outer;

                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$17) {
                    Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$17;
                    if (tuple2 != null) {
                        TopicAndPartition p = (TopicAndPartition)tuple2._1();
                        boolean bl = this.$outer.validatePartition(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, p.topic(), p.partition());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (validPartitions.isEmpty()) {
                return false;
            }
            String jsonReassignmentData = ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)validPartitions);
            this.kafka$admin$ReassignPartitionsCommand$$zkUtils.createPersistentPath(ZkUtils$.MODULE$.ReassignPartitionsPath(), jsonReassignmentData, this.kafka$admin$ReassignPartitionsCommand$$zkUtils.createPersistentPath$default$3());
            return true;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Admin command failed";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            return false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned = this.kafka$admin$ReassignPartitionsCommand$$zkUtils.getPartitionsBeingReassigned();
            throw new AdminCommandFailedException(new StringBuilder().append((Object)"Partition reassignment currently in ").append((Object)new StringOps(Predef$.MODULE$.augmentString("progress for %s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsBeingReassigned}))).toString());
        }
    }

    public long reassignPartitions$default$1() {
        return -1L;
    }

    public boolean validatePartition(ZkUtils zkUtils, String topic, int partition) {
        Option option;
        block7: {
            boolean bl;
            block6: {
                block5: {
                    boolean bl2;
                    Option partitionsOpt = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
                    option = partitionsOpt;
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    Seq partitions = (Seq)some.x();
                    if (partitions.contains((Object)BoxesRunTime.boxToInteger((int)partition))) {
                        bl2 = true;
                    } else {
                        this.error((Function0<String>)new Serializable(this, topic, partition){
                            public static final long serialVersionUID = 0L;
                            private final String topic$4;
                            private final int partition$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Skipping reassignment of partition [%s,%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1)}))).append((Object)"since it doesn't exist").toString();
                            }
                            {
                                this.topic$4 = topic$4;
                                this.partition$1 = partition$1;
                            }
                        });
                        bl2 = false;
                    }
                    bl = bl2;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                this.error((Function0<String>)new Serializable(this, topic, partition){
                    public static final long serialVersionUID = 0L;
                    private final String topic$4;
                    private final int partition$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Skipping reassignment of partition ").append((Object)new StringOps(Predef$.MODULE$.augmentString("[%s,%d] since topic %s doesn't exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1), this.topic$4}))).toString();
                    }
                    {
                        this.topic$4 = topic$4;
                        this.partition$1 = partition$1;
                    }
                });
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final boolean kafka$admin$ReassignPartitionsCommand$$moving$1(Seq before, Seq after) {
        return ((TraversableOnce)after.toSet().$minus$minus((GenTraversableOnce)before.toSet())).nonEmpty();
    }

    public ReassignPartitionsCommand(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> proposedAssignment, AdminUtilities admin) {
        this.kafka$admin$ReassignPartitionsCommand$$zkUtils = zkUtils;
        this.proposedAssignment = proposedAssignment;
        this.kafka$admin$ReassignPartitionsCommand$$admin = admin;
        Logging$class.$init$(this);
    }

    public static class ReassignPartitionsCommandOptions {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder generateOpt = this.parser().accepts("generate", "Generate a candidate partition reassignment configuration. Note that this only generates a candidate assignment, it does not execute it.");
        private final OptionSpecBuilder executeOpt = this.parser().accepts("execute", "Kick off the reassignment as specified by the --reassignment-json-file option.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify", "Verify if the reassignment completed as specified by the --reassignment-json-file option. If there is a throttle engaged for the replicas specified, and the rebalance has completed, the throttle will be removed");
        private final ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt = this.parser().accepts("reassignment-json-file", "The JSON file with the partition reassignment configurationThe format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3] }],\n\"version\":1\n}").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt = this.parser().accepts("topics-to-move-json-file", "Generate a reassignment configuration to move the partitions of the specified topics to the list of brokers specified by the --broker-list option. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required if --topics-to-move-json-file is used to generate reassignment configuration").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        private final OptionSpecBuilder disableRackAware = this.parser().accepts("disable-rack-aware", "Disable rack aware replica assignment");
        private final ArgumentAcceptingOptionSpec<Object> throttleOpt = this.parser().accepts("throttle", "The movement of partitions will be throttled to this value (bytes/sec). Rerunning with this option, whilst a rebalance is in progress, will alter the throttle value. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("throttle").defaultsTo((Object)"-1", (Object[])new String[0]).ofType(Long.TYPE);
        private final OptionSet options;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder generateOpt() {
            return this.generateOpt;
        }

        public OptionSpecBuilder executeOpt() {
            return this.executeOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt() {
            return this.reassignmentJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt() {
            return this.topicsToMoveJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder disableRackAware() {
            return this.disableRackAware;
        }

        public ArgumentAcceptingOptionSpec<Object> throttleOpt() {
            return this.throttleOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public ReassignPartitionsCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
        }
    }
}

