/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.DefaultMessageFormatter;
import kafka.consumer.KafkaStream;
import kafka.consumer.MessageFormatter;
import kafka.consumer.MessageFormatter$;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.message.MessageAndMetadata;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topic", "The topic id to consume on.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("whitelist", "Whitelist of topics to include for consumption.").withRequiredArg().describedAs("whitelist").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("blacklist", "Blacklist of topics to exclude from consumption.").withRequiredArg().describedAs("blacklist").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"console-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec7 = optionParser.accepts("min-fetch-bytes", "The min number of bytes each fetch request waits for.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec8 = optionParser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec9 = optionParser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec10 = optionParser.accepts("socket-timeout-ms", "The socket timeout used for the connection to the broker").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.SocketTimeout()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec11 = optionParser.accepts("refresh-leader-backoff-ms", "Backoff time before refreshing metadata").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.RefreshMetadataBackoffMs()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec12 = optionParser.accepts("consumer-timeout-ms", "consumer throws timeout exception after waiting this much of time without incoming messages").withRequiredArg().describedAs("prop").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(-1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec13 = optionParser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec14 = optionParser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSpecBuilder optionSpecBuilder = optionParser.accepts("from-beginning", "If the consumer does not already have an established offset to consume from, start with the earliest message present in the log rather than the latest message.");
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec15 = optionParser.accepts("autocommit.interval.ms", "The time interval at which to save the current offset in ms").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.AutoCommitInterval()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec16 = optionParser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        OptionSpecBuilder optionSpecBuilder2 = optionParser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        OptionSpecBuilder optionSpecBuilder3 = optionParser.accepts("csv-reporter-enabled", "If set, the CSV metrics reporter will be enabled");
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec17 = optionParser.accepts("metrics-dir", "If csv-reporter-enable is set, and this parameter isset, the csv metrics will be outputed here").withRequiredArg().describedAs("metrics dictory").ofType(String.class);
        OptionSet optionSet = this.tryParse(optionParser, stringArray);
        CommandLineUtils$.MODULE$.checkRequiredArgs(optionParser, optionSet, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{argumentAcceptingOptionSpec4}));
        List list = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2, argumentAcceptingOptionSpec3})).filter((Function1)new Serializable(optionSet){
            public static final long serialVersionUID = 0L;
            private final OptionSet options$1;

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        });
        if (list.size() != 1) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exactly one of whitelist/blacklist/topic is required.";
                }
            });
            optionParser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String string = (String)optionSet.valueOf((OptionSpec)list.head());
        TopicFilter topicFilter = optionSet.has((OptionSpec)argumentAcceptingOptionSpec3) ? new Blacklist(string) : new Whitelist(string);
        boolean bl = optionSet.has((OptionSpec)optionSpecBuilder3);
        if (bl) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("kafka.metrics.polling.interval.secs", "5");
            ((Hashtable)properties).put("kafka.metrics.reporters", "kafka.metrics.KafkaCSVMetricsReporter");
            Object object = optionSet.has((OptionSpec)argumentAcceptingOptionSpec17) ? ((Hashtable)properties).put("kafka.csv.metrics.dir", optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec17)) : ((Hashtable)properties).put("kafka.csv.metrics.dir", "kafka_metrics");
            ((Hashtable)properties).put("kafka.csv.metrics.reporter.enabled", "true");
            VerifiableProperties verifiableProperties = new VerifiableProperties(properties);
            KafkaMetricsReporter$.MODULE$.startReporters(verifiableProperties);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put("group.id", optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5));
        ((Hashtable)properties).put("socket.receive.buffer.bytes", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec9)).toString());
        ((Hashtable)properties).put("socket.timeout.ms", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec10)).toString());
        ((Hashtable)properties).put("fetch.message.max.bytes", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6)).toString());
        ((Hashtable)properties).put("fetch.min.bytes", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec7)).toString());
        ((Hashtable)properties).put("fetch.wait.max.ms", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec8)).toString());
        ((Hashtable)properties).put("auto.commit.enable", "true");
        ((Hashtable)properties).put("auto.commit.interval.ms", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec15)).toString());
        ((Hashtable)properties).put("auto.offset.reset", optionSet.has((OptionSpec)optionSpecBuilder) ? "smallest" : "largest");
        ((Hashtable)properties).put("zookeeper.connect", optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4));
        ((Hashtable)properties).put("consumer.timeout.ms", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec12)).toString());
        ((Hashtable)properties).put("refresh.leader.backoff.ms", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec11)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(properties);
        boolean bl2 = optionSet.has((OptionSpec)optionSpecBuilder2);
        Class<?> clazz = Class.forName((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec13));
        Properties properties2 = MessageFormatter$.MODULE$.tryParseFormatterArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(optionSet.valuesOf((OptionSpec)argumentAcceptingOptionSpec14)));
        int n = optionSet.has((OptionSpec)argumentAcceptingOptionSpec16) ? (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec16) : -1;
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        if (optionSet.has((OptionSpec)optionSpecBuilder)) {
            ZkUtils$.MODULE$.maybeDeletePath((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4), new StringBuilder().append((Object)"/consumers/").append(optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5)).toString());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(argumentAcceptingOptionSpec4, argumentAcceptingOptionSpec5, optionSet, consumerConnector){
            private final ArgumentAcceptingOptionSpec zkConnectOpt$1;
            private final ArgumentAcceptingOptionSpec groupIdOpt$1;
            private final OptionSet options$1;
            private final ConsumerConnector connector$1;

            public void run() {
                this.connector$1.shutdown();
                if (!this.options$1.has((OptionSpec)this.groupIdOpt$1)) {
                    ZkUtils$.MODULE$.maybeDeletePath((String)this.options$1.valueOf((OptionSpec)this.zkConnectOpt$1), new StringBuilder().append((Object)"/consumers/").append(this.options$1.valueOf((OptionSpec)this.groupIdOpt$1)).toString());
                }
            }
            {
                this.zkConnectOpt$1 = argumentAcceptingOptionSpec;
                this.groupIdOpt$1 = argumentAcceptingOptionSpec2;
                this.options$1 = optionSet;
                this.connector$1 = consumerConnector;
            }
        });
        LongRef longRef = new LongRef(0L);
        MessageFormatter messageFormatter = (MessageFormatter)clazz.newInstance();
        messageFormatter.init(properties2);
        try {
            KafkaStream kafkaStream = (KafkaStream)JavaConversions$.MODULE$.seqAsJavaList(consumerConnector.createMessageStreamsByFilter(topicFilter, 1, new DefaultDecoder(DefaultDecoder$.MODULE$.$lessinit$greater$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.$lessinit$greater$default$1()))).get(0);
            KafkaStream kafkaStream2 = n >= 0 ? (Iterable)kafkaStream.slice(0, n) : kafkaStream;
            kafkaStream2.foreach((Function1)new Serializable(bl2, consumerConnector, longRef, messageFormatter){
                public static final long serialVersionUID = 0L;
                private final boolean skipMessageOnError$1;
                private final ConsumerConnector connector$1;
                private final LongRef numMessages$1;
                private final MessageFormatter formatter$1;

                public final void apply(MessageAndMetadata<byte[], byte[]> messageAndMetadata) {
                    Throwable throwable2;
                    block3: {
                        try {
                            this.formatter$1.writeTo(messageAndMetadata.key(), messageAndMetadata.message(), System.out);
                            ++this.numMessages$1.elem;
                        }
                        catch (Throwable throwable2) {
                            if (!this.skipMessageOnError$1) break block3;
                            ConsoleConsumer$.MODULE$.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error processing message, skipping this message: ";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable2){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$1;

                                public final Throwable apply() {
                                    return this.e$1;
                                }
                                {
                                    this.e$1 = throwable;
                                }
                            });
                        }
                        if (System.out.checkError()) {
                            System.err.println("Unable to write to standard out, closing consumer.");
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("Consumed %d messages")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numMessages$1.elem)})));
                            this.formatter$1.close();
                            this.connector$1.shutdown();
                            System.exit(1);
                        }
                        return;
                    }
                    throw throwable2;
                }
                {
                    this.skipMessageOnError$1 = bl;
                    this.connector$1 = consumerConnector;
                    this.numMessages$1 = longRef;
                    this.formatter$1 = messageFormatter;
                }
            });
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error processing message, stopping consumer: ";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            });
        }
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Consumed %d messages")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)longRef.elem)})));
        System.out.flush();
        messageFormatter.close();
        consumerConnector.shutdown();
    }

    public OptionSet tryParse(OptionParser optionParser, String[] stringArray) {
        OptionSet optionSet;
        try {
            optionSet = optionParser.parse(stringArray);
        }
        catch (OptionException optionException) {
            Utils$.MODULE$.croak(optionException.getMessage());
            optionSet = null;
        }
        return optionSet;
    }

    public void tryCleanupZookeeper(String string, String string2) {
        try {
            String string3 = new StringBuilder().append((Object)"/consumers/").append((Object)string2).toString();
            this.info((Function0<String>)new Serializable(string3){
                public static final long serialVersionUID = 0L;
                private final String dir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleaning up temporary zookeeper data under ").append((Object)this.dir$1).append((Object)".").toString();
                }
                {
                    this.dir$1 = string;
                }
            });
            ZkClient zkClient = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zkClient.deleteRecursive(string3);
            zkClient.close();
        }
        catch (Throwable throwable) {}
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

