/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.common.Topic$;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class StateChangeLogMerger$
implements Logging {
    public static final StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        StateChangeLogMerger$ stateChangeLogMerger$ = this;
        synchronized (stateChangeLogMerger$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> list) {
        this.files = list;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String string) {
        this.topic = string;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> list) {
        this.partitions = list;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date date) {
        this.startDate = date;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date date) {
        this.endDate = date;
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"start timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"0000-00-00 00:00:00,000", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"end timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"9999-12-31 23:59:59,999", (Object[])new String[0]);
        OptionSet optionSet = optionParser.parse(stringArray);
        if (!optionSet.has((OptionSpec)argumentAcceptingOptionSpec) && !optionSet.has((OptionSpec)argumentAcceptingOptionSpec2) || optionSet.has((OptionSpec)argumentAcceptingOptionSpec) && optionSet.has((OptionSpec)argumentAcceptingOptionSpec2)) {
            System.err.println(new StringBuilder().append((Object)"Provide arguments to exactly one of the two options \"").append((Object)argumentAcceptingOptionSpec).append((Object)"\" or \"").append((Object)argumentAcceptingOptionSpec2).append((Object)"\"").toString());
            optionParser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec4) && !optionSet.has((OptionSpec)argumentAcceptingOptionSpec3)) {
            System.err.println(new StringBuilder().append((Object)"The option \"").append((Object)argumentAcceptingOptionSpec3).append((Object)"\" needs to be provided an argument when specifying partition ids").toString());
            optionParser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec)) {
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec)).split(",")).toList()));
        } else if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec2)) {
            String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
            int n = string.lastIndexOf(47) + 1;
            String string2 = n == 0 ? "." : string.substring(0, n - 1);
            Regex regex = new Regex(string.substring(n), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(string2).listFiles()).filter((Function1)new Serializable(regex){
                public static final long serialVersionUID = 0L;
                private final Regex fileNameRegex$1;

                public final boolean apply(File file) {
                    Option option = this.fileNameRegex$1.findFirstIn((CharSequence)file.getName());
                    None$ none$ = None$.MODULE$;
                    return option != null ? !option.equals(none$) : none$ != null;
                }
                {
                    this.fileNameRegex$1 = regex;
                }
            })).map((Function1)new Serializable(string2){
                public static final long serialVersionUID = 0L;
                private final String dirName$1;

                public final String apply(File file) {
                    return new StringBuilder().append((Object)this.dirName$1).append((Object)"/").append((Object)file.getName()).toString();
                }
                {
                    this.dirName$1 = string;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList()));
        }
        if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec3)) {
            this.topic_$eq((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3));
        }
        if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec4)) {
            this.partitions_$eq((List<Object>)((List)Predef$.MODULE$.refArrayOps((Object[])((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4)).split(",")).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String string) {
                    return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
                }
            }, List$.MODULE$.canBuildFrom())));
        }
        this.startDate_$eq(this.dateFormat().parse(((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5)).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6)).replace('\"', ' ').trim()));
        PriorityQueue priorityQueue = new PriorityQueue((Ordering)StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out, 0x100000);
        List list = (List)this.files().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<String> apply(String string) {
                return Source$.MODULE$.fromFile(string, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            }
        }, List$.MODULE$.canBuildFrom());
        ObjectRef objectRef = new ObjectRef((Object)Nil$.MODULE$);
        list.foreach((Function1)new Serializable(objectRef){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lines$1;

            public final void apply(Iterator<String> iterator) {
                StateChangeLogMerger.LineIterator lineIterator = StateChangeLogMerger$.MODULE$.getNextLine(iterator);
                if (!lineIterator.isEmpty()) {
                    this.lines$1.elem = ((List)this.lines$1.elem).$colon$colon((Object)lineIterator);
                }
            }
            {
                this.lines$1 = objectRef;
            }
        });
        if (!((List)objectRef.elem).isEmpty()) {
            priorityQueue.enqueue((Seq)((List)objectRef.elem));
        }
        while (true) {
            if (priorityQueue.isEmpty()) {
                ((OutputStream)bufferedOutputStream).flush();
                return;
            }
            StateChangeLogMerger.LineIterator lineIterator = (StateChangeLogMerger.LineIterator)priorityQueue.dequeue();
            ((OutputStream)bufferedOutputStream).write(new StringBuilder().append((Object)lineIterator.line()).append((Object)"\n").toString().getBytes());
            StateChangeLogMerger.LineIterator lineIterator2 = this.getNextLine(lineIterator.itr());
            if (lineIterator2.isEmpty()) continue;
            priorityQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{lineIterator2}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> iterator) {
        while (iterator != null && iterator.hasNext()) {
            BoxedUnit boxedUnit;
            Option option;
            block5: {
                BoxedUnit boxedUnit2;
                block11: {
                    block6: {
                        block10: {
                            BoxedUnit boxedUnit3;
                            Option option2;
                            block7: {
                                block9: {
                                    Regex.Match match;
                                    String string;
                                    block8: {
                                        string = (String)iterator.next();
                                        option = this.dateRegex().findFirstIn((CharSequence)string);
                                        if (!(option instanceof Some)) break block5;
                                        Some some = (Some)option;
                                        String string2 = (String)some.x();
                                        Date date = this.dateFormat().parse(string2);
                                        if (!date.equals(this.startDate()) && !date.after(this.startDate()) || !date.equals(this.endDate()) && !date.before(this.endDate())) break block6;
                                        option2 = this.topicPartitionRegex().findFirstMatchIn((CharSequence)string);
                                        if (!(option2 instanceof Some)) break block7;
                                        Some some2 = (Some)option2;
                                        match = (Regex.Match)some2.x();
                                        if (this.topic() == null) break block8;
                                        String string3 = this.topic();
                                        String string4 = match.group(1);
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                                    }
                                    if (this.partitions().isEmpty() || this.partitions().contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(match.group(3))).toInt()))) {
                                        return new StateChangeLogMerger.LineIterator(string, iterator);
                                    }
                                }
                                boxedUnit3 = BoxedUnit.UNIT;
                                break block10;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                        break block11;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            None$ none$ = None$.MODULE$;
            Option option4 = option;
            if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError((Object)option);
            boxedUnit = BoxedUnit.UNIT;
        }
        return new StateChangeLogMerger.LineIterator();
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex(new StringBuilder().append((Object)"\\[(").append((Object)Topic$.MODULE$.legalChars()).append((Object)"+),( )*([0-9]+)\\]").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.topic = null;
        this.partitions = Nil$.MODULE$;
        this.startDate = null;
        this.endDate = null;
    }
}

