/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.producer.ProducerRequestStats;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u00039\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ta1+\u001f8d!J|G-^2feN\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\f\n\u0005\u0004%\taF\u0001\u000b%\u0016\fX/Z:u\u0017\u0016LX#\u0001\r\u0011\u00055I\u0012B\u0001\u000e\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019a\u0012\u0002)A\u00051\u0005Y!+Z9vKN$8*Z=!\u0011\u001dq\u0012B1A\u0005\u0002}\tqB]1oI>lw)\u001a8fe\u0006$xN]\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#A\u0002*b]\u0012|W\u000e\u0003\u0004*\u0013\u0001\u0006I\u0001I\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u00022AA\u0003\u0002\u0001WM\u0019!\u0006\u0004\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011!B;uS2\u001c\u0018BA\u0019/\u0005\u001daunZ4j]\u001eD\u0001b\r\u0016\u0003\u0006\u0004%\t\u0001N\u0001\u0007G>tg-[4\u0016\u0003U\u0002\"\u0001\u0003\u001c\n\u0005]\u0012!AE*z]\u000e\u0004&o\u001c3vG\u0016\u00148i\u001c8gS\u001eD\u0001\"\u000f\u0016\u0003\u0002\u0003\u0006I!N\u0001\bG>tg-[4!\u0011\u0015\u0019\"\u0006\"\u0001<)\taT\b\u0005\u0002\tU!)1G\u000fa\u0001k!9qH\u000bb\u0001\n\u0013\u0001\u0015\u0001\u00027pG.,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\nA\u0001\\1oO&\u0011ai\u0011\u0002\u0007\u001f\nTWm\u0019;\t\r!S\u0003\u0015!\u0003B\u0003\u0015awnY6!\u0011\u001dQ%\u00061A\u0005\n-\u000b\u0001b\u001d5vi\u0012|wO\\\u000b\u0002\u0019B\u0011Q\"T\u0005\u0003\u001d:\u0011qAQ8pY\u0016\fg\u000eC\u0004QU\u0001\u0007I\u0011B)\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005I+\u0006CA\u0007T\u0013\t!fB\u0001\u0003V]&$\bb\u0002,P\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0004B\u0002-+A\u0003&A*A\u0005tQV$Hm\\<oA!\u0012qK\u0017\t\u0003\u001bmK!\u0001\u0018\b\u0003\u0011Y|G.\u0019;jY\u0016DqA\u0018\u0016C\u0002\u0013%q,A\bcY>\u001c7.\u001b8h\u0007\"\fgN\\3m+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u0005\u0003\u001dqW\r^<pe.L!!\u001a2\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2Daa\u001a\u0016!\u0002\u0013\u0001\u0017\u0001\u00052m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7!\u0011\u001dI'F1A\u0005\u0002)\f!B\u0019:pW\u0016\u0014\u0018J\u001c4p+\u0005Y\u0007C\u00017p\u001d\tiQ.\u0003\u0002o\u001d\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tqg\u0002\u0003\u0004tU\u0001\u0006Ia[\u0001\fEJ|7.\u001a:J]\u001a|\u0007\u0005C\u0004vU\t\u0007I\u0011\u0001<\u0002)A\u0014x\u000eZ;dKJ\u0014V-];fgR\u001cF/\u0019;t+\u00059\bC\u0001\u0005y\u0013\tI(A\u0001\u000bQe>$WoY3s%\u0016\fX/Z:u'R\fGo\u001d\u0005\u0007w*\u0002\u000b\u0011B<\u0002+A\u0014x\u000eZ;dKJ\u0014V-];fgR\u001cF/\u0019;tA!)QP\u000bC\u0005}\u0006ia/\u001a:jMf\u0014V-];fgR$\"AU@\t\u000f\u0005\u0005A\u00101\u0001\u0002\u0004\u00059!/Z9vKN$\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%A!A\u0002ba&LA!!\u0004\u0002\b\t\t\"+Z9vKN$xJ\u001d*fgB|gn]3\t\u000f\u0005E!\u0006\"\u0003\u0002\u0014\u00051Am\\*f]\u0012$b!!\u0006\u0002\u001c\u0005u\u0001cA1\u0002\u0018%\u0019\u0011\u0011\u00042\u0003\u000fI+7-Z5wK\"A\u0011\u0011AA\b\u0001\u0004\t\u0019\u0001C\u0005\u0002 \u0005=\u0001\u0013!a\u0001\u0019\u0006a!/Z1e%\u0016\u001c\bo\u001c8tK\"9\u00111\u0005\u0016\u0005\u0002\u0005\u0015\u0012\u0001B:f]\u0012$B!a\n\u0002.A!\u0011QAA\u0015\u0013\u0011\tY#a\u0002\u0003!A\u0013x\u000eZ;dKJ\u0014Vm\u001d9p]N,\u0007\u0002CA\u0018\u0003C\u0001\r!!\r\u0002\u001fA\u0014x\u000eZ;dKJ\u0014V-];fgR\u0004B!!\u0002\u00024%!\u0011QGA\u0004\u0005=\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$\bbBA\u0012U\u0011\u0005\u0011\u0011\b\u000b\u0005\u0003w\t\t\u0005\u0005\u0003\u0002\u0006\u0005u\u0012\u0002BA \u0003\u000f\u0011Q\u0003V8qS\u000elU\r^1eCR\f'+Z:q_:\u001cX\r\u0003\u0005\u0002\u0002\u0005]\u0002\u0019AA\"!\u0011\t)!!\u0012\n\t\u0005\u001d\u0013q\u0001\u0002\u0015)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f\u0005-#\u0006\"\u0001\u0002N\u0005)1\r\\8tKR\t!\u000bC\u0004\u0002R)\"I!!\u0014\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000fC\u0004\u0002V)\"I!a\u0016\u0002\u000f\r|gN\\3diR\t\u0001\rC\u0004\u0002\\)\"I!!\u0014\u0002'\u001d,Go\u0014:NC.,7i\u001c8oK\u000e$\u0018n\u001c8\t\u0013\u0005}#&%A\u0005\n\u0005\u0005\u0014\u0001\u00053p'\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019GK\u0002M\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003cr\u0011AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004U\u0005e\u0004cA\u0017\u0002|%\u0019\u0011Q\u0010\u0018\u0003\u0015QD'/Z1eg\u00064W\r")
public class SyncProducer
implements Logging {
    private final SyncProducerConfig config;
    private final Object lock;
    private volatile boolean shutdown;
    private final BlockingChannel blockingChannel;
    private final String brokerInfo;
    private final ProducerRequestStats producerRequestStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SyncProducer syncProducer = this;
        synchronized (syncProducer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean x$1) {
        this.shutdown = x$1;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public String brokerInfo() {
        return this.brokerInfo;
    }

    public ProducerRequestStats producerRequestStats() {
        return this.producerRequestStats;
    }

    private void verifyRequest(RequestOrResponse request) {
        if (this.logger().isDebugEnabled()) {
            ByteBuffer buffer = new BoundedByteBufferSend(request).buffer();
            this.trace((Function0<String>)new Serializable(this, buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"verifying sendbuffer of size ").append((Object)BoxesRunTime.boxToInteger((int)this.buffer$1.limit())).toString();
                }
                {
                    this.buffer$1 = buffer$1;
                }
            });
            short requestTypeId = buffer.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.ProduceKey()) {
                ProducerRequest request2 = ProducerRequest$.MODULE$.readFrom(buffer);
                this.trace((Function0<String>)new Serializable(this, request2){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRequest request$1;

                    public final String apply() {
                        return this.request$1.toString();
                    }
                    {
                        this.request$1 = request$1;
                    }
                });
            }
        }
    }

    public Receive kafka$producer$SyncProducer$$doSend(RequestOrResponse request, boolean readResponse) {
        Object object = this.lock();
        synchronized (object) {
            this.verifyRequest(request);
            this.getOrMakeConnection();
            ObjectRef response = new ObjectRef(null);
            this.liftedTree1$1(request, readResponse, response);
            Receive receive = (Receive)response.elem;
            return receive;
        }
    }

    private boolean doSend$default$2() {
        return true;
    }

    public ProducerResponse send(ProducerRequest producerRequest) {
        int requestSize = producerRequest.sizeInBytes();
        this.producerRequestStats().getProducerRequestStats(this.brokerInfo()).requestSizeHist().update(requestSize);
        this.producerRequestStats().getProducerRequestAllBrokersStats().requestSizeHist().update(requestSize);
        ObjectRef response = new ObjectRef(null);
        KafkaTimer specificTimer = this.producerRequestStats().getProducerRequestStats(this.brokerInfo()).requestTimer();
        KafkaTimer aggregateTimer = this.producerRequestStats().getProducerRequestAllBrokersStats().requestTimer();
        aggregateTimer.time(new Serializable(this, producerRequest, response, specificTimer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyncProducer $outer;
            public final ProducerRequest producerRequest$1;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$send$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$producer$SyncProducer$$anonfun$$$outer().kafka$producer$SyncProducer$$doSend(this.$outer.producerRequest$1, this.$outer.producerRequest$1.requiredAcks() != 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SyncProducer kafka$producer$SyncProducer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producerRequest$1 = producerRequest$1;
                this.response$2 = response$2;
                this.specificTimer$1 = specificTimer$1;
            }
        });
        return producerRequest.requiredAcks() != 0 ? ProducerResponse$.MODULE$.readFrom(((Receive)response.elem).buffer()) : null;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        Receive response = this.kafka$producer$SyncProducer$$doSend(request, this.doSend$default$2());
        return TopicMetadataResponse$.MODULE$.readFrom(response.buffer());
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Disconnecting from ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.blockingChannel().disconnect();
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error on disconnect: ";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockingChannel connect() {
        if (this.blockingChannel().isConnected() || this.shutdown()) return this.blockingChannel();
        try {
            this.blockingChannel().connect();
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Connected to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" for producing").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Exception exception) {
            this.disconnect();
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Producer connection to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" unsuccessful").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$2;

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw exception;
        }
        return this.blockingChannel();
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    private final void liftedTree1$1(RequestOrResponse request$2, boolean readResponse$1, ObjectRef response$1) {
        try {
            this.blockingChannel().send(request$2);
            if (readResponse$1) {
                response$1.elem = this.blockingChannel().receive();
            } else {
                this.trace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Skipping reading response";
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.shutdown = false;
        this.blockingChannel = new BlockingChannel(config.host(), config.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), config.sendBufferBytes(), config.requestTimeoutMs());
        this.brokerInfo = new StringOps(Predef$.MODULE$.augmentString("host_%s-port_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.host(), BoxesRunTime.boxToInteger((int)config.port())}));
        this.producerRequestStats = ProducerRequestStatsRegistry$.MODULE$.getProducerRequestStats(config.clientId());
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Instantiating Scala Sync Producer";
            }
        });
    }
}

