/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.api.RequestOrResponse;
import kafka.common.TopicAndPartition;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import kafka.server.DelayedProduce;
import kafka.server.DelayedProduceResponseStatus;
import kafka.server.DelayedRequestKey;
import kafka.server.OffsetManager;
import kafka.server.ProducerRequestPurgatory$;
import kafka.server.ProducerRequestPurgatory$DelayedProducerRequestMetrics$;
import kafka.server.ReplicaManager;
import kafka.server.RequestPurgatory;
import kafka.server.TopicPartitionRequestKey;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:z\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\rI!\u0002D\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011%\u0016\fX/Z:u!V\u0014x-\u0019;pef\u0004\"!C\u0007\n\u00059\u0011!A\u0004#fY\u0006LX\r\u001a)s_\u0012,8-\u001a\u0005\t!\u0001\u0011\t\u0011)A\u0005#\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\u0005\u0013\u0013\t\u0019\"A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0011U\u0001!\u0011!Q\u0001\nY\tQb\u001c4gg\u0016$X*\u00198bO\u0016\u0014\bCA\u0005\u0018\u0013\tA\"AA\u0007PM\u001a\u001cX\r^'b]\u0006<WM\u001d\u0005\t5\u0001\u0011\t\u0011)A\u00057\u0005q!/Z9vKN$8\t[1o]\u0016d\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0005\u0003\u001dqW\r^<pe.L!\u0001I\u000f\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"B\u0001J\u0013'OA\u0011\u0011\u0002\u0001\u0005\u0006!\u0005\u0002\r!\u0005\u0005\u0006+\u0005\u0002\rA\u0006\u0005\u00065\u0005\u0002\ra\u0007\u0004\u0005S\u0001!!FA\u000fEK2\f\u00170\u001a3Qe>$WoY3s%\u0016\fX/Z:u\u001b\u0016$(/[2t'\rA3&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I*T\"A\u001a\u000b\u0005Q\"\u0011aB7fiJL7m]\u0005\u0003mM\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!A\u0004F!A!\u0002\u0013I\u0014\u0001C6fs2\u000b'-\u001a7\u0011\u0005ijdB\u0001\u0017<\u0013\taT&\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f.\u0011\u0015\u0011\u0003\u0006\"\u0001B)\t\u0011E\t\u0005\u0002DQ5\t\u0001\u0001C\u00049\u0001B\u0005\t\u0019A\u001d\t\u000f\u0019C#\u0019!C\u0001\u000f\u0006\u0019R\r\u001f9je\u0016$'+Z9vKN$X*\u001a;feV\t\u0001\n\u0005\u0002J#6\t!J\u0003\u0002L\u0019\u0006!1m\u001c:f\u0015\t!TJ\u0003\u0002O\u001f\u00061\u00110Y7nKJT\u0011\u0001U\u0001\u0004G>l\u0017B\u0001*K\u0005\u0015iU\r^3s\u0011\u0019!\u0006\u0006)A\u0005\u0011\u0006!R\r\u001f9je\u0016$'+Z9vKN$X*\u001a;fe\u0002:qA\u0016\u0001\u0002\u0002#%q+A\u000fEK2\f\u00170\u001a3Qe>$WoY3s%\u0016\fX/Z:u\u001b\u0016$(/[2t!\t\u0019\u0005LB\u0004*\u0001\u0005\u0005\t\u0012B-\u0014\u0005a[\u0003\"\u0002\u0012Y\t\u0003YF#A,\t\u000fuC\u0016\u0013!C\u0001=\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012a\u0018\u0016\u0003s\u0001\\\u0013!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0019l\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001n\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u00026\u0001\u0005\u0004%Ia[\u0001\u001daJ|G-^2feJ+\u0017/^3ti6+GO]5dg\u001a{'oS3z+\u0005a\u0007\u0003B7qe\nk\u0011A\u001c\u0006\u0003_\u0012\tQ!\u001e;jYNL!!\u001d8\u0003\tA{w\u000e\u001c\t\u0003\u0013ML!\u0001\u001e\u0002\u0003#\u0011+G.Y=fIJ+\u0017/^3ti.+\u0017\u0010\u0003\u0004w\u0001\u0001\u0006I\u0001\\\u0001\u001eaJ|G-^2feJ+\u0017/^3ti6+GO]5dg\u001a{'oS3zA!9\u0001\u0010\u0001b\u0001\n\u0013I\u0018AH1hOJ,w-\u0019;f!J|G-^2f%\u0016\fX/Z:u\u001b\u0016$(/[2t+\u0005\u0011\u0005BB>\u0001A\u0003%!)A\u0010bO\u001e\u0014XmZ1uKB\u0013x\u000eZ;dKJ+\u0017/^3ti6+GO]5dg\u0002BQ! \u0001\u0005\ny\fqD]3d_J$G)\u001a7bs\u0016$\u0007K]8ek\u000e,'oS3z\u000bb\u0004\u0018N]3e)\ry\u0018Q\u0001\t\u0004Y\u0005\u0005\u0011bAA\u0002[\t!QK\\5u\u0011\u0019\t9\u0001 a\u0001e\u0006\u00191.Z=\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005q1\r[3dWN\u000bG/[:gS\u0016$G\u0003BA\b\u0003+\u00012\u0001LA\t\u0013\r\t\u0019\"\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\"!\u0003A\u00021\ta\u0002Z3mCf,G\r\u0015:pIV\u001cW\rC\u0004\u0002\u001c\u0001!\t!!\b\u0002\r\u0015D\b/\u001b:f)\ry\u0018q\u0004\u0005\b\u0003/\tI\u00021\u0001\r\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tqA]3ta>tG\rF\u0002\u0000\u0003OAq!a\u0006\u0002\"\u0001\u0007A\u0002")
public class ProducerRequestPurgatory
extends RequestPurgatory<DelayedProduce> {
    private final ReplicaManager replicaManager;
    private final OffsetManager offsetManager;
    private final RequestChannel requestChannel;
    private final Pool<DelayedRequestKey, DelayedProducerRequestMetrics> producerRequestMetricsForKey;
    private final DelayedProducerRequestMetrics aggregateProduceRequestMetrics;
    private volatile ProducerRequestPurgatory$DelayedProducerRequestMetrics$ DelayedProducerRequestMetrics$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProducerRequestPurgatory$DelayedProducerRequestMetrics$ DelayedProducerRequestMetrics$lzycompute() {
        ProducerRequestPurgatory producerRequestPurgatory = this;
        synchronized (producerRequestPurgatory) {
            if (this.DelayedProducerRequestMetrics$module != null) return this.DelayedProducerRequestMetrics$module;
            this.DelayedProducerRequestMetrics$module = new ProducerRequestPurgatory$DelayedProducerRequestMetrics$(this);
            return this.DelayedProducerRequestMetrics$module;
        }
    }

    private ProducerRequestPurgatory$DelayedProducerRequestMetrics$ DelayedProducerRequestMetrics() {
        return this.DelayedProducerRequestMetrics$module == null ? this.DelayedProducerRequestMetrics$lzycompute() : this.DelayedProducerRequestMetrics$module;
    }

    private Pool<DelayedRequestKey, DelayedProducerRequestMetrics> producerRequestMetricsForKey() {
        return this.producerRequestMetricsForKey;
    }

    private DelayedProducerRequestMetrics aggregateProduceRequestMetrics() {
        return this.aggregateProduceRequestMetrics;
    }

    public void kafka$server$ProducerRequestPurgatory$$recordDelayedProducerKeyExpired(DelayedRequestKey key) {
        DelayedProducerRequestMetrics keyMetrics = this.producerRequestMetricsForKey().getAndMaybePut(key);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelayedProducerRequestMetrics[]{keyMetrics, this.aggregateProduceRequestMetrics()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedProducerRequestMetrics x$1) {
                x$1.expiredRequestMeter().mark();
            }
        });
    }

    @Override
    public boolean checkSatisfied(DelayedProduce delayedProduce) {
        return delayedProduce.isSatisfied(this.replicaManager);
    }

    @Override
    public void expire(DelayedProduce delayedProduce) {
        this.debug((Function0<String>)new Serializable(this, delayedProduce){
            public static final long serialVersionUID = 0L;
            private final DelayedProduce delayedProduce$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Expiring produce request %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.delayedProduce$1.produce()}));
            }
            {
                this.delayedProduce$1 = delayedProduce$1;
            }
        });
        delayedProduce.partitionStatus().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, DelayedProduceResponseStatus> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, DelayedProduceResponseStatus> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, DelayedProduceResponseStatus> x$2) {
                Tuple2<TopicAndPartition, DelayedProduceResponseStatus> tuple2 = x$2;
                if (tuple2 != null) {
                    DelayedProduceResponseStatus responseStatus = (DelayedProduceResponseStatus)tuple2._2();
                    boolean bl = responseStatus.acksPending();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerRequestPurgatory $outer;

            public final void apply(Tuple2<TopicAndPartition, DelayedProduceResponseStatus> x$3) {
                Tuple2<TopicAndPartition, DelayedProduceResponseStatus> tuple2 = x$3;
                if (tuple2 != null) {
                    TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                    this.$outer.kafka$server$ProducerRequestPurgatory$$recordDelayedProducerKeyExpired(new TopicPartitionRequestKey(topicPartition));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.respond(delayedProduce);
    }

    public void respond(DelayedProduce delayedProduce) {
        RequestOrResponse response = delayedProduce.respond(this.offsetManager);
        this.requestChannel.sendResponse(new RequestChannel.Response(delayedProduce.request(), new BoundedByteBufferSend(response)));
    }

    public ProducerRequestPurgatory(ReplicaManager replicaManager, OffsetManager offsetManager, RequestChannel requestChannel) {
        this.replicaManager = replicaManager;
        this.offsetManager = offsetManager;
        this.requestChannel = requestChannel;
        super(replicaManager.config().brokerId(), replicaManager.config().producerPurgatoryPurgeIntervalRequests());
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[ProducerRequestPurgatory-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaManager.config().brokerId())})));
        $anonfun$1 valueFactory = new $anonfun$1(this);
        this.producerRequestMetricsForKey = new Pool(new Some((Object)valueFactory));
        this.aggregateProduceRequestMetrics = new DelayedProducerRequestMetrics(this.DelayedProducerRequestMetrics().$lessinit$greater$default$1());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DelayedProducerRequestMetrics
    implements KafkaMetricsGroup {
        private final Meter expiredRequestMeter;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
            return KafkaMetricsGroup$class.newGauge(this, name, metric);
        }

        @Override
        public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
            return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
        }

        @Override
        public Histogram newHistogram(String name, boolean biased) {
            return KafkaMetricsGroup$class.newHistogram(this, name, biased);
        }

        @Override
        public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
            return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
        }

        @Override
        public void removeMetric(String name) {
            KafkaMetricsGroup$class.removeMetric(this, name);
        }

        @Override
        public boolean newHistogram$default$2() {
            return KafkaMetricsGroup$class.newHistogram$default$2(this);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DelayedProducerRequestMetrics delayedProducerRequestMetrics = this;
            synchronized (delayedProducerRequestMetrics) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public Meter expiredRequestMeter() {
            return this.expiredRequestMeter;
        }

        public /* synthetic */ ProducerRequestPurgatory kafka$server$ProducerRequestPurgatory$DelayedProducerRequestMetrics$$$outer() {
            return ProducerRequestPurgatory.this;
        }

        public DelayedProducerRequestMetrics(String keyLabel) {
            if (ProducerRequestPurgatory.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            KafkaMetricsGroup$class.$init$(this);
            this.expiredRequestMeter = this.newMeter(new StringBuilder().append((Object)keyLabel).append((Object)"ExpiresPerSecond").toString(), "requests", TimeUnit.SECONDS);
        }
    }
}

