/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Hashtable;
import java.util.Properties;
import kafka.producer.BaseProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.tools.ConsoleProducer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(config.readerClass()).newInstance();
        Properties props = new Properties();
        ((Hashtable)props).put("topic", config.topic());
        ((Hashtable)props).putAll(config.cmdLineProps());
        reader.init(System.in, props);
        try {
            BaseProducer baseProducer;
            if (config.useNewProducer()) {
                ((Hashtable)props).put("bootstrap.servers", config.brokerList());
                ((Hashtable)props).put("compression.type", config.compressionCodec());
                ((Hashtable)props).put("send.buffer.bytes", config.socketBuffer().toString());
                ((Hashtable)props).put("retry.backoff.ms", config.retryBackoffMs().toString());
                ((Hashtable)props).put("metadata.max.age.ms", config.metadataExpiryMs().toString());
                ((Hashtable)props).put("metadata.fetch.timeout.ms", config.metadataFetchTimeoutMs().toString());
                ((Hashtable)props).put("acks", config.requestRequiredAcks().toString());
                ((Hashtable)props).put("timeout.ms", config.requestTimeoutMs().toString());
                ((Hashtable)props).put("retries", config.messageSendMaxRetries().toString());
                ((Hashtable)props).put("linger.ms", config.sendTimeout().toString());
                Object object = BoxesRunTime.equalsNumObject((Number)config.queueEnqueueTimeoutMs(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? BoxedUnit.UNIT : ((Hashtable)props).put("block.on.buffer.full", "false");
                ((Hashtable)props).put("buffer.memory", config.maxMemoryBytes().toString());
                ((Hashtable)props).put("batch.size", config.maxPartitionMemoryBytes().toString());
                ((Hashtable)props).put("client.id", "console-producer");
                baseProducer = new NewShinyProducer(props);
            } else {
                ((Hashtable)props).put("metadata.broker.list", config.brokerList());
                ((Hashtable)props).put("compression.codec", config.compressionCodec());
                ((Hashtable)props).put("producer.type", config.sync() ? "sync" : "async");
                ((Hashtable)props).put("batch.num.messages", config.batchSize().toString());
                ((Hashtable)props).put("message.send.max.retries", config.messageSendMaxRetries().toString());
                ((Hashtable)props).put("retry.backoff.ms", config.retryBackoffMs().toString());
                ((Hashtable)props).put("queue.buffering.max.ms", config.sendTimeout().toString());
                ((Hashtable)props).put("queue.buffering.max.messages", config.queueSize().toString());
                ((Hashtable)props).put("queue.enqueue.timeout.ms", config.queueEnqueueTimeoutMs().toString());
                ((Hashtable)props).put("request.required.acks", config.requestRequiredAcks().toString());
                ((Hashtable)props).put("request.timeout.ms", config.requestTimeoutMs().toString());
                ((Hashtable)props).put("key.serializer.class", config.keyEncoderClass());
                ((Hashtable)props).put("serializer.class", config.valueEncoderClass());
                ((Hashtable)props).put("send.buffer.bytes", config.socketBuffer().toString());
                ((Hashtable)props).put("topic.metadata.refresh.interval.ms", config.metadataExpiryMs().toString());
                ((Hashtable)props).put("client.id", "console-producer");
                baseProducer = new OldProducer(props);
            }
            NewShinyProducer producer = baseProducer;
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final BaseProducer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            KeyedMessage<byte[], byte[]> message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer.send(message.topic(), message.key(), message.message());
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

