/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003U1si&$\u0018n\u001c8U_BL7-\u00138g_*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001BC\u0002\u0013\u0005a#A\u0003u_BL7-F\u0001\u0018!\tA2D\u0004\u0002\n3%\u0011!DC\u0001\u0007!J,G-\u001a4\n\u0005qi\"AB*ue&twM\u0003\u0002\u001b\u0015!Aq\u0004\u0001B\u0001B\u0003%q#\u0001\u0004u_BL7\r\t\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005Y\u0001/\u0019:uSRLwN\\%e+\u0005\u0019\u0003CA\u0005%\u0013\t)#BA\u0002J]RD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\tS\u0001\u0011)\u0019!C\u0005U\u0005Q1\r[;oWF+X-^3\u0016\u0003-\u00022\u0001L\u001a6\u001b\u0005i#B\u0001\u00180\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003aE\nA!\u001e;jY*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b.\u00055\u0011En\\2lS:<\u0017+^3vKB\u0011agN\u0007\u0002\u0005%\u0011\u0001H\u0001\u0002\u0011\r\u0016$8\r[3e\t\u0006$\u0018m\u00115v].D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaK\u0001\fG\",hn[)vKV,\u0007\u0005\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0003>\u00039\u0019wN\\:v[\u0016$wJ\u001a4tKR,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u00036\na!\u0019;p[&\u001c\u0017BA\"A\u0005)\tEo\\7jG2{gn\u001a\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005}\u0005y1m\u001c8tk6,Gm\u00144gg\u0016$\b\u0005\u0003\u0005H\u0001\t\u0015\r\u0011\"\u0003>\u000351W\r^2iK\u0012|eMZ:fi\"A\u0011\n\u0001B\u0001B\u0003%a(\u0001\bgKR\u001c\u0007.\u001a3PM\u001a\u001cX\r\u001e\u0011\t\u0011-\u0003!Q1A\u0005\n1\u000b\u0011BZ3uG\"\u001c\u0016N_3\u0016\u00035\u0003\"a\u0010(\n\u0005=\u0003%!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003N\u0003)1W\r^2i'&TX\r\t\u0005\t'\u0002\u0011)\u0019!C\u0005-\u0005A1\r\\5f]RLE\r\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0019G.[3oi&#\u0007\u0005C\u0003X\u0001\u0011\u0005\u0001,\u0001\u0004=S:LGO\u0010\u000b\t3j[F,\u00180`AB\u0011a\u0007\u0001\u0005\u0006+Y\u0003\ra\u0006\u0005\u0006CY\u0003\ra\t\u0005\u0006SY\u0003\ra\u000b\u0005\u0006yY\u0003\rA\u0010\u0005\u0006\u000fZ\u0003\rA\u0010\u0005\u0006\u0017Z\u0003\r!\u0014\u0005\u0006'Z\u0003\ra\u0006\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003I\u0019wN\\:v[\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003\u0011\u0004\"AN3\n\u0005\u0019\u0014!AE\"p]N,X.\u001a:U_BL7m\u0015;biNDa\u0001\u001b\u0001!\u0002\u0013!\u0017aE2p]N,X.\u001a:U_BL7m\u0015;biN\u0004\u0003\"\u00026\u0001\t\u0003Y\u0017\u0001E4fi\u000e{gn];nK>3gm]3u)\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007\"\u00029\u0001\t\u0003Y\u0017AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u0005\u0006e\u0002!\ta]\u0001\u0013e\u0016\u001cX\r^\"p]N,X.Z(gMN,G\u000f\u0006\u0002uoB\u0011\u0011\"^\u0005\u0003m*\u0011A!\u00168ji\")\u00010\u001da\u0001Y\u0006\u0001b.Z<D_:\u001cX/\\3PM\u001a\u001cX\r\u001e\u0005\u0006u\u0002!\ta_\u0001\u0011e\u0016\u001cX\r\u001e$fi\u000eDwJ\u001a4tKR$\"\u0001\u001e?\t\u000buL\b\u0019\u00017\u0002\u001d9,wOR3uG\"|eMZ:fi\"1q\u0010\u0001C\u0001\u0003\u0003\tq!\u001a8rk\u0016,X\rF\u0002u\u0003\u0007Aq!!\u0002\u007f\u0001\u0004\t9!\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\t\u00059Q.Z:tC\u001e,\u0017\u0002BA\t\u0003\u0017\u0011ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bbBA\u000b\u0001\u0011\u0005\u0013qC\u0001\ti>\u001cFO]5oOR\tqcB\u0004\u0002\u001c\tA\t!!\b\u0002%A\u000b'\u000f^5uS>tGk\u001c9jG&sgm\u001c\t\u0004m\u0005}aAB\u0001\u0003\u0011\u0003\t\tcE\u0002\u0002 !AqaVA\u0010\t\u0003\t)\u0003\u0006\u0002\u0002\u001e!Q\u0011\u0011FA\u0010\u0005\u0004%\t!a\u000b\u0002\u001b%sg/\u00197jI>3gm]3u+\u0005a\u0007\u0002CA\u0018\u0003?\u0001\u000b\u0011\u00027\u0002\u001d%sg/\u00197jI>3gm]3uA!A\u00111GA\u0010\t\u0003\t)$A\bjg>3gm]3u\u0013:4\u0018\r\\5e)\u0011\t9$!\u0010\u0011\u0007%\tI$C\u0002\u0002<)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002@\u0005E\u0002\u0019\u00017\u0002\r=4gm]3u\u0001")
public class PartitionTopicInfo
implements Logging {
    private final String topic;
    private final int partitionId;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    private final AtomicInteger fetchSize;
    private final String clientId;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean isOffsetInvalid(long l) {
        return PartitionTopicInfo$.MODULE$.isOffsetInvalid(l);
    }

    public static long InvalidOffset() {
        return PartitionTopicInfo$.MODULE$.InvalidOffset();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionTopicInfo partitionTopicInfo = this;
        synchronized (partitionTopicInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    public AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset;
    }

    public AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    private String clientId() {
        return this.clientId;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    public long getConsumeOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset) {
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset().set(newConsumeOffset);
        this.debug((Function0<String>)new Serializable(this, newConsumeOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTopicInfo $outer;
            private final long newConsumeOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)"reset consume offset of ").append((Object)this.$outer).append((Object)" to ").append((Object)BoxesRunTime.boxToLong((long)this.newConsumeOffset$1)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newConsumeOffset$1 = newConsumeOffset$1;
            }
        });
    }

    public void resetFetchOffset(long newFetchOffset) {
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(newFetchOffset);
        this.debug((Function0<String>)new Serializable(this, newFetchOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTopicInfo $outer;
            private final long newFetchOffset$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("reset fetch offset of ( %s ) to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, BoxesRunTime.boxToLong((long)this.newFetchOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newFetchOffset$1 = newFetchOffset$1;
            }
        });
    }

    public void enqueue(ByteBufferMessageSet messages) {
        int size2 = messages.validBytes();
        if (size2 > 0) {
            long next2 = ((MessageAndOffset)messages.shallowIterator().toSeq().last()).nextOffset();
            this.trace((Function0<String>)new Serializable(this, next2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionTopicInfo $outer;
                private final long next$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Updating fetch offset = ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)" to ").append((Object)BoxesRunTime.boxToLong((long)this.next$1)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.next$1 = next$1;
                }
            });
            this.chunkQueue().put(new FetchedDataChunk(messages, this, this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get()));
            this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(next2);
            this.debug((Function0<String>)new Serializable(this, next2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionTopicInfo $outer;
                private final long next$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("updated fetch offset of (%s) to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, BoxesRunTime.boxToLong((long)this.next$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.next$1 = next$1;
                }
            });
            this.consumerTopicStats().getConsumerTopicStats(this.topic()).byteRate().mark((long)size2);
            this.consumerTopicStats().getConsumerAllTopicStats().byteRate().mark((long)size2);
        } else if (messages.sizeInBytes() > 0) {
            this.chunkQueue().put(new FetchedDataChunk(messages, this, this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get()));
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)this.topic()).append((Object)":").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString()).append((Object)": fetched offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)": consumed offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
    }

    public PartitionTopicInfo(String topic, int partitionId, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize, String clientId) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.chunkQueue = chunkQueue;
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset = consumedOffset;
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTopicInfo $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"initial consumer offset of ").append((Object)this.$outer).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTopicInfo $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"initial fetch offset of ").append((Object)this.$outer).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

