/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements Serializable {
    public static final BrokerEndPoint$ MODULE$;
    private final Regex uriParseExp;

    static {
        new BrokerEndPoint$();
    }

    private Regex uriParseExp() {
        return this.uriParseExp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        Some some;
        String string = connectionString;
        Option option = this.uriParseExp().unapplySeq((CharSequence)string);
        if (option.isEmpty()) return None$.MODULE$;
        if (option.get() == null) return None$.MODULE$;
        if (((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) return None$.MODULE$;
        String host = (String)((LinearSeqOptimized)option.get()).apply(0);
        String port = (String)((LinearSeqOptimized)option.get()).apply(1);
        try {
            some = new Some((Object)new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            return some;
        }
        catch (NumberFormatException numberFormatException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)this.parseHostPort(connectionString).map((Function1)new Serializable(brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final BrokerEndPoint apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    BrokerEndPoint brokerEndPoint = new BrokerEndPoint(this.brokerId$1, host, port);
                    return brokerEndPoint;
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        }).getOrElse((Function0)new Serializable(connectionString){
            public static final long serialVersionUID = 0L;
            private final String connectionString$1;

            public final Nothing$ apply() {
                throw new KafkaException(new StringBuilder().append((Object)"Unable to parse ").append((Object)this.connectionString$1).append((Object)" to a broker endpoint").toString());
            }
            {
                this.connectionString$1 = connectionString$1;
            }
        });
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
        this.uriParseExp = new StringOps(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%.:]*)\\]?:([0-9]+)")).r();
    }
}

