/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.OffsetPosition;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.CoreUtils$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000f5,7o]1hK&\u0011QB\u0003\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u00111A\u0005\u0002Y\tAAZ5mKV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005\u0011\u0011n\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0003GS2,\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0007I\u0011A\u0011\u0002\u0011\u0019LG.Z0%KF$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bS}\t\t\u00111\u0001\u0018\u0003\rAH%\r\u0005\tW\u0001\u0011\t\u0011)Q\u0005/\u0005)a-\u001b7fA!\u0012!&\f\t\u0003G9J!a\f\u0013\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"\r\u0001\u0003\u0006\u0004%\tA\u0001\u001a\u0002\u000f\rD\u0017M\u001c8fYV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005A1\r[1o]\u0016d7O\u0003\u000297\u0005\u0019a.[8\n\u0005i*$a\u0003$jY\u0016\u001c\u0005.\u00198oK2D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\tG\"\fgN\\3mA!Ia\b\u0001BC\u0002\u0013\u0005!aP\u0001\u0006gR\f'\u000f^\u000b\u0002\u0001B\u00111%Q\u0005\u0003\u0005\u0012\u00121!\u00138u\u0011!!\u0005A!A!\u0002\u0013\u0001\u0015AB:uCJ$\b\u0005C\u0005G\u0001\t\u0015\r\u0011\"\u0001\u0003\u007f\u0005\u0019QM\u001c3\t\u0011!\u0003!\u0011!Q\u0001\n\u0001\u000bA!\u001a8eA!A!\n\u0001B\u0001B\u0003%1*A\u0004jgNc\u0017nY3\u0011\u0005\rb\u0015BA'%\u0005\u001d\u0011un\u001c7fC:Daa\u0014\u0001\u0005\u0002\u0011\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0004R'R+fk\u0016\t\u0003%\u0002i\u0011A\u0001\u0005\u0006+9\u0003\ra\u0006\u0005\u0006c9\u0003\ra\r\u0005\u0006}9\u0003\r\u0001\u0011\u0005\u0006\r:\u0003\r\u0001\u0011\u0005\u0006\u0015:\u0003\ra\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0003\u0015y6/\u001b>f+\u0005Y\u0006C\u0001/d\u001b\u0005i&B\u00010`\u0003\u0019\tGo\\7jG*\u0011\u0001-Y\u0001\u000bG>t7-\u001e:sK:$(B\u00012\u001c\u0003\u0011)H/\u001b7\n\u0005\u0011l&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004g\u0001\u0001\u0006IaW\u0001\u0007?NL'0\u001a\u0011\t\u000b=\u0003A\u0011\u00015\u0015\u0007EK'\u000eC\u0003\u0016O\u0002\u0007q\u0003C\u00032O\u0002\u00071\u0007C\u0003P\u0001\u0011\u0005A\u000e\u0006\u0002R[\")Qc\u001ba\u0001/!)q\n\u0001C\u0001_R)\u0011\u000b]9tk\")QC\u001ca\u0001/!)!O\u001ca\u0001\u0017\u0006\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\t\u000bQt\u0007\u0019\u0001!\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u000bYt\u0007\u0019A&\u0002\u0017A\u0014X-\u00197m_\u000e\fG/\u001a\u0005\u0006\u001f\u0002!\t\u0001\u001f\u000b\u0004#fT\b\"B\u000bx\u0001\u00049\u0002\"B>x\u0001\u0004Y\u0015aB7vi\u0006\u0014G.\u001a\u0005\u0006\u001f\u0002!\t! \u000b\b#z|\u0018\u0011AA\u0002\u0011\u0015)B\u00101\u0001\u0018\u0011\u0015\tD\u00101\u00014\u0011\u0015qD\u00101\u0001A\u0011\u00151E\u00101\u0001A\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tAA]3bIR)\u0011+a\u0003\u0002\u0010!9\u0011QBA\u0003\u0001\u0004\u0001\u0015\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005E\u0011Q\u0001a\u0001\u0001\u0006!1/\u001b>f\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\tqc]3be\u000eDgi\u001c:PM\u001a\u001cX\r^,ji\"\u001c\u0016N_3\u0015\r\u0005e\u0011QEA\u0018!\u0019\u0019\u00131DA\u0010\u0001&\u0019\u0011Q\u0004\u0013\u0003\rQ+\b\u000f\\33!\r\u0011\u0016\u0011E\u0005\u0004\u0003G\u0011!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\t\u0003O\t\u0019\u00021\u0001\u0002*\u0005aA/\u0019:hKR|eMZ:fiB\u00191%a\u000b\n\u0007\u00055BE\u0001\u0003M_:<\u0007bBA\u0019\u0003'\u0001\r\u0001Q\u0001\u0011gR\f'\u000f^5oOB{7/\u001b;j_:Dq!!\u000e\u0001\t\u0003\t9$\u0001\ntK\u0006\u00148\r\u001b$peRKW.Z:uC6\u0004HCBA\u001d\u0003\u000b\nI\u0005E\u0003$\u0003w\ty$C\u0002\u0002>\u0011\u0012aa\u00149uS>t\u0007c\u0001*\u0002B%\u0019\u00111\t\u0002\u0003\u001fQKW.Z:uC6\u0004xJ\u001a4tKRD\u0001\"a\u0012\u00024\u0001\u0007\u0011\u0011F\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\"9\u0011\u0011GA\u001a\u0001\u0004\u0001\u0005bBA'\u0001\u0011\u0005\u0011qJ\u0001\u0016Y\u0006\u0014x-Z:u)&lWm\u001d;b[B\fe\r^3s)\u0011\ty$!\u0015\t\u000f\u0005E\u00121\na\u0001\u0001\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013aB<sSR,Gk\u001c\u000b\b\u0001\u0006e\u00131MA4\u0011!\tY&a\u0015A\u0002\u0005u\u0013a\u00033fgR\u001c\u0005.\u00198oK2\u00042\u0001NA0\u0013\r\t\t'\u000e\u0002\u0015\u000f\u0006$\b.\u001a:j]\u001e\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u0011\u0005\u0015\u00141\u000ba\u0001\u0003S\tQb\u001e:ji\u0016\u0004vn]5uS>t\u0007bBA\t\u0003'\u0002\r\u0001\u0011\u0005\b\u0003W\u0002A\u0011IA7\u0003\u0001J7/T1hS\u000e4\u0016\r\\;f\u0013:\fE\u000e\\,sCB\u0004XM]'fgN\fw-Z:\u0015\u0007-\u000by\u0007\u0003\u0005\u0002r\u0005%\u0004\u0019AA:\u0003I)\u0007\u0010]3di\u0016$W*Y4jGZ\u000bG.^3\u0011\u0007\r\n)(C\u0002\u0002x\u0011\u0012AAQ=uK\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014a\u0004;p\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;\u0015\u0007!\ty\b\u0003\u0005\u0002\u0002\u0006e\u0004\u0019AA:\u00031!x.T1hS\u000e4\u0016\r\\;f\u0011\u001d\t)\t\u0001C!\u0003\u000f\u000b\u0001\"\u001b;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0003b!a#\u0002\u001c\u0006\u0005f\u0002BAG\u0003/sA!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'3\u0011A\u0002\u001fs_>$h(C\u0001&\u0013\r\tI\nJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti*a(\u0003\u0011%#XM]1u_JT1!!'%!\rI\u00111U\u0005\u0004\u0003KS!\u0001E'fgN\fw-Z!oI>3gm]3u\u0011\u001d\t)\t\u0001C\u0001\u0003S#B!!#\u0002,\"9\u0011QVAT\u0001\u0004\u0001\u0015AD7bq6+7o]1hKNK'0\u001a\u0005\b\u0003c\u0003A\u0011AAZ\u0003-\u0019\u0018N_3J]\nKH/Z:\u0015\u0003\u0001Cq!a.\u0001\t\u0003\tI,\u0001\u0004baB,g\u000e\u001a\u000b\u0004E\u0005m\u0006\u0002CA_\u0003k\u0003\r!a0\u0002\u00115,7o]1hKN\u00042!CAa\u0013\r\t\u0019M\u0003\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\u0006)a\r\\;tQR\t!\u0005C\u0004\u0002N\u0002!\t!!3\u0002\u000b\rdwn]3\t\u000f\u0005E\u0007\u0001\"\u0001\u0002J\u0006!AO]5n\u0011\u001d\t)\u000e\u0001C\u0001\u0003/\fa\u0001Z3mKR,G#A&\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006QAO];oG\u0006$X\rV8\u0015\u0007\u0001\u000by\u000eC\u0004\u0002b\u0006e\u0007\u0019\u0001!\u0002\u0015Q\f'oZ3u'&TX\rC\u0004\u0002f\u0002!\t!a:\u0002\u0011I,\u0017\rZ%oi>$b!!;\u0002r\u0006U\b\u0003BAv\u0003[l\u0011aN\u0005\u0004\u0003_<$A\u0003\"zi\u0016\u0014UO\u001a4fe\"A\u00111_Ar\u0001\u0004\tI/\u0001\u0004ck\u001a4WM\u001d\u0005\b\u0003o\f\u0019\u000f1\u0001A\u0003A\u0011X\r\\1uSZ,\u0007k\\:ji&|g\u000eC\u0004\u0002|\u0002!\t!!@\u0002\u0011I,g.Y7f)>$2AIA\u0000\u0011\u001d\u0011\t!!?A\u0002]\t\u0011A\u001a\u0015\u0004\u0001\t\u0015\u0001cA\b\u0003\b%\u0019!\u0011\u0002\t\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u000f\u001d\u0011iA\u0001E\u0001\u0005\u001f\taBR5mK6+7o]1hKN+G\u000fE\u0002S\u0005#1a!\u0001\u0002\t\u0002\tM1\u0003\u0002B\t\u0005+\u00012a\tB\f\u0013\r\u0011I\u0002\n\u0002\u0007\u0003:L(+\u001a4\t\u000f=\u0013\t\u0002\"\u0001\u0003\u001eQ\u0011!q\u0002\u0005\t\u0005C\u0011\t\u0002\"\u0001\u0003$\u0005Yq\u000e]3o\u0007\"\fgN\\3m)-\u0019$Q\u0005B\u0014\u0005S\u0011YC!\f\t\rU\u0011y\u00021\u0001\u0018\u0011\u0019Y(q\u0004a\u0001\u0017\"A!Oa\b\u0011\u0002\u0003\u00071\n\u0003\u0005u\u0005?\u0001\n\u00111\u0001A\u0011!1(q\u0004I\u0001\u0002\u0004Y\u0005B\u0003B\u0019\u0005#\t\n\u0011\"\u0001\u00034\u0005)r\u000e]3o\u0007\"\fgN\\3mI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u001bU\rY%qG\u0016\u0003\u0005s\u0001BAa\u000f\u0003F5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%A\u0005v]\u000eDWmY6fI*\u0019!1\t\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\tu\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!1\nB\t#\u0003%\tA!\u0014\u0002+=\u0004XM\\\"iC:tW\r\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\n\u0016\u0004\u0001\n]\u0002B\u0003B*\u0005#\t\n\u0011\"\u0001\u00034\u0005)r\u000e]3o\u0007\"\fgN\\3mI\u0011,g-Y;mi\u0012*\u0004")
public class FileMessageSet
extends MessageSet
implements Logging {
    private volatile File file;
    private final FileChannel channel;
    private final int start;
    private final int end;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean openChannel$default$5() {
        return FileMessageSet$.MODULE$.openChannel$default$5();
    }

    public static int openChannel$default$4() {
        return FileMessageSet$.MODULE$.openChannel$default$4();
    }

    public static boolean openChannel$default$3() {
        return FileMessageSet$.MODULE$.openChannel$default$3();
    }

    public static FileChannel openChannel(File file, boolean bl, boolean bl2, int n, boolean bl3) {
        return FileMessageSet$.MODULE$.openChannel(file, bl, bl2, n, bl3);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int position, int size2) {
        if (position < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid position: ").append((Object)BoxesRunTime.boxToInteger((int)position)).toString());
        }
        if (size2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid size: ").append((Object)BoxesRunTime.boxToInteger((int)size2)).toString());
        }
        return new FileMessageSet(this.file(), this.channel(), this.start() + position, this.start() + position + size2 < 0 ? this.sizeInBytes() : package$.MODULE$.min(this.start() + position + size2, this.sizeInBytes()));
    }

    public Tuple2<OffsetPosition, Object> searchForOffsetWithSize(long targetOffset, int startingPosition) {
        int position = startingPosition;
        ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int size2 = this.sizeInBytes();
        while (position + MessageSet$.MODULE$.LogOverhead() < size2) {
            buffer.rewind();
            this.channel().read(buffer, position);
            if (buffer.hasRemaining()) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetOffset), BoxesRunTime.boxToInteger((int)startingPosition), this.file().getAbsolutePath()})));
            }
            buffer.rewind();
            long offset = buffer.getLong();
            int messageSize = buffer.getInt();
            if (messageSize < Message$.MODULE$.MinMessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
            }
            if (offset >= targetOffset) {
                return new Tuple2((Object)new OffsetPosition(offset, position), (Object)BoxesRunTime.boxToInteger((int)(messageSize + MessageSet$.MODULE$.LogOverhead())));
            }
            position += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
        return null;
    }

    public Option<TimestampOffset> searchForTimestamp(long targetTimestamp, int startingPosition) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                FileMessageSet messagesToSearch = this.read(startingPosition, this.sizeInBytes());
                messagesToSearch.foreach(new Serializable(this, targetTimestamp, object){
                    public static final long serialVersionUID = 0L;
                    public final long targetTimestamp$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        Message message = messageAndOffset.message();
                        if (message.timestamp() >= this.targetTimestamp$1) {
                            CompressionCodec compressionCodec = message.compressionCodec();
                            if (NoCompressionCodec$.MODULE$.equals(compressionCodec)) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new TimestampOffset(messageAndOffset.message().timestamp(), messageAndOffset.offset())));
                            }
                            ByteBufferMessageSet$.MODULE$.deepIterator(messageAndOffset, ByteBufferMessageSet$.MODULE$.deepIterator$default$2()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$searchForTimestamp$1 $outer;

                                public final void apply(MessageAndOffset innerMessageAndOffset) {
                                    long timestamp2 = innerMessageAndOffset.message().timestamp();
                                    if (timestamp2 >= this.$outer.targetTimestamp$1) {
                                        throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)new Some((Object)new TimestampOffset(innerMessageAndOffset.message().timestamp(), innerMessageAndOffset.offset())));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The message set (max timestamp = ", ", max offset = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)message.timestamp()), BoxesRunTime.boxToLong((long)messageAndOffset.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" should contain target timestamp ", " but it does not."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.targetTimestamp$1)}))).toString());
                        }
                    }
                    {
                        this.targetTimestamp$1 = targetTimestamp$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public TimestampOffset largestTimestampAfter(int startingPosition) {
        LongRef maxTimestamp = LongRef.create((long)Message$.MODULE$.NoTimestamp());
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        FileMessageSet messagesToSearch = this.read(startingPosition, Integer.MAX_VALUE);
        messagesToSearch.foreach(new Serializable(this, maxTimestamp, offsetOfMaxTimestamp){
            public static final long serialVersionUID = 0L;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                if (messageAndOffset.message().timestamp() > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = messageAndOffset.message().timestamp();
                    this.offsetOfMaxTimestamp$1.elem = messageAndOffset.offset();
                }
            }
            {
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
            }
        });
        return new TimestampOffset(maxTimestamp.elem, offsetOfMaxTimestamp.elem);
    }

    @Override
    public int writeTo(GatheringByteChannel destChannel, long writePosition, int size2) {
        long l;
        int newSize = package$.MODULE$.min((int)this.channel().size(), this.end()) - this.start();
        if (newSize < this._size().get()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this._size().get()), BoxesRunTime.boxToInteger((int)newSize)})));
        }
        long position = (long)this.start() + writePosition;
        int count = package$.MODULE$.min(size2, this.sizeInBytes());
        GatheringByteChannel gatheringByteChannel = destChannel;
        if (gatheringByteChannel instanceof TransportLayer) {
            TransportLayer transportLayer = (TransportLayer)gatheringByteChannel;
            l = transportLayer.transferFrom(this.channel(), position, (long)count);
        } else {
            l = this.channel().transferTo(position, count, gatheringByteChannel);
        }
        int bytesTransferred = (int)l;
        this.trace((Function0<String>)new Serializable(this, size2, bytesTransferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append((Object)BoxesRunTime.boxToInteger((int)this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.size$1 = size$1;
                this.bytesTransferred$1 = bytesTransferred$1;
            }
        });
        return bytesTransferred;
    }

    @Override
    public boolean isMagicValueInAllWrapperMessages(byte expectedMagicValue) {
        int messageSize;
        ByteBuffer offsetAndSizeBuffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        ByteBuffer crcAndMagicByteBuffer = ByteBuffer.allocate(Message$.MODULE$.CrcLength() + Message$.MODULE$.MagicLength());
        for (int location = this.start(); location < this.end(); location += MessageSet$.MODULE$.LogOverhead() + messageSize) {
            offsetAndSizeBuffer.rewind();
            this.channel().read(offsetAndSizeBuffer, location);
            if (offsetAndSizeBuffer.hasRemaining()) {
                return true;
            }
            offsetAndSizeBuffer.rewind();
            offsetAndSizeBuffer.getLong();
            messageSize = offsetAndSizeBuffer.getInt();
            if (messageSize < Message$.MODULE$.MinMessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
            }
            crcAndMagicByteBuffer.rewind();
            this.channel().read(crcAndMagicByteBuffer, location + MessageSet$.MODULE$.LogOverhead());
            if (crcAndMagicByteBuffer.get(Message$.MODULE$.MagicOffset()) == expectedMagicValue) continue;
            return false;
        }
        return true;
    }

    public MessageSet toMessageFormat(byte toMagicValue) {
        ArrayBuffer offsets = new ArrayBuffer();
        ArrayBuffer newMessages = new ArrayBuffer();
        this.foreach(new Serializable(this, toMagicValue, offsets, newMessages){
            public static final long serialVersionUID = 0L;
            public final byte toMagicValue$1;
            public final ArrayBuffer offsets$1;
            public final ArrayBuffer newMessages$1;

            public final Object apply(MessageAndOffset messageAndOffset) {
                BoxedUnit boxedUnit;
                Message message = messageAndOffset.message();
                CompressionCodec compressionCodec = message.compressionCodec();
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                    this.newMessages$1.$plus$eq((Object)message.toFormatVersion(this.toMagicValue$1));
                    boxedUnit = this.offsets$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)messageAndOffset.offset()));
                } else {
                    Iterator<MessageAndOffset> deepIter = ByteBufferMessageSet$.MODULE$.deepIterator(messageAndOffset, ByteBufferMessageSet$.MODULE$.deepIterator$default$2());
                    deepIter.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$toMessageFormat$1 $outer;

                        public final ArrayBuffer<Object> apply(MessageAndOffset innerMessageAndOffset) {
                            this.$outer.newMessages$1.$plus$eq((Object)innerMessageAndOffset.message().toFormatVersion(this.$outer.toMagicValue$1));
                            return this.$outer.offsets$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)innerMessageAndOffset.offset()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.toMagicValue$1 = toMagicValue$1;
                this.offsets$1 = offsets$1;
                this.newMessages$1 = newMessages$1;
            }
        });
        return this.sizeInBytes() > 0 && newMessages.isEmpty() ? this : new ByteBufferMessageSet((CompressionCodec)this.headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodec apply(MessageAndOffset x$1) {
                return x$1.message().compressionCodec();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NoCompressionCodec$ apply() {
                return NoCompressionCodec$.MODULE$;
            }
        }), (Seq<Object>)offsets, (Seq<Message>)newMessages);
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.iterator(Integer.MAX_VALUE);
    }

    public Iterator<MessageAndOffset> iterator(int maxMessageSize) {
        return new IteratorTemplate<MessageAndOffset>(this, maxMessageSize){
            private int location;
            private final int sizeOffsetLength;
            private final ByteBuffer sizeOffsetBuffer;
            private final /* synthetic */ FileMessageSet $outer;
            private final int maxMessageSize$1;

            private int location() {
                return this.location;
            }

            private void location_$eq(int x$1) {
                this.location = x$1;
            }

            private int sizeOffsetLength() {
                return this.sizeOffsetLength;
            }

            private ByteBuffer sizeOffsetBuffer() {
                return this.sizeOffsetBuffer;
            }

            public MessageAndOffset makeNext() {
                if (this.location() + this.sizeOffsetLength() >= this.$outer.end()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                this.$outer.channel().read(this.sizeOffsetBuffer(), this.location());
                if (this.sizeOffsetBuffer().hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                this.sizeOffsetBuffer().rewind();
                long offset = this.sizeOffsetBuffer().getLong();
                int size2 = this.sizeOffsetBuffer().getInt();
                if (size2 < Message$.MODULE$.MinMessageOverhead() || this.location() + this.sizeOffsetLength() + size2 > this.$outer.end()) {
                    return (MessageAndOffset)this.allDone();
                }
                if (size2 > this.maxMessageSize$1) {
                    throw new CorruptRecordException(new StringOps(Predef$.MODULE$.augmentString("Message size exceeds the largest allowable message size (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxMessageSize$1)})));
                }
                ByteBuffer buffer = ByteBuffer.allocate(size2);
                this.$outer.channel().read(buffer, this.location() + this.sizeOffsetLength());
                if (buffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                buffer.rewind();
                this.location_$eq(this.location() + (size2 + this.sizeOffsetLength()));
                return new MessageAndOffset(new Message(buffer, Message$.MODULE$.$lessinit$greater$default$2(), Message$.MODULE$.$lessinit$greater$default$3()), offset);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.location = $outer.start();
                this.sizeOffsetLength = 12;
                this.sizeOffsetBuffer = ByteBuffer.allocate(this.sizeOffsetLength());
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet messages) {
        int written = messages.writeFullyTo(this.channel());
        this._size().getAndAdd(written);
    }

    public void flush() {
        this.channel().force(true);
    }

    public void close() {
        this.flush();
        this.trim();
        this.channel().close();
    }

    public void trim() {
        this.truncateTo(this.sizeInBytes());
    }

    public boolean delete() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.file().delete();
    }

    public int truncateTo(int targetSize) {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException(new StringBuilder().append((Object)"Attempt to truncate log segment to ").append((Object)BoxesRunTime.boxToInteger((int)targetSize)).append((Object)" bytes failed, ").append((Object)" size of this log segment is ").append((Object)BoxesRunTime.boxToInteger((int)originalSize)).append((Object)" bytes.").toString());
        }
        if (targetSize < (int)this.channel().size()) {
            this.channel().truncate(targetSize);
            this.channel().position(targetSize);
            this._size().set(targetSize);
        }
        return originalSize - targetSize;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int relativePosition) {
        this.channel().read(buffer, relativePosition + this.start());
        buffer.flip();
        return buffer;
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end, boolean isSlice) {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        Logging$class.$init$(this);
        this._size = isSlice ? new AtomicInteger(end - start) : new AtomicInteger(package$.MODULE$.min((int)channel.size(), end) - start);
        Object object = isSlice ? BoxedUnit.UNIT : channel.position(package$.MODULE$.min((int)channel.size(), end));
    }

    public FileMessageSet(File file, FileChannel channel) {
        this(file, channel, 0, Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, true, FileMessageSet$.MODULE$.openChannel$default$3(), FileMessageSet$.MODULE$.openChannel$default$4(), FileMessageSet$.MODULE$.openChannel$default$5()));
    }

    public FileMessageSet(File file, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, true, fileAlreadyExists, initFileSize, preallocate), 0, !fileAlreadyExists && preallocate ? 0 : Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file, boolean mutable) {
        this(file, FileMessageSet$.MODULE$.openChannel(file, mutable, FileMessageSet$.MODULE$.openChannel$default$3(), FileMessageSet$.MODULE$.openChannel$default$4(), FileMessageSet$.MODULE$.openChannel$default$5()));
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end) {
        this(file, channel, start, end, true);
    }
}

