/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.AdminManager$;
import kafka.server.ConfigType$;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedCreateTopics;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0005\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002Bqa\u0016\u0001C\u0002\u0013%\u0001,A\tde\u0016\fG/\u001a+pa&\u001c\u0007k\u001c7jGf,\u0012!\u0017\t\u0004\u0013ic\u0016BA.\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q,Y\u0007\u0002=*\u0011q\fY\u0001\u0007a>d\u0017nY=\u000b\u0005\rQ\u0013B\u00012_\u0005E\u0019%/Z1uKR{\u0007/[2Q_2L7-\u001f\u0005\u0007I\u0002\u0001\u000b\u0011B-\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010\t\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0002QB\u0019\u0011BW5\u0011\u0005uS\u0017BA6_\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0005\u0007[\u0002\u0001\u000b\u0011\u00025\u0002%\u0005dG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\t\u0005\u0006_\u0002!\t\u0001]\u0001\u001aQ\u0006\u001cH)\u001a7bs\u0016$Gk\u001c9jG>\u0003XM]1uS>t7/F\u0001r!\tI!/\u0003\u0002t\u0015\t9!i\\8mK\u0006t\u0007\"B;\u0001\t\u00031\u0018!\t;ss\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012$v\u000e]5d\u001fB,'/\u0019;j_:\u001cHCA<{!\tI\u00010\u0003\u0002z\u0015\t!QK\\5u\u0011\u0015YH\u000f1\u0001}\u0003\u0015!x\u000e]5d!\ri\u0018\u0011\u0001\b\u0003\u0013yL!a \u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\ty(\u0002C\u0004\u0002\n\u0001!\t!a\u0003\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0013]\fi!a\u0006\u0002\u001c\u0005]\u0003\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\u000fQLW.Z8viB\u0019\u0011\"a\u0005\n\u0007\u0005U!BA\u0002J]RDq!!\u0007\u0002\b\u0001\u0007\u0011/\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010\u0003\u0005\u0002\u001e\u0005\u001d\u0001\u0019AA\u0010\u0003)\u0019'/Z1uK&sgm\u001c\t\b\u0003C\t9\u0003`A\u0016\u001b\t\t\u0019CC\u0002\u0002&)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\t\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002.\u0005Ec\u0002BA\u0018\u0003\u0017rA!!\r\u0002H9!\u00111GA#\u001d\u0011\t)$a\u0011\u000f\t\u0005]\u0012\u0011\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013B\u0001\u0017.\u0013\t)1&\u0003\u0002*U%\u0019\u0011\u0011\n\u0015\u0002\u0011I,\u0017/^3tiNLA!!\u0014\u0002P\u0005\u00192I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti*\u0019\u0011\u0011\n\u0015\n\t\u0005M\u0013Q\u000b\u0002\r)>\u0004\u0018n\u0019#fi\u0006LGn\u001d\u0006\u0005\u0003\u001b\ny\u0005\u0003\u0005\u0002Z\u0005\u001d\u0001\u0019AA.\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004\n\u0003;\n\tg^\u0005\u0004\u0003?R!!\u0003$v]\u000e$\u0018n\u001c82!\u001d\t\t#a\n}\u0003G\u0002B!!\u001a\u0002h5\u0011\u0011qJ\u0005\u0005\u0003S\nyE\u0001\u0005Ba&,%O]8s\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\nA\u0002Z3mKR,Gk\u001c9jGN$ra^A9\u0003g\ni\b\u0003\u0005\u0002\u0010\u0005-\u0004\u0019AA\t\u0011!\t)(a\u001bA\u0002\u0005]\u0014A\u0002;pa&\u001c7\u000fE\u0003\u0002\"\u0005eD0\u0003\u0003\u0002|\u0005\r\"aA*fi\"A\u0011\u0011LA6\u0001\u0004\ty\b\u0005\u0004\n\u0003;\n\ti\u001e\t\b\u0003C\t9\u0003`AB!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAEQ\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u000e\u0006\u001d%AB#se>\u00148\u000fC\u0004\u0002\u0012\u0002!\t!a%\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$B!!&\u0002,BA\u0011\u0011EA\u0014\u0003/\u000bi\n\u0005\u0003\u0002f\u0005e\u0015\u0002BAN\u0003\u001f\u0012\u0001BU3t_V\u00148-\u001a\t\u0005\u0003?\u000b)K\u0004\u0003\u0002f\u0005\u0005\u0016\u0002BAR\u0003\u001f\nq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\u0005\u001d\u0016\u0011\u0016\u0002\u0007\u0007>tg-[4\u000b\t\u0005\r\u0016q\n\u0005\t\u0003[\u000by\t1\u0001\u00020\u0006)\"/Z:pkJ\u001cW\rV8D_:4\u0017n\u001a(b[\u0016\u001c\b\u0003CA\u0011\u0003O\t9*!-\u0011\t%Q\u0016q\u000f\u0005\b\u0003k\u0003A\u0011AA\\\u00031\tG\u000e^3s\u0007>tg-[4t)\u0019\tI,a/\u0002NBA\u0011\u0011EA\u0014\u0003/\u000b\u0019\u0007\u0003\u0005\u0002>\u0006M\u0006\u0019AA`\u0003\u001d\u0019wN\u001c4jON\u0004\u0002\"!\t\u0002(\u0005]\u0015\u0011\u0019\t\u0005\u0003\u0007\fIM\u0004\u0003\u0002f\u0005\u0015\u0017\u0002BAd\u0003\u001f\n1#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgRLA!a*\u0002L*!\u0011qYA(\u0011\u001d\tI\"a-A\u0002EDq!!5\u0001\t\u0003\t\u0019.\u0001\u0005tQV$Hm\\<o)\u00059\b")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy;
    private final Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy() {
        return this.kafka$server$AdminManager$$createTopicPolicy;
    }

    public Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy() {
        return this.kafka$server$AdminManager$$alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)new Serializable(this, key, completed){
            public static final long serialVersionUID = 0L;
            private final TopicKey key$1;
            private final int completed$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.keyLabel(), BoxesRunTime.boxToInteger((int)this.completed$1)}));
            }
            {
                this.key$1 = key$1;
                this.completed$1 = completed$1;
            }
        });
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker b) {
                return new BrokerMetadata(b.id(), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1)new Serializable(this, validateOnly, brokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$1;
            private final Seq brokers$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreateTopicMetadata apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                CreateTopicMetadata createTopicMetadata;
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                String value2 = (String)tuple2._2();
                                Object object = this.configs$1.setProperty(key, value2);
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map assignments = arguments.replicasAssignments.isEmpty() ? AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokers$1, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Integer, List<Integer>> x0$3) {
                            Tuple2<Integer, List<Integer>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                List replicas = (List)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Integer x$1) {
                                        return x$1;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    this.$outer.trace((Function0<String>)new Serializable(this, topic, assignments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Map assignments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.assignments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.assignments$1 = assignments$1;
                        }
                    });
                    Option<CreateTopicPolicy> option = this.$outer.kafka$server$AdminManager$$createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.x();
                        AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (this.validateOnly$1) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit;
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        if (this.validateOnly$1) {
                            AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    createTopicMetadata = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)assignments, ApiError.NONE);
                    return createTopicMetadata;
                }
                catch (Throwable throwable22) {
                    CreateTopicMetadata createTopicMetadata2;
                    Throwable throwable3 = throwable22;
                    boolean bl = throwable3 instanceof PolicyViolationException ? true : throwable3 instanceof ApiException;
                    if (bl) {
                        this.$outer.info((Function0<String>)new Serializable(this, topic, arguments){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final CreateTopicsRequest.TopicDetails arguments$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                            }
                            {
                                this.topic$1 = topic$1;
                                this.arguments$1 = arguments$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable3){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x7$1;

                            public final Throwable apply() {
                                return this.x7$1;
                            }
                            {
                                this.x7$1 = x7$1;
                            }
                        });
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        if (throwable3 == null) throw throwable22;
                        Throwable throwable4 = throwable3;
                        this.$outer.error((Function0<String>)new Serializable(this, topic, arguments){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final CreateTopicsRequest.TopicDetails arguments$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                            }
                            {
                                this.topic$1 = topic$1;
                                this.arguments$1 = arguments$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable4){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x10$1;

                            public final Throwable apply() {
                                return this.x10$1;
                            }
                            {
                                this.x10$1 = x10$1;
                            }
                        });
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable4));
                    }
                    createTopicMetadata = createTopicMetadata2;
                }
                return createTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$1 = validateOnly$1;
                this.brokers$1 = brokers$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreateTopicMetadata x$2) {
                return x$2.error().is(Errors.NONE);
            }
        })) {
            DelayedCreateTopics delayedCreate = new DelayedCreateTopics(timeout, (Seq<CreateTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$3) {
                    return new TopicKey(x$3);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$1;

                public final Tuple2<String, ApiError> apply(CreateTopicMetadata createTopicMetadata) {
                    return createTopicMetadata.error().isSuccess() && !this.validateOnly$1 ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
                }
                {
                    this.validateOnly$1 = validateOnly$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final DeleteTopicMetadata apply(String topic) {
                DeleteTopicMetadata deleteTopicMetadata;
                try {
                    AdminUtils$.MODULE$.deleteTopic(this.$outer.zkUtils(), topic);
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.forException((Throwable)throwable));
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                return deleteTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DeleteTopicMetadata x$4) {
                Errors errors = x$4.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$5) {
                    return new TopicKey(x$5);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(DeleteTopicMetadata deleteTopicMetadata) {
                    Errors errors = deleteTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public Map<Resource, DescribeConfigsResponse.Config> describeConfigs(Map<Resource, Option<Set<String>>> resourceToConfigNames) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<Resource, DescribeConfigsResponse.Config> apply(Tuple2<Resource, Option<Set<String>>> x0$4) {
                Tuple2 tuple2;
                Tuple2<Resource, Option<Set<String>>> tuple22 = x0$4;
                if (tuple22 == null) throw new MatchError(tuple22);
                Resource resource = (Resource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ResourceType resourceType = resource.type();
                    if (ResourceType.TOPIC.equals(resourceType)) {
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        Properties topicProps = AdminUtils$.MODULE$.fetchEntityConfig(this.$outer.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
                        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.$outer.config()), topicProps);
                        config = this.createResponseConfig$1(logConfig, false, (Function1)new Serializable(this, topicProps){
                            public static final long serialVersionUID = 0L;
                            private final Properties topicProps$1;

                            public final boolean apply(String name) {
                                return !this.topicProps$1.containsKey(name);
                            }
                            {
                                this.topicProps$1 = topicProps$1;
                            }
                        }, configNames);
                    } else {
                        if (!ResourceType.BROKER.equals(resourceType)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported resource type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceType})));
                        int brokerId = this.liftedTree1$1(resource);
                        if (brokerId != this.$outer.config().brokerId()) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", ", but received ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()), BoxesRunTime.boxToInteger((int)brokerId)})));
                        config = this.createResponseConfig$1(this.$outer.config(), true, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$describeConfigs$1 $outer;

                            public final boolean apply(String name) {
                                return !this.$outer.kafka$server$AdminManager$$anonfun$$$outer().config().originals().containsKey(name);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, configNames);
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                    return tuple2;
                }
                catch (Throwable throwable) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing describe configs request for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource}));
                    if (throwable instanceof ApiException) {
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$2;

                            public final Throwable apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = e$2;
                            }
                        });
                    } else {
                        this.$outer.error((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$2;

                            public final Throwable apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = e$2;
                            }
                        });
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)throwable), Collections.<T>emptyList()));
                }
                return tuple2;
            }

            public /* synthetic */ AdminManager kafka$server$AdminManager$$anonfun$$$outer() {
                return this.$outer;
            }

            private final DescribeConfigsResponse.Config createResponseConfig$1(AbstractConfig config, boolean isReadOnly, Function1 isDefault, Option configNames$1) {
                IndexedSeq filteredConfigPairs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala()).filter((Function1)new Serializable(this, configNames$1){
                    public static final long serialVersionUID = 0L;
                    private final Option configNames$1;

                    public final boolean apply(Tuple2<String, Object> x0$5) {
                        Tuple2<String, Object> tuple2 = x0$5;
                        if (tuple2 != null) {
                            String configName = (String)tuple2._1();
                            boolean bl = BoxesRunTime.unboxToBoolean((Object)this.configNames$1.map((Function1)new Serializable(this, configName){
                                public static final long serialVersionUID = 0L;
                                private final String configName$1;

                                public final boolean apply(Set<String> x$6) {
                                    return x$6.contains((Object)this.configName$1);
                                }
                                {
                                    this.configName$1 = configName$1;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply() {
                                    return this.apply$mcZ$sp();
                                }

                                public boolean apply$mcZ$sp() {
                                    return true;
                                }
                            }));
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.configNames$1 = configNames$1;
                    }
                })).toIndexedSeq();
                IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1)new Serializable(this, config, isReadOnly, isDefault){
                    public static final long serialVersionUID = 0L;
                    private final AbstractConfig config$1;
                    private final boolean isReadOnly$1;
                    private final Function1 isDefault$1;

                    public final DescribeConfigsResponse.ConfigEntry apply(Tuple2<String, Object> x0$6) {
                        Tuple2<String, Object> tuple2 = x0$6;
                        if (tuple2 != null) {
                            ConfigDef.Type configEntryType;
                            String name = (String)tuple2._1();
                            Object value2 = tuple2._2();
                            ConfigDef.Type type = configEntryType = this.config$1.typeOf(name);
                            ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
                            boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
                            String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value2, (ConfigDef.Type)configEntryType);
                            DescribeConfigsResponse.ConfigEntry configEntry = new DescribeConfigsResponse.ConfigEntry(name, valueAsString, isSensitive, BoxesRunTime.unboxToBoolean((Object)this.isDefault$1.apply((Object)name)), this.isReadOnly$1);
                            return configEntry;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.config$1 = config$1;
                        this.isReadOnly$1 = isReadOnly$1;
                        this.isDefault$1 = isDefault$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
            }

            private final int liftedTree1$1(Resource resource$1) {
                try {
                    return new StringOps(Predef$.MODULE$.augmentString(resource$1.name())).toInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id must be an integer, but it is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource$1.name()})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<Resource, ApiError> alterConfigs(Map<Resource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1)new Serializable(this, validateOnly){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<Resource, ApiError> apply(Tuple2<Resource, AlterConfigsRequest.Config> x0$7) {
                Tuple2 tuple2;
                Tuple2<Resource, AlterConfigsRequest.Config> tuple22 = x0$7;
                if (tuple22 == null) throw new MatchError(tuple22);
                Resource resource = (Resource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    ResourceType resourceType = resource.type();
                    if (!ResourceType.TOPIC.equals(resourceType)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AlterConfigs is only supported for topics, but resource type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceType})));
                    String topic = resource.name();
                    Properties properties = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this, properties){
                        public static final long serialVersionUID = 0L;
                        private final Properties properties$1;

                        public final Object apply(AlterConfigsRequest.ConfigEntry configEntry) {
                            return this.properties$1.setProperty(configEntry.name(), configEntry.value());
                        }
                        {
                            this.properties$1 = properties$1;
                        }
                    });
                    Option<AlterConfigPolicy> option = this.$outer.kafka$server$AdminManager$$alterConfigPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        AlterConfigPolicy policy = (AlterConfigPolicy)some.x();
                        AdminUtils$.MODULE$.validateTopicConfig(this.$outer.zkUtils(), topic, properties);
                        scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, String> apply(AlterConfigsRequest.ConfigEntry entry2) {
                                return new Tuple2((Object)entry2.name(), (Object)entry2.value());
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(ConfigResource.Type.TOPIC, resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
                        if (this.validateOnly$2) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.changeTopicConfig(this.$outer.zkUtils(), topic, properties);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit;
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        if (this.validateOnly$2) {
                            AdminUtils$.MODULE$.validateTopicConfig(this.$outer.zkUtils(), topic, properties);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.changeTopicConfig(this.$outer.zkUtils(), topic, properties);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    tuple2 = tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    return tuple2;
                }
                catch (Throwable throwable) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing alter configs request for resource ", ", config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, config}));
                    if (throwable instanceof ApiException || throwable instanceof PolicyViolationException) {
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$3;

                            public final String apply() {
                                return this.message$3;
                            }
                            {
                                this.message$3 = message$3;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$3;

                            public final Throwable apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                    } else {
                        this.$outer.error((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$3;

                            public final String apply() {
                                return this.message$3;
                            }
                            {
                                this.message$3 = message$3;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$3;

                            public final Throwable apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable));
                    return tuple2;
                }
                catch (ConfigException configException) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for resource ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, configException.getMessage()}));
                    this.$outer.info((Function0<String>)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$2;

                        public final String apply() {
                            return this.message$2;
                        }
                        {
                            this.message$2 = message$2;
                        }
                    });
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, (Throwable)configException)));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$2 = validateOnly$2;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$createTopicPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(CreateTopicPolicy x$7) {
                        x$7.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$alterConfigPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AlterConfigPolicy x$8) {
                        x$8.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Admin Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.kafka$server$AdminManager$$createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.kafka$server$AdminManager$$alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

