/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args) {
        void var2_2;
        block5: {
            void var3_3;
            block8: {
                boolean bl;
                OptionSet options;
                ArgumentAcceptingOptionSpec zkConnectionTimeoutOpt;
                ArgumentAcceptingOptionSpec zkSessionTimeoutOpt;
                ArgumentAcceptingOptionSpec zkUrlOpt;
                block7: {
                    String string;
                    block6: {
                        String jaasFile = System.getProperty("java.security.auth.login.config");
                        OptionParser parser = new OptionParser(false);
                        ArgumentAcceptingOptionSpec zkAclOpt = parser.accepts("zookeeper.acl", "Indicates whether to make the Kafka znodes in ZooKeeper secure or unsecure. The options are 'secure' and 'unsecure'").withRequiredArg().ofType(String.class);
                        zkUrlOpt = parser.accepts("zookeeper.connect", "Sets the ZooKeeper connect string (ensemble). This parameter takes a comma-separated list of host:port pairs.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
                        zkSessionTimeoutOpt = parser.accepts("zookeeper.session.timeout", "Sets the ZooKeeper session timeout.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(30000), (Object[])new Integer[0]);
                        zkConnectionTimeoutOpt = parser.accepts("zookeeper.connection.timeout", "Sets the ZooKeeper connection timeout.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(30000), (Object[])new Integer[0]);
                        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
                        options = parser.parse(args);
                        if (options.has((OptionSpec)helpOpt)) {
                            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, this.usageMessage());
                        }
                        if (jaasFile == null) {
                            String errorMsg = new StringBuilder().append((Object)"No JAAS configuration file has been specified. Please make sure that you have set ").append((Object)new StringOps(Predef$.MODULE$.augmentString("the system property %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config"}))).toString();
                            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                            throw new IllegalArgumentException("Incorrect configuration");
                        }
                        if (!JaasUtils.isZkSecurityEnabled()) break block5;
                        string = (String)options.valueOf((OptionSpec)zkAclOpt);
                        if (!"secure".equals(string)) break block6;
                        this.info((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "zookeeper.acl option is secure";
                            }
                        });
                        bl = true;
                        break block7;
                    }
                    if (!"unsecure".equals(string)) break block8;
                    this.info((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "zookeeper.acl option is unsecure";
                        }
                    });
                    bl = false;
                }
                boolean zkAcl = bl;
                String zkUrl = (String)options.valueOf((OptionSpec)zkUrlOpt);
                int zkSessionTimeout = (Integer)options.valueOf((OptionSpec)zkSessionTimeoutOpt);
                int zkConnectionTimeout = (Integer)options.valueOf((OptionSpec)zkConnectionTimeoutOpt);
                ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkUrl, zkSessionTimeout, zkConnectionTimeout, zkAcl);
                ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkUtils);
                migrator.kafka$admin$ZkSecurityMigrator$$run();
                return;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie((OptionParser)var3_3, this.usageMessage());
        }
        String errorMsg = new StringOps(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}));
        System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
        throw new IllegalArgumentException("Incorrect configuration");
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }
}

