/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.ConfigType$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"2!\t\u0012$!\t1\u0002\u0001C\u0003\u0004=\u0001\u0007Q\u0003C\u0003\u001b=\u0001\u00071\u0004C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001(!\t1\u0002&\u0003\u0002*\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r-\u0002\u0001\u0015!\u0003(\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f5\u0002!\u0019!C\u0001]\u0005)\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,W#A\u0018\u0011\u0005Y\u0001\u0014BA\u0019\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016Daa\r\u0001!\u0002\u0013y\u0013A\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0011\t\u000fU\u0002!\u0019!C\u0001m\u0005\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\tq\u0007\u0005\u0002\u0017q%\u0011\u0011H\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002)I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001di\u0004A1A\u0005\u0002y\nA#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$W#A \u0011\u0005%\u0001\u0015BA!\u000b\u0005\u001d\u0011un\u001c7fC:Daa\u0011\u0001!\u0002\u0013y\u0014!F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G\r\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003E!x\u000e]5dgR{')\u001a#fY\u0016$X\rZ\u000b\u0002\u000fB\u0019\u0001*T(\u000e\u0003%S!AS&\u0002\u000f5,H/\u00192mK*\u0011AJC\u0001\u000bG>dG.Z2uS>t\u0017B\u0001(J\u0005\r\u0019V\r\u001e\t\u0003!Ns!!C)\n\u0005IS\u0011A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\u0006\t\r]\u0003\u0001\u0015!\u0003H\u0003I!x\u000e]5dgR{')\u001a#fY\u0016$X\r\u001a\u0011\t\u000fe\u0003!\u0019!C\u00015\u0006)\u0002/\u0019:uSRLwN\\:U_\n+G)\u001a7fi\u0016$W#A.\u0011\u0007!kE\f\u0005\u0002^A6\taL\u0003\u0002`\t\u000511m\\7n_:L!!\u00190\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004d\u0001\u0001\u0006IaW\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cHk\u001c\"f\t\u0016dW\r^3eA!9Q\r\u0001b\u0001\n\u00031\u0015a\u0007;pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\u0003\u0004h\u0001\u0001\u0006IaR\u0001\u001di>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8!\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0011Ig.\u001b;\u0015\u0007-t7\u000f\u0005\u0002\nY&\u0011QN\u0003\u0002\u0005+:LG\u000fC\u0003pQ\u0002\u0007\u0001/\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042!\u001d:P\u001b\u0005Y\u0015B\u0001(L\u0011\u0015!\b\u000e1\u0001q\u0003\tJg.\u001b;jC2$v\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\")a\u000f\u0001C\u0001o\u0006\u0001BO]=U_BL7\rR3mKRLwN\u001c\u000b\u0002W\")\u0011\u0010\u0001C\u0001o\u0006)!/Z:fi\")1\u0010\u0001C\u0001y\u0006ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0005-l\b\"\u0002@{\u0001\u0004\u0001\u0018A\u0002;pa&\u001c7\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002/I,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cHcA6\u0002\u0006!9ap I\u0001\u0002\u0004\u0001\bbBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004W\u00065\u0001\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\u0011I,\u0007\u000f\\5dCN\u0004B!\u001d:\u0002\u0014A\u0019a#!\u0006\n\u0007\u0005]!AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0004\u0002\u001c\u0001!\t!!\b\u0002=5\f'o\u001b+pa&\u001c\u0017J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>tGcA6\u0002 !1a0!\u0007A\u0002ADq!a\t\u0001\t\u0013\t)#\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007}\n9\u0003C\u0004\u0002*\u0005\u0005\u0002\u0019A(\u0002\u000bQ|\u0007/[2\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\ry\u0014\u0011\u0007\u0005\b\u0003S\tY\u00031\u0001P\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\ta#[:QCJ$\u0018\u000e^5p]R{')\u001a#fY\u0016$X\r\u001a\u000b\u0004\u007f\u0005e\u0002bBA\u001e\u0003g\u0001\r\u0001X\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007bBA \u0001\u0011\u0005\u0011\u0011I\u0001\u001bSN$v\u000e]5d#V,W/\u001a3Va\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004\u007f\u0005\r\u0003bBA\u0015\u0003{\u0001\ra\u0014\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002l\u0003\u0017B\u0001\"a\u0004\u0002F\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003\u001f\u0002A\u0011BA)\u0003iI7\u000fV8qS\u000e,E.[4jE2,gi\u001c:EK2,G/[8o)\ry\u00141\u000b\u0005\b\u0003S\ti\u00051\u0001P\u0011\u001d\t9\u0006\u0001C\u0005\u00033\n\u0011$\\1sWR{\u0007/[2G_J$U\r\\3uS>t'+\u001a;ssR\u00191.a\u0017\t\u000f\u0005%\u0012Q\u000ba\u0001\u001f\"9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014aE2p[BdW\r^3EK2,G/\u001a+pa&\u001cGcA6\u0002d!9\u0011\u0011FA/\u0001\u0004y\u0005bBA4\u0001\u0011%\u0011\u0011N\u0001\u0010_:$v\u000e]5d\t\u0016dW\r^5p]R\u00191.a\u001b\t\ry\f)\u00071\u0001q\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\nAc\u001d;beR\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGcA6\u0002t!A\u0011QOA7\u0001\u0004\t\t\"\u0001\u000fsKBd\u0017nY1t\r>\u0014Hk\u001c9jGN$vNQ3EK2,G/\u001a3\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\u0005\u0019rN\u001c)beRLG/[8o\t\u0016dW\r^5p]R\u00191.! \t\u000fe\u000b9\b1\u0001\u0002\u0000A\u0019\u0011O\u001d/\t\r\u0005\r\u0005\u0001\"\u0003x\u0003=\u0011Xm];nK\u0012+G.\u001a;j_:\u001c\b\"CAD\u0001E\u0005I\u0011AAE\u0003\u0005\u0012Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tYIK\u0002q\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033S\u0011AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    public final ControllerEventManager kafka$controller$TopicDeletionManager$$eventManager;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            ZkUtils zkUtils = this.controllerContext().zkUtils();
            initialTopicsToBeDeleted.foreach((Function1)new Serializable(this, zkUtils){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;
                private final ZkUtils zkUtils$1;

                public final boolean apply(String topic) {
                    String deleteTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, deleteTopicPath){
                        public static final long serialVersionUID = 0L;
                        private final String deleteTopicPath$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Removing ").append((Object)this.deleteTopicPath$1).append((Object)" since delete topic is disabled").toString();
                        }
                        {
                            this.deleteTopicPath$1 = deleteTopicPath$1;
                        }
                    });
                    return this.zkUtils$1.deletePath(deleteTopicPath);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.zkUtils$1 = zkUtils$1;
                }
            });
        }
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void reset() {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return this.isDeleteTopicEnabled() ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$controller.deregisterPartitionModificationsListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicAndPartition x$2) {
                String string = x$2.topic();
                String string2 = this.topic$2;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        });
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.deletePath(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        Set partitions = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return ((TopicAndPartition)p._1()).topic();
            }
        });
        topics.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicAndPartition>)((MapLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).keySet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).keys().foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(PartitionAndReplica p) {
                        String string = p.topic();
                        String string2 = this.topic$3;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                });
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                });
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractResponse, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                    public final void apply(AbstractResponse stopReplicaResponseObj, int replicaId) {
                        this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived(this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controller, stopReplicaResponseObj, replicaId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).build());
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$3 = topic$3;
                        }
                    });
                    this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                }
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            });
        }
        topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionAndReplica x$4) {
                            return x$4.replica();
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    Set partitions = (Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicAndPartition apply(PartitionAndReplica r) {
                            return new TopicAndPartition(r.topic(), r.partition());
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    this.$outer.info((Function0<String>)new Serializable(this, replicaIds, partitions, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set replicaIds$1;
                        private final Set partitions$1;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                        }
                        {
                            this.replicaIds$1 = replicaIds$1;
                            this.partitions$1 = partitions$1;
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        this.kafka$controller$TopicDeletionManager$$eventManager = eventManager;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Topic Deletion Manager ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"], ").toString());
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

