/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.KafkaScheduler;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class LogManager$ {
    public static final LogManager$ MODULE$;
    private final String RecoveryPointCheckpointFile;
    private final String LogStartOffsetCheckpointFile;
    private final int ProducerIdExpirationCheckIntervalMs;

    static {
        new LogManager$();
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return this.LogStartOffsetCheckpointFile;
    }

    public int ProducerIdExpirationCheckIntervalMs() {
        return this.ProducerIdExpirationCheckIntervalMs;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ZkUtils zkUtils, BrokerState brokerState, KafkaScheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, LogDirFailureChannel logDirFailureChannel) {
        java.util.Map<String, Object> defaultProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(config);
        LogConfig defaultLogConfig = new LogConfig(defaultProps);
        Map topicConfigs = (Map)AdminUtils$.MODULE$.fetchAllTopicConfigs(zkUtils).map((Function1)new Serializable(defaultProps){
            public static final long serialVersionUID = 0L;
            private final java.util.Map defaultProps$1;

            public final Tuple2<String, LogConfig> apply(Tuple2<String, Properties> x0$6) {
                Tuple2<String, Properties> tuple2 = x0$6;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Properties configs = (Properties)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)((Object)LogConfig$.MODULE$.fromProps(this.defaultProps$1, configs)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.defaultProps$1 = defaultProps$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        CleanerConfig cleanerConfig = new CleanerConfig(Predef$.MODULE$.Integer2int(config.logCleanerThreads()), Predef$.MODULE$.Long2long(config.logCleanerDedupeBufferSize()), Predef$.MODULE$.Double2double(config.logCleanerDedupeBufferLoadFactor()), Predef$.MODULE$.Integer2int(config.logCleanerIoBufferSize()), Predef$.MODULE$.Integer2int(config.messageMaxBytes()), Predef$.MODULE$.Double2double(config.logCleanerIoMaxBytesPerSecond()), Predef$.MODULE$.Long2long(config.logCleanerBackoffMs()), config.logCleanerEnable(), CleanerConfig$.MODULE$.apply$default$9());
        return new LogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$20) {
                return new File(x$20).getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom())), (Seq<File>)((Seq)initialOfflineDirs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$21) {
                return new File(x$21).getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom())), (Map<String, LogConfig>)topicConfigs, defaultLogConfig, cleanerConfig, Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir()), Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs()), config.logFlushOffsetCheckpointIntervalMs(), config.logFlushStartOffsetCheckpointIntervalMs(), Predef$.MODULE$.Long2long(config.logCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.transactionIdExpirationMs()), kafkaScheduler, brokerState, brokerTopicStats, logDirFailureChannel, time);
    }

    private LogManager$() {
        MODULE$ = this;
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";
        this.ProducerIdExpirationCheckIntervalMs = 600000;
    }
}

