/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerIdEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u001dt!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefDq!a\u0007{\u0001\u0004\ti\"\u0001\u0003gS2,\u0007\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB%\u0001\u0002j_&!\u0011qEA\u0011\u0005\u00111\u0015\u000e\\3\t\u000f\u0005-\u0012\u0002\"\u0003\u0002.\u0005iqO]5uKNs\u0017\r]:i_R$b!a\f\u00026\u0005]\u0002cA\u0007\u00022%\u0019\u00111\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\tI\u00031\u0001\u0002\u001e!A\u0011\u0011HA\u0015\u0001\u0004\tY$A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005u\u0012qIA&\u0003'i!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\b[V$\u0018M\u00197f\u0015\r\t)ED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u007f\u00111!T1q!\ri\u0011QJ\u0005\u0004\u0003\u001fr!\u0001\u0002'p]\u001eDq!a\u0015\n\t\u0013\t)&\u0001\bjgNs\u0017\r]:i_R4\u0015\u000e\\3\u0015\t\u0005]\u0013Q\f\t\u0004\u001b\u0005e\u0013bAA.\u001d\t9!i\\8mK\u0006t\u0007\u0002CA\u000e\u0003#\u0002\r!!\b\t\u0011\u0005\u0005\u0014\u0002\"\u0001\u0003\u0003G\n\u0011\u0003\\5tiNs\u0017\r]:i_R4\u0015\u000e\\3t)\u0011\t)'a\u001b\u0011\u000by\f9'!\b\n\t\u0005%\u0014\u0011\u0003\u0002\u0004'\u0016\f\b\u0002CA7\u0003?\u0002\r!!\b\u0002\u0007\u0011L'\u000f\u0003\u0005\u0002r%!\tAAA:\u0003U!W\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$b!a\f\u0002v\u0005]\u0004\u0002CA7\u0003_\u0002\r!!\b\t\u0011\u0005e\u0014q\u000ea\u0001\u0003\u0017\naa\u001c4gg\u0016$\bbBA?\u0013\u0011%\u0011qP\u0001\u0014I\u0016dW\r^3T]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0007\u0003_\t\t)a!\t\u0011\u00055\u00141\u0010a\u0001\u0003;A!\"!\"\u0002|A\u0005\t\u0019AAD\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0004\u000e\u0003\u0013\u000bY%a\u0016\n\u0007\u0005-eBA\u0005Gk:\u001cG/[8oc!I\u0011qR\u0005\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M%fA+\u0002\u0016.\u0012\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003%)hn\u00195fG.,GMC\u0002\u0002\":\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)+a'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002*&\t\n\u0011\"\u0003\u0002,\u0006iB-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002.*\"\u0011qQAK\r\u0015Q!\u0001AAY'\u0015\ty\u000bDAZ!\u0011\t),a/\u000e\u0005\u0005]&bAA]\t\u0005)Q\u000f^5mg&!\u0011QXA\\\u0005\u001daunZ4j]\u001eD1\"!1\u00020\n\u0015\r\u0011\"\u0001\u0002D\u0006qAo\u001c9jGB\u000b'\u000f^5uS>tWCAAc!\u0011\t9-!3\u000e\u0003-L1!a3l\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D1\"a4\u00020\n\u0005\t\u0015!\u0003\u0002F\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0006\u0002T\u0006=&Q1A\u0005\u0002\u0005U\u0017A\u00027pO\u0012K'/\u0006\u0002\u0002\u001e!Y\u0011\u0011\\AX\u0005\u0003\u0005\u000b\u0011BA\u000f\u0003\u001dawn\u001a#je\u0002B!\"!8\u00020\n\u0015\r\u0011\"\u0001U\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\t\u0015\u0005\u0005\u0018q\u0016B\u0001B\u0003%Q+\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004\u0014\u0003_#\t!!:\u0015\u0011\u0005\u001d\u0018\u0011^Av\u0003[\u00042\u0001CAX\u0011!\t\t-a9A\u0002\u0005\u0015\u0007\u0002CAj\u0003G\u0004\r!!\b\t\u0013\u0005u\u00171\u001dI\u0001\u0002\u0004)\u0006BCAy\u0003_\u0013\r\u0011\"\u0003\u0002t\u0006I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003wA\u0011\"a>\u00020\u0002\u0006I!a\u000f\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0003\u0006\u0002|\u0006=\u0006\u0019!C\u0005\u0003{\fQ\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$XCAA&\u0011)\u0011\t!a,A\u0002\u0013%!1A\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0018\u0005\u000bA!Ba\u0002\u0002\u0000\u0006\u0005\t\u0019AA&\u0003\rAH%\r\u0005\n\u0005\u0017\ty\u000b)Q\u0005\u0003\u0017\na\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$\b\u0005\u0003\u0006\u0003\u0010\u0005=\u0006\u0019!C\u0005\u0003{\fa\u0002\\1tiNs\u0017\r](gMN,G\u000f\u0003\u0006\u0003\u0014\u0005=\u0006\u0019!C\u0005\u0005+\t!\u0003\\1tiNs\u0017\r](gMN,Go\u0018\u0013fcR!\u0011q\u0006B\f\u0011)\u00119A!\u0005\u0002\u0002\u0003\u0007\u00111\n\u0005\n\u00057\ty\u000b)Q\u0005\u0003\u0017\nq\u0002\\1tiNs\u0017\r](gMN,G\u000f\t\u0005\u000b\u0005?\tyK1A\u0005\n\t\u0005\u0012aC8oO>Lgn\u001a+y]N,\"Aa\t\u0011\u0011\t\u0015\"1FA&\u0005_i!Aa\n\u000b\u0007\t%B%\u0001\u0003vi&d\u0017\u0002\u0002B\u0017\u0005O\u0011q\u0001\u0016:fK6\u000b\u0007\u000fE\u0002\t\u0005cI1Aa\r\u0003\u0005-!\u0006P\\'fi\u0006$\u0017\r^1\t\u0013\t]\u0012q\u0016Q\u0001\n\t\r\u0012\u0001D8oO>Lgn\u001a+y]N\u0004\u0003B\u0003B\u001e\u0003_\u0013\r\u0011\"\u0003\u0003\"\u0005\u0001RO\u001c:fa2L7-\u0019;fIRChn\u001d\u0005\n\u0005\u007f\ty\u000b)A\u0005\u0005G\t\u0011#\u001e8sKBd\u0017nY1uK\u0012$\u0006P\\:!\u0011!\u0011\u0019%a,\u0005\u0002\t\u0015\u0013a\u00054jeN$XK\\:uC\ndWm\u00144gg\u0016$XC\u0001B$!\u0015i!\u0011\nB'\u0013\r\u0011YE\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t=#QK\u0007\u0003\u0005#R1Aa\u0015\u0005\u0003\u0019\u0019XM\u001d<fe&!!q\u000bB)\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\t\u00057\ny\u000b\"\u0001\u0003^\u00051rN\u001c%jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,G\r\u0006\u0003\u00020\t}\u0003\u0002\u0003B1\u00053\u0002\r!a\u0013\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0011!\u0011)'a,\u0005\u0002\t\u001d\u0014\u0001\u00064jeN$XK\u001c3fG&$W\rZ(gMN,G/\u0006\u0002\u0003jA)QB!\u0013\u0002L!A!QNAX\t\u0003\ti0\u0001\u0007nCB,e\u000eZ(gMN,G\u000f\u0003\u0005\u0003r\u0005=F\u0011\u0001B:\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXC\u0001B;!!\u00119H! \u0002L\u0005MQB\u0001B=\u0015\u0011\u0011Y(a\u0011\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA%\u0005sB\u0001B!!\u00020\u0012\u0005!1Q\u0001\bSN,U\u000e\u001d;z+\t\t9\u0006\u0003\u0005\u0003\b\u0006=F\u0011\u0002BE\u0003Aaw.\u00193Ge>l7K\\1qg\"|G\u000f\u0006\u0004\u00020\t-%q\u0012\u0005\t\u0005\u001b\u0013)\t1\u0001\u0002L\u0005qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002\u0003BI\u0005\u000b\u0003\r!a\u0013\u0002\u0017\r,(O]3oiRKW.\u001a\u0005\n\u0005+\u000by\u000b\"\u0001\u0003\u0005/\u000b\u0011\u0003\\8bIB\u0013x\u000eZ;dKJ,e\u000e\u001e:z)\u0011\tyC!'\t\u0011\tm%1\u0013a\u0001\u0003'\tQ!\u001a8uefD\u0001Ba(\u00020\u0012%!\u0011U\u0001\u0012SN\u0004&o\u001c3vG\u0016\u0014X\t\u001f9je\u0016$GCBA,\u0005G\u00139\u000b\u0003\u0005\u0003&\nu\u0005\u0019AA&\u00035\u0019WO\u001d:f]R$\u0016.\\3Ng\"A!\u0011\u0016BO\u0001\u0004\t\u0019\"A\bqe>$WoY3s\u0013\u0012,e\u000e\u001e:z\u0011!\u0011i+a,\u0005\u0002\t=\u0016A\u0006:f[>4X-\u0012=qSJ,G\r\u0015:pIV\u001cWM]:\u0015\t\u0005=\"\u0011\u0017\u0005\t\u0005K\u0013Y\u000b1\u0001\u0002L!A!QWAX\t\u0003\u00119,A\tueVt7-\u0019;f\u0003:$'+\u001a7pC\u0012$\u0002\"a\f\u0003:\nm&q\u0018\u0005\t\u0005\u001b\u0013\u0019\f1\u0001\u0002L!A!Q\u0018BZ\u0001\u0004\tY%\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0003\u0005\u0003&\nM\u0006\u0019AA&\u0011!\u0011\u0019-a,\u0005\u0002\t\u0015\u0017!\u00049sKB\f'/Z+qI\u0006$X\r\u0006\u0004\u0003H\n5'\u0011\u001b\t\u0004\u0011\t%\u0017b\u0001Bf\u0005\t\u0011\u0002K]8ek\u000e,'/\u00119qK:$\u0017J\u001c4p\u0011!\u0011yM!1A\u0002\u0005-\u0013A\u00039s_\u0012,8-\u001a:JI\"A!1\u001bBa\u0001\u0004\t9&\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000f\u0003\u0005\u0003X\u0006=F\u0011\u0001Bm\u0003\u0019)\b\u000fZ1uKR!\u0011q\u0006Bn\u0011!\u0011iN!6A\u0002\t\u001d\u0017AC1qa\u0016tG-\u00138g_\"A!\u0011]AX\t\u0003\u0011\u0019/\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BA\u0018\u0005KD\u0001Ba:\u0003`\u0002\u0007\u00111J\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\b\u0002\u0003Bv\u0003_#\tA!<\u0002\u00131\f7\u000f^#oiJLH\u0003\u0002Bx\u0005c\u0004R!\u0004B%\u0003'A\u0001Ba4\u0003j\u0002\u0007\u00111\n\u0005\t\u0005k\fy\u000b\"\u0001\u0003x\u0006aA/Y6f':\f\u0007o\u001d5piR\u0011\u0011q\u0006\u0005\t\u0005w\fy\u000b\"\u0001\u0003h\u0005!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD\u0001Ba@\u00020\u0012\u0005!qM\u0001\u0015_2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\t\u0011\r\r\u0011q\u0016C\u0005\u0007\u000b\t!#[:Qe>$WoY3s%\u0016$\u0018-\u001b8fIR1\u0011qKB\u0004\u0007\u0013A\u0001B!+\u0004\u0002\u0001\u0007\u00111\u0003\u0005\t\u0005\u001b\u001b\t\u00011\u0001\u0002L!A1QBAX\t\u0003\u0019y!\u0001\u0007ueVt7-\u0019;f\u0011\u0016\fG\r\u0006\u0003\u00020\rE\u0001\u0002\u0003BG\u0007\u0017\u0001\r!a\u0013\t\u0011\rU\u0011q\u0016C\u0005\u0007/\t\u0001E]3n_Z,WI^5di\u0016$wJ\\4pS:<GK]1og\u0006\u001cG/[8ogR!\u0011qFB\r\u0011!\u0019Yba\u0005A\u0002\ru\u0011AE3ya&\u0014X\r\u001a)s_\u0012,8-\u001a:JIN\u0004baa\b\u0004\"\u0005-SBAA\"\u0013\u0011\u0019\u0019#a\u0011\u0003\u0007M+G\u000f\u0003\u0005\u0004(\u0005=F\u0011BB\u0015\u0003y\u0011X-\\8wKVs'/\u001a9mS\u000e\fG/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u00020\r-\u0002\u0002CA=\u0007K\u0001\r!a\u0013\t\u0011\r=\u0012q\u0016C\u0001\u0005o\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0005\t\u0007g\ty\u000b\"\u0001\u00046\u0005Y1m\\7qY\u0016$X\r\u0016=o)\u0011\tYea\u000e\t\u0011\re2\u0011\u0007a\u0001\u0007w\tAbY8na2,G/\u001a3Uq:\u00042\u0001CB\u001f\u0013\r\u0019yD\u0001\u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\t\u0003c\ny\u000b\"\u0001\u0004DQ!\u0011qFB#\u0011!\tIh!\u0011A\u0002\u0005-\u0003\u0006BB!\u0007\u0013\u0002B!!.\u0004L%!1QJA\\\u0005)!\bN]3bIN\fg-\u001a\u0005\t\u0007#\ny\u000b\"\u0003\u0004T\u0005\u0011r\u000e\u001c3fgR\u001cf.\u00199tQ>$h)\u001b7f+\t\u0019)\u0006E\u0003\u000e\u0005\u0013\ni\u0002\u0003\u0005\u0004Z\u0005=F\u0011BB*\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\t\u0011\u0005\u0005\u0014q\u0016C\u0005\u0007;*\"!!\u001a)\t\u0005=6\u0011\r\t\u0005\u0003k\u001b\u0019'\u0003\u0003\u0004f\u0005]&!\u00048p]RD'/Z1eg\u00064W\r")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private final File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerIdEntry> producers;
    private long kafka$log$ProducerStateManager$$lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerIdEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerIdEntry> producers() {
        return this.producers;
    }

    public long kafka$log$ProducerStateManager$$lastMapOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset;
    }

    private void kafka$log$ProducerStateManager$$lastMapOffset_$eq(long x$1) {
        this.kafka$log$ProducerStateManager$$lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    public TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns() {
        return this.kafka$log$ProducerStateManager$$ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$4) {
                return x$4.getValue().firstOffset();
            }
        });
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$5) {
                return x$5.getValue().firstOffset();
            }
        });
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : unreplicatedFirstOffset));
    }

    public void onHighWatermarkUpdated(long highWatermark2) {
        this.removeUnreplicatedTransactions(highWatermark2);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Map.Entry<Object, TxnMetadata> x$6) {
                return x$6.getValue().firstOffset().messageOffset();
            }
        });
    }

    public long mapEndOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerIdEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromSnapshot(long logStartOffset2, long currentTime) {
        Option<File> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.x();
            try {
                this.info((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "' for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.$outer.topicPartition()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
                Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1)new Serializable(this, logStartOffset2, currentTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final long logStartOffset$3;
                    private final long currentTime$1;

                    public final boolean apply(ProducerIdEntry producerEntry) {
                        return this.$outer.kafka$log$ProducerStateManager$$isProducerRetained(producerEntry, this.logStartOffset$3) && !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTime$1, producerEntry);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logStartOffset$3 = logStartOffset$3;
                        this.currentTime$1 = currentTime$1;
                    }
                });
                loadedProducers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;

                    public final void apply(ProducerIdEntry entry2) {
                        this.$outer.loadProducerEntry(entry2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException corruptSnapshotException) {
                void var7_5;
                this.warn((Function0<String>)new Serializable(this, (File)var7_5, corruptSnapshotException){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;
                    private final CorruptSnapshotException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.e$1.getMessage()}));
                    }
                    {
                        this.file$1 = file$1;
                        this.e$1 = e$1;
                    }
                });
                boolean bl = Files.deleteIfExists(var7_5.toPath());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset2);
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerIdEntry entry2) {
        long producerId = entry2.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry2);
        entry2.currentTxnFirstOffset().foreach((Function1)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long producerId$2;

            public final TxnMetadata apply(long offset2) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)offset2), new TxnMetadata(this.producerId$2, offset2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$2 = producerId$2;
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerExpired(long currentTimeMs, ProducerIdEntry producerIdEntry) {
        return producerIdEntry.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerIdEntry.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2)new Serializable(this, currentTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long currentTimeMs$1;

            public final boolean apply(long x0$3, ProducerIdEntry x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$3), (Object)x1$1);
                if (tuple2 != null) {
                    ProducerIdEntry lastEntry2 = (ProducerIdEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTimeMs$1, lastEntry2);
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTimeMs$1 = currentTimeMs$1;
            }
        });
    }

    public void truncateAndReload(long logStartOffset2, long logEndOffset2, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)new Serializable(this, logStartOffset2, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;
            private final long logEndOffset$1;

            public final boolean apply(long snapOffset) {
                return this.apply$mcZJ$sp(snapOffset);
            }

            public boolean apply$mcZJ$sp(long snapOffset) {
                return snapOffset > this.logEndOffset$1 || snapOffset <= this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
                this.logEndOffset$1 = logEndOffset$1;
            }
        });
        if (logEndOffset2 != this.mapEndOffset()) {
            this.producers().clear();
            this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset2, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset2);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (isFromClient) {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        } else {
            product = ValidationType$None$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        return new ProducerAppendInfo(producerId, (ProducerIdEntry)this.lastEntry(producerId).getOrElse((Function0)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final long producerId$1;

            public final ProducerIdEntry apply() {
                return ProducerIdEntry$.MODULE$.empty(this.producerId$1);
            }
            {
                this.producerId$1 = producerId$1;
            }
        }), validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())})));
        }
        this.trace((Function0<String>)new Serializable(this, appendInfo){
            public static final long serialVersionUID = 0L;
            private final ProducerAppendInfo appendInfo$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.appendInfo$1.producerId()), this.appendInfo$1}));
            }
            {
                this.appendInfo$1 = appendInfo$1;
            }
        });
        ProducerIdEntry entry2 = appendInfo.latestEntry();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)entry2);
        appendInfo.startedTransactions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;

            public final TxnMetadata apply(TxnMetadata txn) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), txn);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateMapEndOffset(long lastOffset) {
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerIdEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() > this.lastSnapOffset()) {
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.kafka$log$ProducerStateManager$$lastMapOffset());
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot for partition ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$ProducerStateManager$$lastMapOffset())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.kafka$log$ProducerStateManager$$lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerRetained(ProducerIdEntry producerIdEntry, long logStartOffset2) {
        producerIdEntry.removeBatchesOlderThan(logStartOffset2);
        return producerIdEntry.lastDataOffset() >= logStartOffset2;
    }

    public void truncateHead(long logStartOffset2) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1)new Serializable(this, logStartOffset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long logStartOffset$2;

            public final boolean apply(Tuple2<Object, ProducerIdEntry> x0$4) {
                Tuple2<Object, ProducerIdEntry> tuple2 = x0$4;
                if (tuple2 != null) {
                    ProducerIdEntry producerIdEntry = (ProducerIdEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerRetained(producerIdEntry, this.logStartOffset$2);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logStartOffset$2 = logStartOffset$2;
            }
        });
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset2);
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() < logStartOffset2) {
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
        }
        this.deleteSnapshotsBefore(logStartOffset2);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)new Serializable(this, logStartOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$2;
            }
            {
                this.logStartOffset$2 = logStartOffset$2;
            }
        })));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.kafka$log$ProducerStateManager$$ongoingTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator2.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset2) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.unreplicatedTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)new Serializable(this, offset2){
                public static final long serialVersionUID = 0L;
                private final long offset$3;

                public final boolean apply(long x$7) {
                    return this.apply$mcZJ$sp(x$7);
                }

                public boolean apply$mcZJ$sp(long x$7) {
                    return x$7 < this.offset$3;
                }
                {
                    this.offset$3 = offset$3;
                }
            })) continue;
            iterator2.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.kafka$log$ProducerStateManager$$ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException("Attempted to complete a transaction which was not started");
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset2 = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.completedTxn$1.lastOffset() + 1L;
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        }));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset2) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset2);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging$class.$init$(this);
        this.producers = Map$.MODULE$.empty();
        this.kafka$log$ProducerStateManager$$lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.kafka$log$ProducerStateManager$$ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

