/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogSegment;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\nT\"\u0001\u0019\u000b\u0005E\t\u0013B\u0001\u001a1\u0005\u0011!\u0016.\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011\u0011BN\u0005\u0003o)\u0011A\u0001T8oO\"A\u0011\b\u0001BA\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0004\u0013qr\u0014BA\u001f\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011q(Q\u0007\u0002\u0001*\u0011\u0011\bB\u0005\u0003\u0005\u0002\u00131\u0001T8h\u0011!!\u0005A!a\u0001\n\u0003)\u0015a\u00027pO~#S-\u001d\u000b\u0003\r&\u0003\"!C$\n\u0005!S!\u0001B+oSRDqAS\"\u0002\u0002\u0003\u00071(A\u0002yIEB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006KaO\u0001\u0005Y><\u0007\u0005\u000b\u0002L\u001dB\u0011\u0011bT\u0005\u0003!*\u0011\u0001B^8mCRLG.\u001a\u0005\u0006%\u0002!\taU\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ3v\u000bW-[!\t)\u0006!D\u0001\u0003\u0011\u0015)\u0012\u000b1\u0001\u0018\u0011\u0015i\u0012\u000b1\u0001 \u0011\u001di\u0013\u000b%AA\u00029Bq\u0001N)\u0011\u0002\u0003\u0007Q\u0007C\u0004:#B\u0005\t\u0019A\u001e\t\rq\u0003\u0001\u0015)\u0003^\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\rM,'O^3s\u0013\t\u0011wLA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006D#a\u0017(\t\r\u0015\u0004\u0001\u0015)\u0003^\u0003QawnZ#oI>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u0012AM\u0014\u0005\u0007Q\u0002\u0001\u000b\u0015B\u001b\u0002\u001f}cwnZ*uCJ$xJ\u001a4tKRD#a\u001a(\t\r-\u0004\u0001\u0015)\u00036\u0003ma\u0017m\u001d;GKR\u001c\u0007\u000eT3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\"\u0012!N\u0014\u0005\u0007]\u0002\u0001\u000b\u0015B\u001b\u0002\u001f1\f7\u000f\u001e$fi\u000eDG+[7f\u001bND#!\u001c(\t\rE\u0004\u0001\u0015)\u00036\u0003MyF.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z'tQ\t\u0001h\nC\u0003u\u0001\u0011\u0005Q/A\u0004jg2{7-\u00197\u0016\u0003Y\u0004\"!C<\n\u0005aT!a\u0002\"p_2,\u0017M\u001c\u0005\u0006u\u0002!\ta_\u0001\u0013Y\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/F\u00016\u0011\u001di\bA1A\u0005\u0002y\fa!\u001a9pG\"\u001cX#A@\u0011\t%a\u0014\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA0\u0002\u000b\u0015\u0004xn\u00195\n\t\u0005-\u0011Q\u0001\u0002\u0011\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nQ1dQ\u0016Dq!a\u0004\u0001A\u0003%q0A\u0004fa>\u001c\u0007n\u001d\u0011\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\u0019R\u000f\u001d3bi\u0016dun\u001a*fC\u0012\u0014Vm];miR\u0019a)a\u0006\t\u0011\u0005e\u0011\u0011\u0003a\u0001\u00037\tQ\u0002\\8h%\u0016\fGMU3tk2$\bc\u00010\u0002\u001e%\u0019\u0011qD0\u0003\u001b1{wMU3bIJ+7/\u001e7u\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tQC]3tKRd\u0015m\u001d;DCV<\u0007\u000e^+q)&lW\rF\u0004G\u0003O\tY#a\f\t\u000f\u0005%\u0012\u0011\u0005a\u0001k\u0005)2-\u001e:MK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\bbBA\u0017\u0003C\u0001\r!N\u0001\nGV\u0014H+[7f\u001bNDaA_A\u0011\u0001\u0004)\u0004bBA\u001a\u0001\u0011%\u0011QG\u0001\u0011Y><WI\u001c3PM\u001a\u001cX\r^0%KF$2ARA\u001c\u0011\u001d\tI$!\rA\u0002u\u000bqB\\3x\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003{\u0001A\u0011AA \u00031awnZ#oI>3gm]3u+\u0005i\u0006bBA\"\u0001\u0011\u0005\u0011QI\u0001\u001d[\u0006L(-Z%oGJ,W.\u001a8u\u0019><7\u000b^1si>3gm]3u)\r1\u0015q\t\u0005\b\u0003\u0013\n\t\u00051\u00016\u0003EqWm\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003IawnZ*uCJ$xJ\u001a4tKR|F%Z9\u0015\u0007\u0019\u000b\t\u0006C\u0004\u0002J\u0005-\u0003\u0019A\u001b\t\r\u0005U\u0003\u0001\"\u0001|\u00039awnZ*uCJ$xJ\u001a4tKRDq!!\u0017\u0001\t\u0003\tY&A\tiS\u001eDw+\u0019;fe6\f'o[0%KF$2ARA/\u0011\u001d\ty&a\u0016A\u0002u\u000b\u0001C\\3x\u0011&<\u0007nV1uKJl\u0017M]6\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002@\u0005i\u0001.[4i/\u0006$XM]7be.Dq!a\u001a\u0001\t\u0003\ty$\u0001\tmCN$8\u000b^1cY\u0016|eMZ:fi\"9\u00111\u000e\u0001\u0005\u0002\u00055\u0014AH2p]Z,'\u000f\u001e%X)>dunY1m\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\u00051\u0005bBA9\u0001\u0011\u0005\u00131O\u0001\u0007KF,\u0018\r\\:\u0015\u0007Y\f)\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003\u0011!\b.\u0019;\u0011\u0007%\tY(C\u0002\u0002~)\u00111!\u00118z\u0011\u001d\t\t\t\u0001C!\u0003\u0007\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002/!9\u0011q\u0011\u0001\u0005B\u0005%\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0005\u0003BAG\u0003's1!CAH\u0013\r\t\tJC\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0015q\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E%bB\u0005\u0002\u001c\n\t\t\u0011#\u0001\u0002\u001e\u00069!+\u001a9mS\u000e\f\u0007cA+\u0002 \u001aA\u0011AAA\u0001\u0012\u0003\t\tkE\u0002\u0002 \"AqAUAP\t\u0003\t)\u000b\u0006\u0002\u0002\u001e\"Q\u0011\u0011VAP#\u0003%\t!a+\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiKK\u0002/\u0003_[#!!-\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wS\u0011AC1o]>$\u0018\r^5p]&!\u0011qXA[\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u0007\fy*%A\u0005\u0002\u0005\u0015\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002H*\u001aQ'a,\t\u0015\u0005-\u0017qTI\u0001\n\u0003\ti-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u001fT3aOAX\u0001")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    public final long kafka$cluster$Replica$$initialHighWatermarkValue;
    private volatile Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private final Option<LeaderEpochCache> epochs;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public void log_$eq(Option<Log> x$1) {
        this.log = x$1;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public Option<LeaderEpochCache> epochs() {
        return this.epochs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log end offset on partition ", "'s local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log end offset for replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public void maybeIncrementLogStartOffset(long newLogStartOffset) {
        if (this.isLocal()) {
            if (newLogStartOffset > this.highWatermark().messageOffset()) {
                throw new OffsetOutOfRangeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot increment the log start offset to ", " of partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset), this.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since it is larger than the high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark().messageOffset())}))).toString());
            }
            ((Log)this.log().get()).maybeIncrementLogStartOffset(newLogStartOffset);
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not try to delete records on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log start offset on partition ", "'s local replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"without attempting to delete records of the log"})).s((Seq)Nil$.MODULE$)).toString());
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)new Serializable(this, newLogStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;
            private final long newLogStartOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log start offset for remote replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.newLogStartOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newLogStartOffset$1 = newLogStartOffset$1;
            }
        });
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            if (newHighWatermark.messageOffset() < 0L) {
                throw new IllegalArgumentException("High watermark offset should be non-negative");
            }
            this.highWatermarkMetadata = newHighWatermark;
            this.log().foreach((Function1)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final LogOffsetMetadata newHighWatermark$1;

                public final void apply(Log x$3) {
                    x$3.onHighWatermarkIncremented(this.newHighWatermark$1.messageOffset());
                }
                {
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            this.trace((Function0<String>)new Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting high watermark for replica ", " partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topicPartition(), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final LogOffsetMetadata apply(Log log) {
                Some some;
                LogOffsetMetadata offsetMetadata;
                Option<LogOffsetMetadata> option = log.firstUnstableOffset();
                LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).x()).messageOffset() < this.$outer.highWatermark().messageOffset() ? offsetMetadata : this.$outer.highWatermark();
                return logOffsetMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final Nothing$ apply() {
                throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fetch last stable offset on partition ", "'s "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId())}))).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;

                public final LogOffsetMetadata apply() {
                    return (LogOffsetMetadata)((Log)this.$outer.log().get()).convertToOffsetMetadata(this.$outer.logStartOffset()).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$convertHWToLocalOffsetMetadata$1 $outer;

                        public final LogOffsetMetadata apply() {
                            long firstSegmentOffset = ((LogSegment)((Log)this.$outer.kafka$cluster$Replica$$anonfun$$$outer().log().get()).logSegments().head()).baseOffset();
                            return new LogOffsetMetadata(firstSegmentOffset, firstSegmentOffset, 0);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ Replica kafka$cluster$Replica$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not construct complete high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topicPartition().topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLocal())).toString());
        replicaString.append(new StringBuilder().append((Object)"; lastCaughtUpTimeMs: ").append((Object)BoxesRunTime.boxToLong((long)this.lastCaughtUpTimeMs())).toString());
        if (this.isLocal()) {
            replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append((Object)this.highWatermark()).toString());
            boxedUnit = replicaString.append(new StringBuilder().append((Object)"; LastStableOffset: ").append((Object)this.lastStableOffset()).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return replicaString.toString();
    }

    public Replica(int brokerId, TopicPartition topicPartition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.kafka$cluster$Replica$$initialHighWatermarkValue = initialHighWatermarkValue;
        this.log = log;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.epochs = this.log().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderEpochCache apply(Log x$1) {
                return x$1.leaderEpochCache();
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica loaded for partition ", " with initial high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicPartition(), BoxesRunTime.boxToLong((long)this.$outer.kafka$cluster$Replica$$initialHighWatermarkValue)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.log().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final void apply(Log x$2) {
                x$2.onHighWatermarkIncremented(this.$outer.kafka$cluster$Replica$$initialHighWatermarkValue);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

