/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.Logging$class;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Aa\u0002\u0006\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0011D\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\r\r|gNZ5h+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!e\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\u0006\u0001\u0003\u0006\u0004%\tAJ\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011qC\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005O\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\u001e\u000e\u0003iR!!\u0005\u0016\n\u0005qR$\u0001\u0002+j[\u0016D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0006i&lW\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003!\u0019XmY;sSRL\u0018BA$E\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\t\u0011%\u0003!\u0011!Q\u0001\n\t\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u000eK\u0001\u0004i\u0002\"B\fK\u0001\u00049\u0003\"\u0002\u001cK\u0001\u0004A\u0004\"\u0002!K\u0001\u0004\u0011\u0005b\u0002+\u0001\u0005\u0004%I!V\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cX#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n9\u0011J\u001c;fO\u0016\u0014\bBB0\u0001A\u0003%a+\u0001\nnCb\fV/Z;fIJ+\u0017/^3tiN\u0004\u0003bB1\u0001\u0005\u0004%I!V\u0001\u0014[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n\u001d\u0005\u0007G\u0002\u0001\u000b\u0011\u0002,\u0002)5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139!\u0011\u001d)\u0007A1A\u0005\n\u0019\fA$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7/F\u0001h!\u0011A7.\u001c;\u000e\u0003%T!A\u001b\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\n\u0019Q*\u00199\u0011\u00059\fhBA\u0005p\u0013\t\u0001(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019\u000b!\tIQ/\u0003\u0002w\u0015\t\u0019\u0011J\u001c;\t\ra\u0004\u0001\u0015!\u0003h\u0003ui\u0017\r_\"p]:,7\r^5p]N\u0004VM]%q\u001fZ,'O]5eKN\u0004\u0003b\u0002>\u0001\u0005\u0004%Ia_\u0001\u000bY><7i\u001c8uKb$X#\u0001?\u0011\u0005ej\u0018B\u0001@;\u0005)aunZ\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003}\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0011\u0001E7f[>\u0014\u0018\u0010U8pYN+gn]8s+\t\tI\u0001E\u0002)\u0003\u0017I1!!\u0004*\u0005\u0019\u0019VM\\:pe\"A\u0011\u0011\u0003\u0001!\u0002\u0013\tI!A\tnK6|'/\u001f)p_2\u001cVM\\:pe\u0002B\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u0002G5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a)fe\u000e,g\u000e^'fiJL7MT1nKV\u0011\u0011\u0011\u0004\t\u0005\u00037\ti\"D\u0001+\u0013\r\tyB\u000b\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\u0002CA\u0012\u0001\u0001\u0006I!!\u0007\u0002I5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a)fe\u000e,g\u000e^'fiJL7MT1nK\u0002B\u0011\"a\n\u0001\u0005\u0004%I!a\u0006\u0002A5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a+j[\u0016lU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u001a\u0005\tS.Z7pef\u0004vn\u001c7EKBdW\r^3e)&lW-T3ue&\u001cg*Y7fA!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011G\u0001\u000b[\u0016lwN]=Q_>dWCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dU\u00051Q.Z7pefLA!!\u0010\u00028\tQQ*Z7pef\u0004vn\u001c7\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003g\t1\"\\3n_JL\bk\\8mA!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011qI\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\t\tI\u0005E\u0002O\u0003\u0017J1!!\u0014\u0003\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2D\u0001\"!\u0015\u0001A\u0003%\u0011\u0011J\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011qK\u0001\u000baJ|7-Z:t_J\u001cXCAA-!\u001d\tY&!\u001au\u0003Sj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u000bG>t7-\u001e:sK:$(bAA25\u0006!Q\u000f^5m\u0013\u0011\t9'!\u0018\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002O\u0003WJ1!!\u001c\u0003\u0005%\u0001&o\\2fgN|'\u000f\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA-\u0003-\u0001(o\\2fgN|'o\u001d\u0011\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005]\u0014a\u00048fqR\u0004&o\\2fgN|'/\u00133\u0016\u0003QD\u0011\"a\u001f\u0001\u0001\u0004%I!! \u0002'9,\u0007\u0010\u001e)s_\u000e,7o]8s\u0013\u0012|F%Z9\u0015\t\u0005}\u0014Q\u0011\t\u0004\u0013\u0005\u0005\u0015bAAB\u0015\t!QK\\5u\u0011%\t9)!\u001f\u0002\u0002\u0003\u0007A/A\u0002yIEBq!a#\u0001A\u0003&A/\u0001\toKb$\bK]8dKN\u001cxN]%eA!Q\u0011q\u0012\u0001C\u0002\u0013\u0005!!!%\u0002\u0013\u0005\u001c7-\u001a9u_J\u001cXCAAJ!!\tY&!\u001a\u0002\u0016\u0006\u0005\u0006\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mE!A\u0004dYV\u001cH/\u001a:\n\t\u0005}\u0015\u0011\u0014\u0002\t\u000b:$\u0007k\\5oiB\u0019a*a)\n\u0007\u0005\u0015&A\u0001\u0005BG\u000e,\u0007\u000f^8s\u0011!\tI\u000b\u0001Q\u0001\n\u0005M\u0015AC1dG\u0016\u0004Ho\u001c:tA!Y\u0011Q\u0016\u0001A\u0002\u0003\u0007I\u0011BAX\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/\u0006\u0002\u00022B\u0019a*a-\n\u0007\u0005U&A\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\"Y\u0011\u0011\u0018\u0001A\u0002\u0003\u0007I\u0011BA^\u0003Q\u0019wN\u001c8fGRLwN\\)v_R\f7o\u0018\u0013fcR!\u0011qPA_\u0011)\t9)a.\u0002\u0002\u0003\u0007\u0011\u0011\u0017\u0005\t\u0003\u0003\u0004\u0001\u0015)\u0003\u00022\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\t\u0013\u0005\u0015\u0007\u00011A\u0005\n\u0005\u001d\u0017!G:u_B\u0004X\r\u001a)s_\u000e,7o]5oOJ+\u0017/^3tiN,\"!!3\u0011\u0007%\tY-C\u0002\u0002N*\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002R\u0002\u0001\r\u0011\"\u0003\u0002T\u0006i2\u000f^8qa\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\u0005U\u0007BCAD\u0003\u001f\f\t\u00111\u0001\u0002J\"A\u0011\u0011\u001c\u0001!B\u0013\tI-\u0001\u000eti>\u0004\b/\u001a3Qe>\u001cWm]:j]\u001e\u0014V-];fgR\u001c\b\u0005C\u0004\u0002^\u0002!\t!a8\u0002\u000fM$\u0018M\u001d;vaR\u0011\u0011q\u0010\u0005\b\u0003G\u0004A\u0011BAs\u0003%)g\u000e\u001a9pS:$8/\u0006\u0002\u0002hBA\u0011\u0011^Ax\u0003c\f)*\u0004\u0002\u0002l*\u0019\u0011Q^5\u0002\u0013%lW.\u001e;bE2,\u0017b\u00017\u0002lB!\u00111_A|\u001b\t\t)P\u0003\u0002\u0004U%!\u0011\u0011`A{\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007f\f1d\u0019:fCR,\u0017iY2faR|'/\u00118e!J|7-Z:t_J\u001cHCBA@\u0005\u0003\u0011)\u0001C\u0004\u0003\u0004\u0005m\b\u0019\u0001;\u0002+A\u0014xnY3tg>\u00148\u000fU3s\u0019&\u001cH/\u001a8fe\"A\u00111]A~\u0001\u0004\u00119\u0001E\u0003i\u0005\u0013\t)*C\u0002\u0003\f%\u00141aU3r\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#\tQ\"\u00193e!J|7-Z:t_J\u001cH\u0003CA@\u0005'\u00119Ba\u0007\t\u0011\tU!Q\u0002a\u0001\u0003C\u000b\u0001\"Y2dKB$xN\u001d\u0005\t\u00053\u0011i\u00011\u0001\u0002\u0016\u0006AQM\u001c3q_&tG\u000fC\u0004\u0003\u001e\t5\u0001\u0019\u0001;\u000219,w\u000f\u0015:pG\u0016\u001c8o\u001c:t!\u0016\u0014H*[:uK:,'\u000fC\u0004\u0003\"\u0001!\t!a8\u0002-M$x\u000e\u001d)s_\u000e,7o]5oOJ+\u0017/^3tiNDqA!\n\u0001\t\u0003\u00119#\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR1\u0011q\u0010B\u0015\u0005[AqAa\u000b\u0003$\u0001\u0007A/\u0001\u000bpY\u0012tU/\u001c(fi^|'o\u001b+ie\u0016\fGm\u001d\u0005\b\u0005_\u0011\u0019\u00031\u0001u\u0003QqWm\u001e(v[:+Go^8sWRC'/Z1eg\"9!1\u0007\u0001\u0005\u0002\u0005}\u0017\u0001C:ikR$wn\u001e8\t\u000f\t]\u0002\u0001\"\u0001\u0003:\u0005I!m\\;oIB{'\u000f\u001e\u000b\u0004i\nm\u0002\u0002\u0003B\u001f\u0005k\u0001\r!!=\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D\u0005a\u0011\r\u001a3MSN$XM\\3sgR!\u0011q\u0010B#\u0011!\u00119Ea\u0010A\u0002\t\u001d\u0011A\u00047jgR,g.\u001a:t\u0003\u0012$W\r\u001a\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0003=\u0011X-\\8wK2K7\u000f^3oKJ\u001cH\u0003BA@\u0005\u001fB\u0001B!\u0015\u0003J\u0001\u0007!qA\u0001\u0011Y&\u001cH/\u001a8feN\u0014V-\\8wK\u0012D\u0001B!\u0016\u0001\t#\u0011!qK\u0001\r]\u0016<\bK]8dKN\u001cxN\u001d\u000b\r\u0003S\u0012IF!\u0018\u0003`\t\u0005$1\u000f\u0005\b\u00057\u0012\u0019\u00061\u0001u\u0003\tIG\r\u0003\u0005\u0002.\nM\u0003\u0019AAY\u0011!\u0011iDa\u0015A\u0002\u0005E\b\u0002\u0003B2\u0005'\u0002\rA!\u001a\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003\u0002B4\u0005_j!A!\u001b\u000b\t\t-$QN\u0001\u0005CV$\bN\u0003\u0002FU%!!\u0011\u000fB5\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000e\u0003\u0005\u00020\tM\u0003\u0019AA\u001a\u0011!\u00119\b\u0001C\u0001\u0005\te\u0014aD2p]:,7\r^5p]\u000e{WO\u001c;\u0015\u0007Q\u0014Y\b\u0003\u0005\u0003~\tU\u0004\u0019\u0001B@\u0003\u001d\tG\r\u001a:fgN\u0004BA!!\u0003\b6\u0011!1\u0011\u0006\u0004\u0005\u000bS\u0016a\u00018fi&!!\u0011\u0012BB\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\t\u0011\t5\u0005\u0001\"\u0001\u0003\u0005\u001f\u000b\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u0015\t\u0005%$\u0011\u0013\u0005\b\u0005'\u0013Y\t1\u0001u\u0003\u0015Ig\u000eZ3y\u0001")
public class SocketServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final Integer maxQueuedRequests;
    private final Integer maxConnectionsPerIp;
    private final Map<String, Object> maxConnectionsPerIpOverrides;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool kafka$network$SocketServer$$memoryPool;
    private final RequestChannel requestChannel;
    private final ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors;
    private int kafka$network$SocketServer$$nextProcessorId;
    private final ConcurrentHashMap<EndPoint, Acceptor> acceptors;
    private ConnectionQuotas kafka$network$SocketServer$$connectionQuotas;
    private boolean stoppedProcessingRequests;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    private Integer maxConnectionsPerIp() {
        return this.maxConnectionsPerIp;
    }

    private Map<String, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    public MemoryPool kafka$network$SocketServer$$memoryPool() {
        return this.kafka$network$SocketServer$$memoryPool;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors() {
        return this.kafka$network$SocketServer$$processors;
    }

    public int kafka$network$SocketServer$$nextProcessorId() {
        return this.kafka$network$SocketServer$$nextProcessorId;
    }

    public void kafka$network$SocketServer$$nextProcessorId_$eq(int x$1) {
        this.kafka$network$SocketServer$$nextProcessorId = x$1;
    }

    public ConcurrentHashMap<EndPoint, Acceptor> acceptors() {
        return this.acceptors;
    }

    public ConnectionQuotas kafka$network$SocketServer$$connectionQuotas() {
        return this.kafka$network$SocketServer$$connectionQuotas;
    }

    private void kafka$network$SocketServer$$connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.kafka$network$SocketServer$$connectionQuotas = x$1;
    }

    private boolean stoppedProcessingRequests() {
        return this.stoppedProcessingRequests;
    }

    private void stoppedProcessingRequests_$eq(boolean x$1) {
        this.stoppedProcessingRequests = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.kafka$network$SocketServer$$connectionQuotas_$eq(new ConnectionQuotas(Predef$.MODULE$.Integer2int(this.maxConnectionsPerIp()), this.maxConnectionsPerIpOverrides()));
            this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), this.config().listeners());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : socketServer
            this.newGauge("NetworkProcessorAvgIdlePercent", new Gauge<Object>(this){
                private final /* synthetic */ SocketServer $outer;

                public double value() {
                    SocketServer socketServer = this.$outer;
                    synchronized (socketServer) {
                        Iterable ioWaitRatioMetricNames = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.kafka$network$SocketServer$$processors().values()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final MetricName apply(Processor p) {
                                return this.$outer.kafka$network$SocketServer$$anon$$$outer().metrics().metricName("io-wait-ratio", "socket-server-metrics", p.metricTags());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                        Double d = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ioWaitRatioMetricNames.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final double apply(MetricName metricName) {
                                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$SocketServer$$anon$$$outer().metrics().metric(metricName)).fold((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply() {
                                        return this.apply$mcD$sp();
                                    }

                                    public double apply$mcD$sp() {
                                        return 0.0;
                                    }
                                }, (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(KafkaMetric x$1) {
                                        return x$1.value();
                                    }
                                }));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.$outer.kafka$network$SocketServer$$processors().size()));
                        return BoxesRunTime.unboxToDouble((Object)d);
                    }
                }

                public /* synthetic */ SocketServer kafka$network$SocketServer$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
        }
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().size() - this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.acceptors().size())).append((Object)" acceptor threads").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((TraversableOnce)this.config().listeners().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ListenerName, EndPoint> apply(EndPoint l) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), (Object)l);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private synchronized void createAcceptorAndProcessors(int processorsPerListener, Seq<EndPoint> endpoints2) {
        Integer sendBufferSize = this.config().socketSendBufferBytes();
        Integer recvBufferSize = this.config().socketReceiveBufferBytes();
        int brokerId = this.config().brokerId();
        endpoints2.foreach((Function1)new Serializable(this, processorsPerListener, sendBufferSize, recvBufferSize, brokerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServer $outer;
            private final int processorsPerListener$1;
            private final Integer sendBufferSize$1;
            private final Integer recvBufferSize$1;
            private final int brokerId$1;

            public final void apply(EndPoint endpoint) {
                ListenerName listenerName = endpoint.listenerName();
                SecurityProtocol securityProtocol2 = endpoint.securityProtocol();
                Acceptor acceptor = new Acceptor(endpoint, Predef$.MODULE$.Integer2int(this.sendBufferSize$1), Predef$.MODULE$.Integer2int(this.recvBufferSize$1), this.brokerId$1, this.$outer.kafka$network$SocketServer$$connectionQuotas());
                KafkaThread.nonDaemon((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-socket-acceptor-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName, securityProtocol2, BoxesRunTime.boxToInteger((int)endpoint.port())})), (Runnable)acceptor).start();
                acceptor.awaitStartup();
                this.$outer.acceptors().put(endpoint, acceptor);
                this.$outer.kafka$network$SocketServer$$addProcessors(acceptor, endpoint, this.processorsPerListener$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processorsPerListener$1 = processorsPerListener$1;
                this.sendBufferSize$1 = sendBufferSize$1;
                this.recvBufferSize$1 = recvBufferSize$1;
                this.brokerId$1 = brokerId$1;
            }
        });
    }

    public synchronized void kafka$network$SocketServer$$addProcessors(Acceptor acceptor, EndPoint endpoint, int newProcessorsPerListener) {
        ListenerName listenerName = endpoint.listenerName();
        SecurityProtocol securityProtocol2 = endpoint.securityProtocol();
        ArrayBuffer listenerProcessors = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newProcessorsPerListener).foreach$mVc$sp((Function1)new Serializable(this, listenerName, securityProtocol2, listenerProcessors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServer $outer;
            private final ListenerName listenerName$1;
            private final SecurityProtocol securityProtocol$1;
            private final ArrayBuffer listenerProcessors$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                Processor processor = this.$outer.newProcessor(this.$outer.kafka$network$SocketServer$$nextProcessorId(), this.$outer.kafka$network$SocketServer$$connectionQuotas(), this.listenerName$1, this.securityProtocol$1, this.$outer.kafka$network$SocketServer$$memoryPool());
                this.listenerProcessors$1.$plus$eq((Object)processor);
                this.$outer.requestChannel().addProcessor(processor);
                this.$outer.kafka$network$SocketServer$$nextProcessorId_$eq(this.$outer.kafka$network$SocketServer$$nextProcessorId() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listenerName$1 = listenerName$1;
                this.securityProtocol$1 = securityProtocol$1;
                this.listenerProcessors$1 = listenerProcessors$1;
            }
        });
        listenerProcessors.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServer $outer;

            public final Processor apply(Processor p) {
                return this.$outer.kafka$network$SocketServer$$processors().put(BoxesRunTime.boxToInteger((int)p.id()), p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        acceptor.addProcessors((Buffer<Processor>)listenerProcessors);
    }

    public void stopProcessingRequests() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping socket server request processors";
            }
        });
        SocketServer socketServer = this;
        synchronized (socketServer) {
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Acceptor x$2) {
                    x$2.shutdown();
                }
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.kafka$network$SocketServer$$processors()).asScala()).values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Processor x$3) {
                    x$3.shutdown();
                }
            });
            this.requestChannel().clear();
            this.stoppedProcessingRequests_$eq(true);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped socket server request processors";
                }
            });
            return;
        }
    }

    public synchronized void resizeThreadPool(int oldNumNetworkThreads, int newNumNetworkThreads) {
        this.info((Function0<String>)new Serializable(this, oldNumNetworkThreads, newNumNetworkThreads){
            public static final long serialVersionUID = 0L;
            private final int oldNumNetworkThreads$1;
            private final int newNumNetworkThreads$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing network thread pool size for each listener from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.oldNumNetworkThreads$1), BoxesRunTime.boxToInteger((int)this.newNumNetworkThreads$1)}));
            }
            {
                this.oldNumNetworkThreads$1 = oldNumNetworkThreads$1;
                this.newNumNetworkThreads$1 = newNumNetworkThreads$1;
            }
        });
        if (newNumNetworkThreads > oldNumNetworkThreads) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).foreach((Function1)new Serializable(this, oldNumNetworkThreads, newNumNetworkThreads){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServer $outer;
                private final int oldNumNetworkThreads$1;
                private final int newNumNetworkThreads$1;

                public final void apply(Tuple2<EndPoint, Acceptor> x0$1) {
                    Tuple2<EndPoint, Acceptor> tuple2 = x0$1;
                    if (tuple2 != null) {
                        EndPoint endpoint = (EndPoint)tuple2._1();
                        Acceptor acceptor = (Acceptor)tuple2._2();
                        this.$outer.kafka$network$SocketServer$$addProcessors(acceptor, endpoint, this.newNumNetworkThreads$1 - this.oldNumNetworkThreads$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.oldNumNetworkThreads$1 = oldNumNetworkThreads$1;
                    this.newNumNetworkThreads$1 = newNumNetworkThreads$1;
                }
            });
        } else if (newNumNetworkThreads < oldNumNetworkThreads) {
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1)new Serializable(this, oldNumNetworkThreads, newNumNetworkThreads){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServer $outer;
                private final int oldNumNetworkThreads$1;
                private final int newNumNetworkThreads$1;

                public final void apply(Acceptor x$4) {
                    x$4.removeProcessors(this.oldNumNetworkThreads$1 - this.newNumNetworkThreads$1, this.$outer.requestChannel());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.oldNumNetworkThreads$1 = oldNumNetworkThreads$1;
                    this.newNumNetworkThreads$1 = newNumNetworkThreads$1;
                }
            });
        }
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down socket server";
            }
        });
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.stoppedProcessingRequests()) {
                this.stopProcessingRequests();
            }
            this.requestChannel().shutdown();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Shutdown completed";
                }
            });
            return;
        }
    }

    public int boundPort(ListenerName listenerName) {
        try {
            return this.acceptors().get(this.endpoints().apply((Object)listenerName)).serverChannel().socket().getLocalPort();
        }
        catch (Exception exception) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", exception);
        }
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        this.info((Function0<String>)new Serializable(this, listenersAdded){
            public static final long serialVersionUID = 0L;
            private final Seq listenersAdded$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding listeners for endpoints ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenersAdded$1}));
            }
            {
                this.listenersAdded$1 = listenersAdded$1;
            }
        });
        this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), listenersAdded);
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)new Serializable(this, listenersRemoved){
            public static final long serialVersionUID = 0L;
            private final Seq listenersRemoved$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing listeners for endpoints ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenersRemoved$1}));
            }
            {
                this.listenersRemoved$1 = listenersRemoved$1;
            }
        });
        listenersRemoved.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServer $outer;

            public final void apply(EndPoint endpoint) {
                ((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.$outer.acceptors()).asScala()).remove((Object)endpoint).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Acceptor x$5) {
                        x$5.shutdown();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol securityProtocol2, MemoryPool memoryPool) {
        return new Processor(id, this.time(), Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel(), connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), listenerName, securityProtocol2, this.config(), this.metrics(), this.credentialProvider(), memoryPool, this.logContext());
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.kafka$network$SocketServer$$connectionQuotas()).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }, (Function1)new Serializable(this, address){
            public static final long serialVersionUID = 0L;
            private final InetAddress address$1;

            public final int apply(ConnectionQuotas x$6) {
                return x$6.get(this.address$1);
            }
            {
                this.address$1 = address$1;
            }
        }));
    }

    public Processor processor(int index) {
        return this.kafka$network$SocketServer$$processors().get(BoxesRunTime.boxToInteger((int)index));
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.maxConnectionsPerIp = config.maxConnectionsPerIp();
        this.maxConnectionsPerIpOverrides = config.maxConnectionsPerIpOverrides();
        this.logContext = new LogContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SocketServer brokerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", "socket-server-metrics");
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", "socket-server-metrics");
        this.memoryPoolSensor().add((CompoundStat)new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.kafka$network$SocketServer$$memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.requestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()));
        this.kafka$network$SocketServer$$processors = new ConcurrentHashMap();
        this.kafka$network$SocketServer$$nextProcessorId = 0;
        this.acceptors = new ConcurrentHashMap();
        this.stoppedProcessingRequests = false;
    }
}

